/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PushRequest
extends Message
implements Serializable {
    private byte[] payload;

    public PushRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)64, ttl, hops, 26);
        Assert.that(payload.length == 26);
        this.payload = payload;
    }

    public PushRequest(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port) {
        super(guid, (byte)64, ttl, (byte)0, 26);
        Assert.that(clientGUID.length == 16);
        Assert.that((index & 0xFFFFFFFF00000000L) == 0L);
        Assert.that(ip.length == 4);
        Assert.that((port & 0xFFFF0000) == 0);
        this.payload = new byte[26];
        System.arraycopy(clientGUID, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)index, this.payload, 16);
        this.payload[20] = ip[0];
        this.payload[21] = ip[1];
        this.payload[22] = ip[2];
        this.payload[23] = ip[3];
        ByteOrder.short2leb((short)port, this.payload, 24);
    }

    protected void writePayload(OutputStream out) throws IOException {
        int i = 0;
        while (i < this.payload.length) {
            out.write(this.payload[i]);
            ++i;
        }
    }

    public byte[] getClientGUID() {
        byte[] ret = new byte[16];
        System.arraycopy(this.payload, 0, ret, 0, 16);
        return ret;
    }

    public long getIndex() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 16));
    }

    public byte[] getIP() {
        byte[] ret = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return ret;
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 24));
    }

    public String toString() {
        return "PushRequest(" + super.toString() + ")";
    }
}

