/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.Response;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class QueryReply
extends Message
implements Serializable {
    private byte[] payload;
    private volatile boolean parsed = false;
    private volatile Response[] responses = null;
    private volatile String vendor = null;
    private volatile int pushFlag = -1;
    private volatile int busyFlag = -1;
    private volatile int uploadedFlag = -1;
    private volatile int measuredSpeedFlag = -1;
    private volatile int supportsChat = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, false, false, false, false, false, false);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat);
    }

    private QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean includeQHD, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat) {
        super(guid, (byte)-127, ttl, (byte)0, 11 + QueryReply.rLength(responses) + (includeQHD ? 8 : 0) + 16);
        Assert.that((port & 0xFFFF0000) == 0);
        Assert.that(ip.length == 4);
        Assert.that((speed & 0xFFFFFFFF00000000L) == 0L);
        int n = responses.length;
        Assert.that(n < 256);
        this.payload = new byte[this.getLength()];
        this.payload[0] = (byte)n;
        ByteOrder.short2leb((short)port, this.payload, 1);
        this.payload[3] = ip[0];
        this.payload[4] = ip[1];
        this.payload[5] = ip[2];
        this.payload[6] = ip[3];
        ByteOrder.int2leb((int)speed, this.payload, 7);
        int i = 11;
        int left = n;
        while (left > 0) {
            Response r = responses[n - left];
            ByteOrder.int2leb((int)r.getIndex(), this.payload, i);
            ByteOrder.int2leb((int)r.getSize(), this.payload, i + 4);
            byte[] nameBytes = r.getNameBytes();
            System.arraycopy(nameBytes, 0, this.payload, i += 8, nameBytes.length);
            i += nameBytes.length;
            this.payload[i++] = 0;
            this.payload[i++] = 0;
            --left;
        }
        if (includeQHD) {
            this.payload[i++] = 76;
            this.payload[i++] = 73;
            this.payload[i++] = 77;
            this.payload[i++] = 69;
            this.payload[i++] = 2;
            this.payload[i++] = (byte)((needsPush ? 1 : 0) | 4 | 8 | 0x10);
            this.payload[i++] = (byte)(1 | (isBusy ? 4 : 0) | (finishedUpload ? 8 : 0) | (measuredSpeed ? 16 : 0));
            this.payload[i++] = supportsChat ? (byte)1 : 0;
        }
        int j = 0;
        while (j < 16) {
            this.payload[i + j] = clientGUID[j];
            ++j;
        }
    }

    public QueryReply(byte[] guid, QueryReply reply) {
        super(guid, (byte)-127, reply.getTTL(), reply.getHops(), reply.getLength());
        this.payload = reply.payload;
    }

    private static int rLength(Response[] responses) {
        int ret = 0;
        int i = 0;
        while (i < responses.length) {
            ret += 8 + responses[i].getNameBytesSize() + 2;
            ++i;
        }
        return ret;
    }

    public QueryReply(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)-127, ttl, hops, payload.length);
        this.payload = payload;
    }

    public void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this.payload[0]);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 1));
    }

    public String getIP() {
        byte[] ip = new byte[]{this.payload[3], this.payload[4], this.payload[5], this.payload[6]};
        return Message.ip2string(ip);
    }

    public long getSpeed() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 7));
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this.responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList((Object[])this.responses);
        return list.iterator();
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this.vendor == null) {
            throw new BadPacketException();
        }
        return this.vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this.pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this.busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this.pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this.uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this.measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this.pushFlag);
        return false;
    }

    public boolean getSupportsChat() throws BadPacketException {
        this.parseResults();
        switch (this.supportsChat) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsChat: " + this.supportsChat);
        return false;
    }

    private void parseResults() {
        if (this.parsed) {
            return;
        }
        this.parseResults2();
        this.parsed = true;
    }

    private void parseResults2() {
        int i = 11;
        int left = this.getResultCount();
        Response[] responses = new Response[left];
        try {
            while (left > 0) {
                long index = ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, i));
                long size = ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, i + 4));
                int j = i += 8;
                while (this.payload[j] != 0) {
                    ++j;
                }
                String name = new String(this.payload, i, j - i);
                responses[responses.length - left] = new Response(index, size, name);
                ++j;
                while (this.payload[j] != 0) {
                    ++j;
                }
                i = j + 1;
                if (i > this.payload.length - 16) {
                    throw new BadPacketException("Missing null terminator filename");
                }
                --left;
            }
            this.responses = responses;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        catch (BadPacketException e) {
            return;
        }
        try {
            int privateLength;
            if (i > this.payload.length - 16 - 4 - 2) {
                throw new BadPacketException("No metadata");
            }
            String vendorT = null;
            int pushFlagT = -1;
            int busyFlagT = -1;
            int uploadedFlagT = -1;
            int measuredSpeedFlagT = -1;
            int supportsChatT = -1;
            try {
                vendorT = new String(this.payload, i, 4, "ISO-8859-1");
                Assert.that(vendorT.length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException e) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int length = ByteOrder.ubyte2int(this.payload[i += 4]);
            if (length <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            int n = pushFlagT = (this.payload[++i] & 1) == 1 ? 1 : 0;
            if (length > 1) {
                byte control = this.payload[i];
                byte flags = this.payload[i + 1];
                if ((control & 4) != 0) {
                    int n2 = busyFlagT = (flags & 4) != 0 ? 1 : 0;
                }
                if ((control & 8) != 0) {
                    int n3 = uploadedFlagT = (flags & 8) != 0 ? 1 : 0;
                }
                if ((control & 0x10) != 0) {
                    int n4 = measuredSpeedFlagT = (flags & 0x10) != 0 ? 1 : 0;
                }
            }
            if ((privateLength = this.payload.length - (i += length)) > 0 && vendorT.equals("LIME")) {
                if (this.payload[i] == 1) {
                    supportsChatT = 1;
                } else if (this.payload[i] == 0) {
                    supportsChatT = 0;
                }
            }
            if (i > this.payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(vendorT != null);
            this.vendor = vendorT.toUpperCase();
            this.pushFlag = pushFlagT;
            this.busyFlag = busyFlagT;
            this.uploadedFlag = uploadedFlagT;
            this.measuredSpeedFlag = measuredSpeedFlagT;
            this.supportsChat = supportsChatT;
        }
        catch (BadPacketException e) {
            return;
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    public byte[] getClientGUID() {
        byte[] result = new byte[16];
        int length = super.getLength();
        System.arraycopy(this.payload, length - 16, result, 0, 16);
        return result;
    }

    public String toString() {
        return "QueryReply(" + this.getResultCount() + " hits, " + super.toString() + ")";
    }
}

