/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class QueryRequest
extends Message
implements Serializable {
    private byte[] payload;
    private String query = null;

    public QueryRequest(byte ttl, int minSpeed, String query) {
        super((byte)-128, ttl, 2 + query.length() + 1);
        this.payload = new byte[2 + query.length() + 1];
        ByteOrder.short2leb((short)minSpeed, this.payload, 0);
        byte[] qbytes = query.getBytes();
        System.arraycopy(qbytes, 0, this.payload, 2, qbytes.length);
        this.payload[this.payload.length - 1] = 0;
    }

    public QueryRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)-128, ttl, hops, payload.length);
        this.payload = payload;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
    }

    public synchronized String getQuery() {
        if (this.query != null) {
            return this.query;
        }
        int n = this.payload.length;
        this.query = super.getLength() > 3 && this.payload[n - 2] == 0 ? new String(this.payload, 2, this.payload.length - 4) : new String(this.payload, 2, this.payload.length - 3);
        Assert.that(this.query != null, "Returning null value in getQuery");
        return this.query;
    }

    public int getQueryLength() {
        if (super.getLength() > 3 && this.payload[this.payload.length - 2] == 0) {
            return this.payload.length - 4;
        }
        return this.payload.length - 3;
    }

    public byte getQueryByteAt(int pseudoIndex) throws ArrayIndexOutOfBoundsException {
        if (pseudoIndex < 0 || pseudoIndex > this.getQueryLength() - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.payload[pseudoIndex + 2];
    }

    public int getMinSpeed() {
        short speed = ByteOrder.leb2short(this.payload, 0);
        int ret = ByteOrder.ubytes2int(speed);
        Assert.that(ret >= 0, "getMinSpeed got negative value");
        return ret;
    }

    public String toString() {
        return "QueryRequest(" + this.getQuery() + ", " + this.getMinSpeed() + ", " + super.toString() + ")";
    }
}

