/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.SettingsManager;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.net.Socket;

class RejectConnection
extends Connection {
    private HostCatcher _hostCatcher;

    RejectConnection(Socket socket, HostCatcher hostCatcher) {
        super(socket);
        this._hostCatcher = hostCatcher;
        try {
            try {
                this.initialize();
                this.loopForPingRequest();
            }
            catch (IOException e) {
                Object var5_4 = null;
                this.close();
            }
            Object var5_3 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
    }

    private void loopForPingRequest() throws IOException {
        int i = 0;
        while (i < 10) {
            Message m = null;
            try {
                m = this.receive(SettingsManager.instance().getTimeout());
                if (m == null) {
                    return;
                }
            }
            catch (BadPacketException e) {
                return;
            }
            if (m instanceof PingRequest && m.getHops() == 0) {
                Iterator iter = this._hostCatcher.getBestHosts(10);
                while (iter.hasNext()) {
                    Endpoint bestEndPoint = (Endpoint)iter.next();
                    PingReply pr = new PingReply(m.getGUID(), 1, bestEndPoint.getPort(), bestEndPoint.getHostBytes(), 0L, 0L);
                    this.send(pr);
                }
                this.flush();
                return;
            }
            ++i;
        }
    }
}

