/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Comparator;
import java.io.Serializable;

public class RemoteFileDesc
implements Comparable,
Serializable {
    private final int PRIVATE_MODEM_PRIORITY = 10;
    private final int PRIVATE_CABLE_PRIORITY = 8;
    private final int PRIVATE_T1_PRIORITY = 7;
    private final int PRIVATE_T3_PRIORITY = 6;
    private final int PUBLIC_MODEM_PRIORITY = 5;
    private final int PUBLIC_CABLE_PRIORITY = 3;
    private final int PUBLIC_T1_PRIORITY = 2;
    private final int PUBLIC_T3_PRIORITY = 1;
    private String _host;
    private int _port;
    private String _filename;
    private int _index;
    private byte[] _clientGUID;
    private int _speed;
    private int _size;
    private int _priority;
    private int _speed_priority;
    private int _numAttempts = 0;
    private boolean _chatEnabled;

    public RemoteFileDesc(String host, int port, int index, String filename, int size, byte[] clientGUID, int speed, boolean chat) {
        this._speed = speed;
        this._host = host;
        this._port = port;
        this._index = index;
        this._filename = filename;
        this._size = size;
        this._clientGUID = clientGUID;
        this._chatEnabled = chat;
        this.calculateSpeedPriority();
        this.calculatePriority();
    }

    public void print() {
    }

    public int compareTo(Object obj2) {
        RemoteFileDesc rdf2;
        try {
            rdf2 = (RemoteFileDesc)obj2;
        }
        catch (ClassCastException e) {
            return 0;
        }
        if (this.calculatePriority() > rdf2.calculatePriority()) {
            return -1;
        }
        if (this.calculatePriority() < rdf2.calculatePriority()) {
            return 1;
        }
        return 0;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public int getIndex() {
        return this._index;
    }

    public int getSize() {
        return this._size;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    public int getSpeed() {
        return this._speed;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setHost(String h) {
        this._host = h;
    }

    public void setPost(int p) {
        this._port = p;
    }

    public void setIndex(int i) {
        this._index = i;
    }

    public void setSize(int s) {
        this._size = s;
    }

    public void setFileName(String name) {
        this._filename = name;
    }

    public void setClientGUID(byte[] b) {
        this._clientGUID = b;
    }

    public void setSpeed(int s) {
        this._speed = s;
    }

    public int getNumAttempts() {
        return this._numAttempts;
    }

    public void setNumAttempts(int n) {
        this._numAttempts = n;
    }

    public void incrementNumAttempts() {
        ++this._numAttempts;
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean isPrivate() {
        if (this._host == null) {
            return true;
        }
        Endpoint e = new Endpoint(this._host, this._port);
        return e.isPrivateAddress();
    }

    public int calculatePriority() {
        this._priority = this._speed_priority + this._numAttempts * 10;
        return this._priority;
    }

    public int calculateSpeedPriority() {
        if (this.isPrivate()) {
            if (this._speed <= 56) {
                this._speed_priority = 10;
            } else if (this._speed <= 350) {
                this._speed_priority = 8;
            } else if (this._speed <= 1000) {
                this._speed_priority = 7;
            } else if (this._speed <= 3000) {
                this._speed_priority = 6;
            }
        } else if (this._speed <= 56) {
            this._speed_priority = 5;
        } else if (this._speed <= 350) {
            this._speed_priority = 3;
        } else if (this._speed <= 1000) {
            this._speed_priority = 2;
        } else if (this._speed <= 3000) {
            this._speed_priority = 1;
        }
        return this._speed_priority;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc other = (RemoteFileDesc)o;
        return this._host.equals(other._host) && this._port == other._port && this._filename.equals(other._filename) && this._index == other._index && Arrays.equals((byte[])this._clientGUID, (byte[])other._clientGUID) && this._speed == other._speed && this._size == other._size;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName() + "/" + this.getSize() + ", " + this.getSpeed() + ">";
    }

    public static class RemoteFileDescComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            RemoteFileDesc rdf1 = (RemoteFileDesc)obj1;
            RemoteFileDesc rdf2 = (RemoteFileDesc)obj2;
            return rdf1.getSpeed() - rdf2.getSpeed();
        }
    }
}

