/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;

public class Response {
    private long index;
    private long size;
    private byte[] nameBytes;
    private String name;
    private String meta;

    public Response(long index, long size, String name) {
        Assert.that((index & 0xFFFFFFFF00000000L) == 0L, "Response constructor: index " + index + " too big!");
        Assert.that((size & 0xFFFFFFFF00000000L) == 0L, "Response constructor: size " + size + " too big!");
        this.index = index;
        this.size = size;
        this.name = name;
        this.nameBytes = name.getBytes();
        this.meta = "";
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public byte[] getNameBytes() {
        return this.nameBytes;
    }

    public String getName() {
        return this.name;
    }

    public void setMeta(String m) {
        this.meta = m;
    }

    public String getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return r.getIndex() == this.getIndex() && r.getSize() == this.getSize() && r.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.name.hashCode() + (int)this.size + (int)this.index;
    }
}

