/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest qr) {
        this.record(qr, null);
    }

    public synchronized void record(QueryRequest qr, MediaType type) {
        byte[] guid = qr.getGUID();
        this.mapper.put(new GUID(guid), new RequestData(qr.getQuery(), type));
    }

    public synchronized int score(byte[] guid, Response resp) {
        int numMatchingWords = 0;
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return 100;
        }
        String[] queryWords = request.queryWords;
        int numQueryWords = queryWords.length;
        if (numQueryWords == 0) {
            return 100;
        }
        String name = resp.getName().toLowerCase();
        int i = 0;
        while (i < numQueryWords) {
            String pattern = queryWords[i];
            if (StringUtils.contains(name, pattern)) {
                ++numMatchingWords;
            }
            ++i;
        }
        return (int)((float)numMatchingWords * 100.0f / (float)numQueryWords);
    }

    public boolean matchesType(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null || request.type == null) {
            return true;
        }
        String reply = response.getName();
        return request.type.matches(reply);
    }

    public boolean isMandragoreWorm(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(request.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static class RequestData {
        String query;
        String[] queryWords;
        MediaType type;

        RequestData(String query, MediaType type) {
            this.query = query;
            this.queryWords = StringUtils.split(query.toLowerCase(), ResponseVerifier.DELIMITERS);
            this.type = type;
        }
    }
}

