/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;

class RouteTable {
    private Map _map;

    public RouteTable(int size) {
        this(size, false);
    }

    public RouteTable(int size, boolean allowRemap) {
        this._map = allowRemap ? new FixedsizeForgetfulHashMap(size) : new ForgetfulHashMap(size);
    }

    public synchronized void routeReply(byte[] guid, ReplyHandler replyHandler) {
        Assert.that(replyHandler != null);
        if (!replyHandler.isOpen()) {
            return;
        }
        GUID g = new GUID(guid);
        this._map.put((Object)g, (Object)replyHandler);
    }

    public synchronized boolean tryToRouteReply(byte[] guid, ReplyHandler replyHandler) {
        Assert.that(replyHandler != null);
        Assert.that(guid != null, "Null GUID in tryToRouteReply");
        if (!replyHandler.isOpen()) {
            return false;
        }
        GUID g = new GUID(guid);
        if (!this._map.containsKey((Object)g)) {
            this._map.put((Object)g, (Object)replyHandler);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] guid) {
        return (ReplyHandler)this._map.get((Object)new GUID(guid));
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        Assert.that(replyHandler != null, "Null replyHandler in removeReplyHandler");
        Iterator iter = this._map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Assert.that(key != null, "Null key in removeReplyHandler");
            Object value = this._map.get(key);
            if (value == null || !value.equals(replyHandler)) continue;
            iter.remove();
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer("\n");
        Iterator iter = this._map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            buf.append(key);
            buf.append(" -> ");
            buf.append(this._map.get(key));
            buf.append("\n");
        }
        return buf.toString();
    }
}

