/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RouterService {
    private ActivityCallback callback;
    private HostCatcher catcher;
    private MessageRouter router;
    private Acceptor acceptor;
    private ConnectionManager manager;
    private ResponseVerifier verifier = new ResponseVerifier();
    private DownloadManager downloader;
    private UploadManager uploadManager;
    private static final byte[] LOCALHOST = new byte[]{127, 0, 0, 1};

    public RouterService(ActivityCallback activityCallback, MessageRouter router) {
        this.callback = activityCallback;
        this.router = router;
        Assert.setCallback(this.callback);
    }

    public void initialize() {
        SettingsManager settings = SettingsManager.instance();
        int port = settings.getPort();
        this.acceptor = new Acceptor(port, this.callback);
        this.manager = new ConnectionManager(this.callback);
        this.catcher = new HostCatcher(this.callback);
        this.downloader = new DownloadManager();
        this.uploadManager = new UploadManager();
        this.catcher.initialize(this.acceptor, this.manager, SettingsManager.instance().getHostList());
        this.router.initialize(this.acceptor, this.manager, this.catcher, this.uploadManager);
        this.manager.initialize(this.router, this.catcher);
        this.uploadManager.initialize(this.callback, this.router, this.acceptor);
        this.acceptor.initialize(this.manager, this.router, this.downloader, this.uploadManager);
        this.catcher.connectToRouter();
        this.downloader.initialize(this.callback, this.router, this.acceptor, FileManager.instance());
        int outgoing = settings.getKeepAlive();
        if (outgoing > 0) {
            this.connect();
        }
    }

    public void postGuiInit() {
        FileManager.instance().initialize(this.callback);
        this.downloader.readSnapshot();
    }

    public ManagedConnection connectToHostBlocking(String hostname, int portnum) throws IOException {
        return this.manager.createConnectionBlocking(hostname, portnum);
    }

    public void connectToHostAsynchronously(String hostname, int portnum) {
        byte[] cIP = null;
        try {
            cIP = InetAddress.getByName(hostname).getAddress();
        }
        catch (UnknownHostException e) {
            return;
        }
        if (Arrays.equals((byte[])cIP, (byte[])LOCALHOST) && portnum == this.acceptor.getPort()) {
            return;
        }
        byte[] managerIP = this.acceptor.getAddress();
        if (Arrays.equals((byte[])cIP, (byte[])managerIP) && portnum == this.acceptor.getPort()) {
            return;
        }
        if (!this.acceptor.isBannedIP(hostname)) {
            this.manager.createConnectionAsynchronously(hostname, portnum);
        }
    }

    public void connectToGroup(String group) {
        this.groupConnect(group);
    }

    private ManagedConnection groupConnectToHostBlocking(String hostname, int portnum, String group) throws IOException {
        SettingsManager settings = SettingsManager.instance();
        group = group + ":" + settings.getConnectionSpeed();
        GroupPingRequest pingRequest = this.router.createGroupPingRequest(group);
        return this.manager.createGroupConnectionBlocking(hostname, portnum, pingRequest);
    }

    private void groupConnect(String group) {
        Endpoint e;
        SettingsManager settings = SettingsManager.instance();
        boolean useQuickConnect = settings.getUseQuickConnect();
        settings.setUseQuickConnect(false);
        if (settings.getKeepAlive() < 1) {
            settings.setKeepAlive(4);
        }
        int oldKeepAlive = settings.getKeepAlive();
        String host = "router.limewire.com:6349";
        try {
            e = new Endpoint(host);
        }
        catch (IllegalArgumentException exc) {
            return;
        }
        this.disconnect();
        this.catcher.silentClear();
        try {
            this.groupConnectToHostBlocking(e.getHostname(), e.getPort(), group);
        }
        catch (IOException exc) {
            settings.setUseQuickConnect(useQuickConnect);
            return;
        }
        int outgoing = settings.getKeepAlive();
        if (outgoing < 1) {
            outgoing = 4;
            settings.setKeepAlive(outgoing);
        }
        if (outgoing < 10) {
            outgoing = 10;
            this.manager.activateUltraFastConnectShutdown();
        }
        this.setKeepAlive(outgoing);
        settings.setUseQuickConnect(useQuickConnect);
    }

    public void connect() {
        boolean useHack;
        SettingsManager settings = SettingsManager.instance();
        boolean bl = useHack = !settings.getUseQuickConnect() && this.catcher.getNumHosts() == 0;
        if (useHack) {
            settings.setUseQuickConnect(true);
            this.disconnect();
        }
        this.catcher.expire();
        int outgoing = settings.getKeepAlive();
        if (outgoing < 1) {
            outgoing = 4;
            settings.setKeepAlive(outgoing);
        }
        if (outgoing < 10) {
            outgoing = 10;
            this.manager.activateUltraFastConnectShutdown();
        }
        this.setKeepAlive(outgoing);
        if (useHack) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SettingsManager.instance().setUseQuickConnect(false);
        }
    }

    public void disconnect() {
        this.manager.deactivateUltraFastConnectShutdown();
        SettingsManager settings = SettingsManager.instance();
        int oldKeepAlive = settings.getKeepAlive();
        this.setKeepAlive(0);
        Iterator iter = this.manager.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            this.removeConnection(c);
        }
    }

    public void reduceConnections() {
        this.manager.reduceConnections();
    }

    public void removeConnection(ManagedConnection c) {
        this.manager.remove(c);
    }

    public void clearHostCatcher() {
        this.catcher.silentClear();
    }

    public int getRealNumHosts() {
        return this.catcher.getNumHosts();
    }

    public void shutdown() {
        try {
            Object var3_1;
            try {
                this.catcher.write(SettingsManager.instance().getHostList());
            }
            catch (IOException e) {
                var3_1 = null;
                SettingsManager.instance().writeProperties();
            }
            var3_1 = null;
            SettingsManager.instance().writeProperties();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            SettingsManager.instance().writeProperties();
            throw throwable;
        }
        File incompleteDir = null;
        try {
            incompleteDir = SettingsManager.instance().getIncompleteDirectory();
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        String[] files = incompleteDir.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].startsWith("Preview-")) {
                File file = new File(incompleteDir, files[i]);
                file.delete();
            }
            ++i;
        }
    }

    public void setKeepAlive(int newKeep) {
        this.manager.setKeepAlive(newKeep);
    }

    public void adjustSpamFilters() {
        Iterator iter = this.manager.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            c.setPersonalFilter(SpamFilter.newPersonalFilter());
            c.setRouteFilter(SpamFilter.newRouteFilter());
        }
    }

    public void setListeningPort(int port) throws IOException {
        this.acceptor.setListeningPort(port);
    }

    public void setAlwaysNotifyKnownHost(boolean notify) {
        this.catcher.setAlwaysNotifyKnownHost(notify);
    }

    public boolean acceptedIncomingConnection() {
        return this.acceptor.acceptedIncoming();
    }

    public int getTotalMessages() {
        return this.router.getNumMessages();
    }

    public int getTotalDroppedMessages() {
        return this.router.getNumDroppedMessages();
    }

    public int getTotalRouteErrors() {
        return this.router.getNumRouteErrors();
    }

    public long getNumHosts() {
        long ret = 0L;
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ret += ((ManagedConnection)iter.next()).getNumHosts();
        }
        return ret;
    }

    public long getNumFiles() {
        long ret = 0L;
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ret += ((ManagedConnection)iter.next()).getNumFiles();
        }
        return ret;
    }

    public long getTotalFileSize() {
        long ret = 0L;
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ret += ((ManagedConnection)iter.next()).getTotalFileSize();
        }
        return ret;
    }

    public void updateHorizon() {
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ((ManagedConnection)iter.next()).refreshHorizonStats();
        }
    }

    public byte[] query(String query, int minSpeed, MediaType type) {
        QueryRequest qr = new QueryRequest(SettingsManager.instance().getTTL(), minSpeed, query);
        this.verifier.record(qr, type);
        this.router.broadcastQueryRequest(qr);
        return qr.getGUID();
    }

    public byte[] query(String query, int minSpeed) {
        return this.query(query, minSpeed, null);
    }

    public int score(byte[] guid, Response resp) {
        return this.verifier.score(guid, resp);
    }

    public boolean matchesType(byte[] guid, Response response) {
        return this.verifier.matchesType(guid, response);
    }

    public boolean isMandragoreWorm(byte[] guid, Response response) {
        return this.verifier.isMandragoreWorm(guid, response);
    }

    public byte[] browse(String host, int port) {
        ManagedConnection c = null;
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c2 = (ManagedConnection)iter.next();
            String ip = c2.getInetAddress().getHostAddress();
            if (!ip.equals(host) || c2.getOrigPort() != port) continue;
            c = c2;
            break;
        }
        if (c == null) {
            try {
                c = this.connectToHostBlocking(host, port);
            }
            catch (IOException e) {
                return null;
            }
        }
        QueryRequest qr = new QueryRequest(1, 0, "*.*");
        this.router.sendQueryRequest(qr, c);
        try {
            c.flush();
        }
        catch (IOException e) {
            return null;
        }
        if (this.manager.getNumConnections() > this.manager.getKeepAlive()) {
            ManagedConnection worst = null;
            long files = Long.MAX_VALUE;
            Iterator iter2 = this.manager.getConnections().iterator();
            while (iter2.hasNext()) {
                long n;
                ManagedConnection c2 = (ManagedConnection)iter2.next();
                if (c2 == c || (n = c2.getNumFiles()) >= files) continue;
                worst = c2;
                files = n;
            }
            if (worst != null) {
                this.manager.remove(worst);
            }
        }
        return qr.getGUID();
    }

    public Iterator getHosts() {
        return this.catcher.getHosts();
    }

    public int getNumConnections() {
        return this.manager.getNumConnections();
    }

    public int getNumLocalSearches() {
        return this.router.getNumQueryRequests();
    }

    public void removeHost(String host, int port) {
        this.catcher.removeHost(host, port);
    }

    public int getNumSharedFiles() {
        return FileManager.instance().getNumFiles();
    }

    public File[] getSharedFiles(File directory) {
        return FileManager.instance().getSharedFiles(directory);
    }

    public Downloader download(RemoteFileDesc[] files, boolean overwrite) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return this.downloader.getFiles(files, overwrite);
    }

    public void refreshBannedIPs() {
        this.acceptor.refreshBannedIPs();
    }

    public Chatter createChat(String host, int port) {
        Chatter chatter = ChatManager.instance().request(host, port);
        return chatter;
    }
}

