/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Vector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SettingsManager {
    private final String CURRENT_DIRECTORY = System.getProperty("user.dir");
    private final String SAVE_DIRECTORY_NAME = "Shared";
    private final String HOST_LIST_NAME = "gnutella.net";
    private final String PROPS_NAME = "limewire.props";
    private final String ND_PROPS_NAME = "nd.props";
    private final boolean DEFAULT_ALLOW_BROWSER = false;
    private final byte DEFAULT_TTL = (byte)7;
    private final byte DEFAULT_SOFT_MAX_TTL = (byte)7;
    private final byte DEFAULT_MAX_TTL = (byte)16;
    private final int DEFAULT_MAX_LENGTH = 65536;
    private final int DEFAULT_TIMEOUT = 8000;
    public static final int DEFAULT_KEEP_ALIVE = 4;
    private final int DEFAULT_PORT = 6346;
    private final int DEFAULT_SPEED = 56;
    private final int DEFAULT_UPLOAD_SPEED = 100;
    private final byte DEFAULT_SEARCH_LIMIT = (byte)64;
    private final String DEFAULT_CLIENT_ID;
    private final int DEFAULT_MAX_INCOMING_CONNECTION = 4;
    private final String DEFAULT_SAVE_DIRECTORY = "";
    private final String DEFAULT_DIRECTORIES = "";
    private final String DEFAULT_EXTENSIONS = "html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;wav;au;aif;aiff;ra;ram;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg";
    private final int DEFAULT_UPLOADS_PER_PERSON = 3;
    private final String[] DEFAULT_BANNED_IPS = new String[0];
    private final String[] DEFAULT_BANNED_WORDS = new String[0];
    private final boolean DEFAULT_FILTER_ADULT = false;
    private final boolean DEFAULT_FILTER_DUPLICATES = true;
    private final boolean DEFAULT_FILTER_VBS = true;
    private final boolean DEFAULT_FILTER_HTML = false;
    private final boolean DEFAULT_FILTER_GREEDY_QUERIES = true;
    private final boolean DEFAULT_FILTER_BEARSHARE_QUERIES = true;
    private final boolean DEFAULT_USE_QUICK_CONNECT = true;
    public static final String DEFAULT_LIMEWIRE_ROUTER = "router.limewire.com";
    public static final String DEDICATED_LIMEWIRE_ROUTER = CommonUtils.isMacClassic() ? "64.61.25.171" : "router4.limewire.com";
    private final String[] DEFAULT_QUICK_CONNECT_HOSTS = new String[]{"router.limewire.com:6346", "connect1.gnutellanet.com:6346", "connect2.gnutellanet.com:6346", "connect3.gnutellanet.com:6346", "connect4.gnutellanet.com:6346"};
    private final int DEFAULT_PARALLEL_SEARCH = 5;
    private final int DEFAULT_MAX_SIM_DOWNLOAD = 4;
    private final boolean DEFAULT_PROMPT_EXE_DOWNLOAD = true;
    private final int DEFAULT_MAX_UPLOADS = 8;
    private final boolean DEFAULT_CLEAR_UPLOAD = true;
    private final boolean DEFAULT_CLEAR_DOWNLOAD = false;
    private final int DEFAULT_SEARCH_ANIMATION_TIME = 20;
    public static final String DEFAULT_CONNECT_STRING = "GNUTELLA CONNECT/0.4";
    private final String DEFAULT_CONNECT_OK_STRING = "GNUTELLA OK";
    private final int DEFAULT_BASIC_INFO_FOR_QUERY = 1000;
    private final int DEFAULT_ADVANCED_INFO_FOR_QUERY = 50;
    private final boolean DEFAULT_CHECK_AGAIN = true;
    private final boolean DEFAULT_FORCE_IP_ADDRESS = false;
    private final String DEFAULT_FORCED_IP_ADDRESS_STRING = "0.0.0.0";
    private final int DEFAULT_FORCED_PORT = 6346;
    private final int DEFAULT_FREELOADER_FILES = 1;
    private final int DEFAULT_FREELOADER_ALLOWED = 100;
    private final long DEFAULT_AVERAGE_UPTIME = 200L;
    private final long DEFAULT_TOTAL_UPTIME = 0L;
    private final int DEFAULT_SESSIONS = 1;
    private final boolean DEFAULT_INSTALLED = false;
    private final int DEFAULT_APP_WIDTH = 640;
    private final int DEFAULT_APP_HEIGHT = 620;
    private final boolean DEFAULT_RUN_ONCE = false;
    private final boolean DEFAULT_SHOW_TRAY_DIALOG = true;
    private final boolean DEFAULT_MINIMIZE_TO_TRAY = true;
    private final boolean DEFAULT_SHOW_CLOSE_DIALOG = true;
    private final String DEFAULT_CLASSPATH = "LimeWire.jar" + File.pathSeparator + "collections.jar";
    private final String DEFAULT_MAIN_CLASS = "com.limegroup.gnutella.gui.Main";
    private final boolean DEFAULT_CHAT_ENABLED = true;
    private final String DEFAULT_LANGUAGE = "en";
    private final String DEFAULT_COUNTRY = "US";
    private final int DEFAULT_MINIMUM_SEARCH_QUALITY = 2;
    private final int DEFAULT_MINIMUM_SEARCH_SPEED = 56;
    private final boolean DEFAULT_SEARCH_FILTER_MESSAGE_SHOWN = false;
    private final String ALLOW_BROWSER = "ALLOW_BROWSER";
    private final String TTL = "TTL";
    private final String SOFT_MAX_TTL = "SOFT_MAX_TTL";
    private final String MAX_TTL = "MAX_TTL";
    private final String MAX_LENGTH = "MAX_LENGTH";
    private final String TIMEOUT = "TIMEOUT";
    private final String KEEP_ALIVE = "KEEP_ALIVE";
    private final String PORT = "PORT";
    private final String SPEED = "CONNECTION_SPEED";
    private final String UPLOAD_SPEED = "UPLOAD_SPEED";
    private final String SEARCH_LIMIT = "SEARCH_LIMIT";
    private final String CLIENT_ID = "CLIENT_ID";
    private final String MAX_INCOMING_CONNECTIONS = "MAX_INCOMING_CONNECTIONS";
    private final String SAVE_DIRECTORY = "DIRECTORY_FOR_SAVING_FILES";
    private final String DIRECTORIES = "DIRECTORIES_TO_SEARCH_FOR_FILES";
    private final String EXTENSIONS = "EXTENSIONS_TO_SEARCH_FOR";
    private final String BANNED_IPS = "BLACK_LISTED_IP_ADDRESSES";
    private final String BANNED_WORDS = "BANNED_WORDS";
    private final String FILTER_DUPLICATES = "FILTER_DUPLICATES";
    private final String FILTER_ADULT = "FILTER_ADULT";
    private final String FILTER_HTML = "FILTER_HTML";
    private final String FILTER_VBS = "FILTER_VBS";
    private final String FILTER_GREEDY_QUERIES = "FILTER_GREEDY_QUERIES";
    private final String FILTER_BEARSHARE_QUERIES = "FILTER_HIGHBIT_QUERIES";
    private final String USE_QUICK_CONNECT = "USE_QUICK_CONNECT";
    private final String QUICK_CONNECT_HOSTS = "QUICK_CONNECT_HOSTS";
    private final String PARALLEL_SEARCH = "PARALLEL_SEARCH";
    private final String MAX_SIM_DOWNLOAD = "MAX_SIM_DOWNLOAD";
    private final String PROMPT_EXE_DOWNLOAD = "PROMPT_EXE_DOWNLOAD";
    private final String MAX_UPLOADS = "MAX_UPLOADS";
    private final String CLEAR_UPLOAD = "CLEAR_UPLOAD";
    private final String CLEAR_DOWNLOAD = "CLEAR_DOWNLOAD";
    private final String SEARCH_ANIMATION_TIME = "SEARCH_ANIMATION_TIME";
    private final String CONNECT_STRING = "CONNECT_STRING";
    private final String CONNECT_OK_STRING = "CONNECT_OK_STRING";
    private final String CHECK_AGAIN = "CHECK_AGAIN";
    private final String BASIC_QUERY_INFO = "BASIC_QUERY_INFO";
    private final String ADVANCED_QUERY_INFO = "ADVANCED_QUERY_INFO";
    private final String FORCE_IP_ADDRESS = "FORCE_IP_ADDRESS";
    private final String FORCED_IP_ADDRESS_STRING = "FORCED_IP_ADDRESS_STRING";
    private final String FORCED_PORT = "FORCED_PORT";
    private final String FREELOADER_FILES = "FREELOADER_FILES";
    private final String FREELOADER_ALLOWED = "FREELOADER_ALLOWED";
    private final String UPLOADS_PER_PERSON = "UPLOADS_PER_PERSON";
    private final String AVERAGE_UPTIME = "AVERAGE_UPTIME";
    private final String TOTAL_UPTIME = "TOTAL_UPTIME";
    private final String SESSIONS = "SESSIONS";
    private final String INSTALLED = "INSTALLED";
    private final String APP_WIDTH = "APP_WIDTH";
    private final String APP_HEIGHT = "APP_HEIGHT";
    private final String RUN_ONCE = "RUN_ONCE";
    private final String WINDOW_X = "WINDOW_X";
    private final String WINDOW_Y = "WINDOW_Y";
    private final String SHOW_TRAY_DIALOG = "SHOW_TRAY_DIALOG";
    private final String MINIMIZE_TO_TRAY = "MINIMIZE_TO_TRAY";
    private final String SHOW_CLOSE_DIALOG = "SHOW_CLOSE_DIALOG";
    private final String CLASSPATH = "CLASSPATH";
    private final String MAIN_CLASS = "MAIN_CLASS";
    private final String CHAT_ENABLED = "CHAT_ENABLED";
    private final String LANGUAGE = "LANGUAGE";
    private final String COUNTRY = "COUNTRY";
    private final String MINIMUM_SEARCH_QUALITY = "MINIMUM_SEARCH_QAULITY";
    private final String MINIMUM_SEARCH_SPEED = "MINIMUM_SEARCH_SPEED";
    private final String SEARCH_FILTER_MESSAGE_SHOWN = "SEARCH_FILTER_MESSAGE_SHOWN";
    private volatile boolean _forceIPAddress;
    private volatile byte[] _forcedIPAddress;
    private volatile int _forcedPort;
    private volatile boolean _allowBroswer;
    private volatile byte _ttl;
    private volatile byte _softmaxttl;
    private volatile byte _maxttl;
    private volatile int _maxLength;
    private volatile int _timeout;
    private volatile String _hostList;
    private volatile int _keepAlive;
    private volatile int _port;
    private volatile int _connectionSpeed;
    private volatile int _uploadSpeed;
    private volatile byte _searchLimit;
    private volatile String _clientID;
    private volatile int _maxIncomingConn;
    private volatile File _saveDirectory;
    private volatile File _incompleteDirectory;
    private volatile String _directories;
    private volatile String _extensions;
    private volatile String[] _bannedIps;
    private volatile String[] _bannedWords;
    private volatile boolean _filterDuplicates;
    private volatile boolean _filterAdult;
    private volatile boolean _filterVbs;
    private volatile boolean _filterHtml;
    private volatile boolean _filterGreedyQueries;
    private volatile boolean _filterBearShare;
    private volatile boolean _useQuickConnect;
    private volatile String[] _quickConnectHosts;
    private volatile int _parallelSearchMax;
    private volatile boolean _clearCompletedUpload;
    private volatile boolean _clearCompletedDownload;
    private volatile int _maxSimDownload;
    private volatile boolean _promptExeDownload;
    private volatile int _maxUploads;
    private volatile int _searchAnimationTime;
    private volatile int _uploadsPerPerson;
    private volatile boolean _chatEnabled;
    private volatile String _connectString;
    private volatile String _connectStringFirstWord;
    private volatile String _connectStringRemainder;
    private volatile String _connectOkString;
    private volatile int _basicQueryInfo;
    private volatile int _advancedQueryInfo;
    private volatile int _freeLoaderFiles;
    private volatile int _freeLoaderAllowed;
    private volatile int _sessions;
    private volatile long _averageUptime;
    private volatile long _totalUptime;
    private volatile boolean _installed;
    private volatile boolean _acceptedIncoming = false;
    private volatile Properties _props = new Properties();
    private volatile Properties _ndProps = new Properties();
    private static SettingsManager _instance = new SettingsManager();
    private static final String STRING_DELIMETER = ";";

    public static SettingsManager instance() {
        return _instance;
    }

    private SettingsManager() {
        this.DEFAULT_CLIENT_ID = null;
        try {
            FileInputStream fis = new FileInputStream(new File("nd.props"));
            try {
                this._ndProps.load(fis);
            }
            catch (IOException ioe) {}
        }
        catch (FileNotFoundException fne) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.initialize();
    }

    private void initialize() {
        Properties tempProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File("limewire.props"));
            try {
                tempProps.load(fis);
                this.loadDefaults();
                try {
                    fis.close();
                    this.validateFile(tempProps);
                }
                catch (IOException e) {
                }
            }
            catch (IOException e) {
                this.loadDefaults();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.loadDefaults();
        }
        catch (SecurityException se) {
            this.loadDefaults();
        }
    }

    private void validateFile(Properties tempProps) {
        Enumeration<?> enumeration = tempProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String key = (String)enumeration.nextElement();
                String p = tempProps.getProperty(key);
                if (key.equals("TTL")) {
                    this.setTTL(Byte.parseByte(p));
                    continue;
                }
                if (key.equals("ALLOW_BROWSER")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setAllowBrowser(bs);
                    continue;
                }
                if (key.equals("SOFT_MAX_TTL")) {
                    this.setSoftMaxTTL(Byte.parseByte(p));
                    continue;
                }
                if (key.equals("MAX_TTL")) {
                    this.setMaxTTL(Byte.parseByte(p));
                    continue;
                }
                if (key.equals("MAX_LENGTH")) {
                    this.setMaxLength(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("PARALLEL_SEARCH")) {
                    this.setParallelSearchMax(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("MAX_SIM_DOWNLOAD")) {
                    this.setMaxSimDownload(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("PROMPT_EXE_DOWNLOAD")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setPromptExeDownload(bs);
                    continue;
                }
                if (key.equals("MAX_UPLOADS")) {
                    this.setMaxUploads(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("CLEAR_DOWNLOAD")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setClearCompletedDownload(bs);
                    continue;
                }
                if (key.equals("CLEAR_UPLOAD")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setClearCompletedUpload(bs);
                    continue;
                }
                if (key.equals("TIMEOUT")) {
                    this.setTimeout(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("UPLOADS_PER_PERSON")) {
                    this.setUploadsPerPerson(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("KEEP_ALIVE")) {
                    this.setKeepAlive(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("PORT")) {
                    this.setPort(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("CONNECTION_SPEED")) {
                    this.setConnectionSpeed(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("UPLOAD_SPEED")) {
                    this.setUploadSpeed(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("SEARCH_LIMIT")) {
                    this.setSearchLimit(Byte.parseByte(p));
                    continue;
                }
                if (key.equals("CHAT_ENABLED")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setChatEnabled(bs);
                    continue;
                }
                if (key.equals("CLIENT_ID")) {
                    this.setClientID(p);
                    continue;
                }
                if (key.equals("MAX_INCOMING_CONNECTIONS")) {
                    this.setMaxIncomingConnections(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("DIRECTORY_FOR_SAVING_FILES")) {
                    try {
                        this.setSaveDirectory(new File(p));
                    }
                    catch (IOException ioe) {
                        try {
                            this.setSaveDirectory(this.getSaveDefault());
                            this.addDirectory(this.getSaveDefault());
                        }
                        catch (IOException ioe2) {}
                    }
                    continue;
                }
                if (key.equals("DIRECTORIES_TO_SEARCH_FOR_FILES")) {
                    this.setDirectories(p);
                    continue;
                }
                if (key.equals("EXTENSIONS_TO_SEARCH_FOR")) {
                    this.setExtensions(p);
                    continue;
                }
                if (key.equals("CHECK_AGAIN")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setCheckAgain(bs);
                    continue;
                }
                if (key.equals("BLACK_LISTED_IP_ADDRESSES")) {
                    this.setBannedIps(SettingsManager.decode(p));
                    continue;
                }
                if (key.equals("BANNED_WORDS")) {
                    this.setBannedWords(SettingsManager.decode(p));
                    continue;
                }
                if (key.equals("FILTER_ADULT")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterAdult(bs);
                    continue;
                }
                if (key.equals("FILTER_DUPLICATES")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterDuplicates(bs);
                    continue;
                }
                if (key.equals("FILTER_HTML")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterHtml(bs);
                    continue;
                }
                if (key.equals("FILTER_VBS")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterVbs(bs);
                    continue;
                }
                if (key.equals("FILTER_GREEDY_QUERIES")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterGreedyQueries(bs);
                    continue;
                }
                if (key.equals("FILTER_HIGHBIT_QUERIES")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setFilterBearShareQueries(bs);
                    continue;
                }
                if (key.equals("QUICK_CONNECT_HOSTS")) {
                    this.setQuickConnectHosts(SettingsManager.decode(p));
                    continue;
                }
                if (key.equals("USE_QUICK_CONNECT")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setUseQuickConnect(bs);
                    continue;
                }
                if (key.equals("SEARCH_ANIMATION_TIME")) {
                    this.setSearchAnimationTime(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("CONNECT_STRING")) {
                    this.setConnectString(p);
                    continue;
                }
                if (key.equals("CONNECT_OK_STRING")) {
                    this.setConnectOkString(p);
                    continue;
                }
                if (key.equals("BASIC_QUERY_INFO")) {
                    this.setBasicInfoForQuery(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("ADVANCED_QUERY_INFO")) {
                    this.setAdvancedInfoForQuery(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("FORCE_IP_ADDRESS")) {
                    boolean bs;
                    if (p.equals("true")) {
                        bs = true;
                    } else {
                        if (!p.equals("false")) break;
                        bs = false;
                    }
                    this.setForceIPAddress(bs);
                    continue;
                }
                if (key.equals("FORCED_IP_ADDRESS_STRING")) {
                    this.setForcedIPAddressString(p);
                    continue;
                }
                if (key.equals("FORCED_PORT")) {
                    this.setForcedPort(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("FREELOADER_FILES")) {
                    this.setFreeloaderFiles(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("FREELOADER_ALLOWED")) {
                    this.setFreeloaderAllowed(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("AVERAGE_UPTIME")) {
                    this.setAverageUptime(Long.parseLong(p));
                    continue;
                }
                if (key.equals("TOTAL_UPTIME")) {
                    this.setTotalUptime(Long.parseLong(p));
                    continue;
                }
                if (key.equals("SESSIONS")) {
                    this.setSessions(Integer.parseInt(p) + 1);
                    continue;
                }
                if (key.equals("INSTALLED")) {
                    Boolean installed = new Boolean(p);
                    this.setInstalled(installed);
                    continue;
                }
                if (key.equals("APP_WIDTH")) {
                    this.setAppWidth(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("APP_HEIGHT")) {
                    this.setAppHeight(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("RUN_ONCE")) {
                    Boolean runOnce = new Boolean(p);
                    this.setRunOnce(runOnce);
                    continue;
                }
                if (key.equals("WINDOW_X")) {
                    this.setWindowX(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("WINDOW_Y")) {
                    this.setWindowY(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("SHOW_TRAY_DIALOG")) {
                    Boolean showTrayDialog = new Boolean(p);
                    this.setShowTrayDialog(showTrayDialog);
                    continue;
                }
                if (key.equals("MINIMIZE_TO_TRAY")) {
                    Boolean minimize = new Boolean(p);
                    this.setMinimizeToTray(minimize);
                    continue;
                }
                if (key.equals("SHOW_CLOSE_DIALOG")) {
                    Boolean showCloseDialog = new Boolean(p);
                    this.setShowCloseDialog(showCloseDialog);
                    continue;
                }
                if (key.equals("CLASSPATH")) {
                    this.setClassPath(p);
                    continue;
                }
                if (key.equals("MAIN_CLASS")) {
                    this.setMainClass(p);
                    continue;
                }
                if (key.equals("LANGUAGE")) {
                    this.setLanguage(p);
                    continue;
                }
                if (key.equals("COUNTRY")) {
                    this.setCountry(p);
                    continue;
                }
                if (key.equals("MINIMUM_SEARCH_QAULITY")) {
                    this.setMinimumSearchQuality(Integer.parseInt(p));
                    continue;
                }
                if (key.equals("MINIMUM_SEARCH_SPEED")) {
                    this.setMinimumSearchSpeed(Integer.parseInt(p));
                    continue;
                }
                if (!key.equals("SEARCH_FILTER_MESSAGE_SHOWN")) continue;
                Boolean messageShown = new Boolean(p);
                this.set17SearchMessageShown(messageShown);
            }
            catch (NumberFormatException nfe) {
            }
            catch (IllegalArgumentException iae) {
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        if (this.getConnectionSpeed() <= 56) {
            this.setKeepAlive(Math.min(2, this.getKeepAlive()));
            this.setMaxIncomingConnections(2);
        }
    }

    private void loadDefaults() {
        this.setAllowBrowser(false);
        this.setMaxTTL((byte)16);
        this.setSoftMaxTTL((byte)7);
        this.setTTL((byte)7);
        this.setMaxLength(65536);
        this.setTimeout(8000);
        this.setKeepAlive(4);
        this.setPort(6346);
        this.setConnectionSpeed(56);
        this.setUploadSpeed(100);
        this.setSearchLimit((byte)64);
        this.setClientID(new GUID(Message.makeGuid()).toHexString());
        this.setMaxIncomingConnections(4);
        this.setBannedIps(this.DEFAULT_BANNED_IPS);
        this.setBannedWords(this.DEFAULT_BANNED_WORDS);
        this.setFilterAdult(false);
        this.setFilterDuplicates(true);
        this.setFilterVbs(true);
        this.setFilterHtml(false);
        this.setFilterGreedyQueries(true);
        this.setExtensions("html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;wav;au;aif;aiff;ra;ram;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg");
        this.setBannedIps(this.DEFAULT_BANNED_IPS);
        this.setBannedWords(this.DEFAULT_BANNED_WORDS);
        this.setFilterAdult(false);
        this.setFilterDuplicates(true);
        this.setFilterVbs(true);
        this.setFilterHtml(false);
        this.setFilterGreedyQueries(true);
        this.setFilterBearShareQueries(true);
        this.setUseQuickConnect(true);
        this.setQuickConnectHosts(this.DEFAULT_QUICK_CONNECT_HOSTS);
        this.setParallelSearchMax(5);
        this.setClearCompletedUpload(true);
        this.setClearCompletedDownload(false);
        this.setMaxSimDownload(4);
        this.setPromptExeDownload(true);
        this.setMaxUploads(8);
        this.setSearchAnimationTime(20);
        this.setConnectString(DEFAULT_CONNECT_STRING);
        this.setConnectOkString("GNUTELLA OK");
        this.setCheckAgain(true);
        this.setBasicInfoForQuery(1000);
        this.setAdvancedInfoForQuery(50);
        this.setForceIPAddress(false);
        this.setForcedIPAddressString("0.0.0.0");
        this.setForcedPort(6346);
        this.setFreeloaderFiles(1);
        this.setFreeloaderAllowed(100);
        this.setUploadsPerPerson(3);
        this.setAverageUptime(200L);
        this.setTotalUptime(0L);
        this.setSessions(1);
        this.setInstalled(false);
        this.setRunOnce(false);
        this.setShowTrayDialog(true);
        this.setMinimizeToTray(true);
        this.setShowCloseDialog(true);
        this.setClassPath(this.DEFAULT_CLASSPATH);
        this.setMainClass("com.limegroup.gnutella.gui.Main");
        this.setAppWidth(640);
        this.setAppHeight(620);
        this.setChatEnabled(true);
        this.setLanguage("en");
        this.setCountry("US");
        this.setMinimumSearchQuality(2);
        this.setMinimumSearchSpeed(56);
        this.set17SearchMessageShown(false);
    }

    public boolean getAllowBrowser() {
        return this._allowBroswer;
    }

    public byte getTTL() {
        return this._ttl;
    }

    public byte getSoftMaxTTL() {
        return this._softmaxttl;
    }

    public byte getMaxTTL() {
        return this._maxttl;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getHostList() {
        return new File("gnutella.net").getAbsolutePath();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public int getPort() {
        return this._port;
    }

    public int getConnectionSpeed() {
        return this._connectionSpeed;
    }

    public int getUploadSpeed() {
        return this._uploadSpeed;
    }

    public byte getSearchLimit() {
        return this._searchLimit;
    }

    public String getClientID() {
        return this._clientID;
    }

    public int getMaxIncomingConnections() {
        return this._maxIncomingConn;
    }

    public int getUploadsPerPerson() {
        return this._uploadsPerPerson;
    }

    public File getSaveDirectory() throws FileNotFoundException {
        if (this._saveDirectory == null) {
            throw new FileNotFoundException();
        }
        return this._saveDirectory;
    }

    public boolean getChatEnabled() {
        return this._chatEnabled;
    }

    public File getIncompleteDirectory() throws FileNotFoundException {
        if (this._incompleteDirectory == null) {
            throw new FileNotFoundException();
        }
        return this._incompleteDirectory;
    }

    public File getSaveDefault() {
        return new File("Shared");
    }

    public String getDirectories() {
        return this._directories;
    }

    public String[] getDirectoriesAsArray() {
        if (this._directories == null) {
            return new String[0];
        }
        this._directories.trim();
        return StringUtils.split(this._directories, ';');
    }

    public String[] getDirectoriesWithIncompleteAsArray() {
        String temp = this._directories;
        temp.trim();
        if (!temp.endsWith(STRING_DELIMETER)) {
            temp = temp + STRING_DELIMETER;
        }
        String incompleteDir = "";
        try {
            incompleteDir = this.getIncompleteDirectory().getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        temp = temp + incompleteDir;
        return StringUtils.split(temp, ';');
    }

    public File getDownloadSnapshotFile() {
        File incompleteDir = null;
        try {
            incompleteDir = this.getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return new File(incompleteDir, "downloads.dat");
    }

    public String getExtensions() {
        return this._extensions;
    }

    public String getDefaultExtensions() {
        return "html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;wav;au;aif;aiff;ra;ram;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg";
    }

    public String[] getBannedIps() {
        return this._bannedIps;
    }

    public String[] getBannedWords() {
        return this._bannedWords;
    }

    public boolean getFilterAdult() {
        return this._filterAdult;
    }

    public boolean getFilterDuplicates() {
        return this._filterDuplicates;
    }

    public boolean getFilterHtml() {
        return this._filterHtml;
    }

    public boolean getFilterVbs() {
        return this._filterVbs;
    }

    public boolean getFilterGreedyQueries() {
        return this._filterGreedyQueries;
    }

    public boolean getFilterBearShareQueries() {
        return this._filterBearShare;
    }

    public boolean getUseQuickConnect() {
        return this._useQuickConnect;
    }

    public String[] getQuickConnectHosts() {
        return this._quickConnectHosts;
    }

    public int getParallelSearchMax() {
        return this._parallelSearchMax;
    }

    public int getMaxSimDownload() {
        return this._maxSimDownload;
    }

    public boolean getPromptExeDownload() {
        return this._promptExeDownload;
    }

    public int getMaxUploads() {
        return this._maxUploads;
    }

    public boolean getClearCompletedUpload() {
        return this._clearCompletedUpload;
    }

    public boolean getClearCompletedDownload() {
        return this._clearCompletedDownload;
    }

    public int getSearchAnimationTime() {
        return this._searchAnimationTime;
    }

    public String getConnectString() {
        return this._connectString;
    }

    public String getConnectStringFirstWord() {
        return this._connectStringFirstWord;
    }

    public String getConnectStringRemainder() {
        return this._connectStringRemainder;
    }

    public String getConnectOkString() {
        return this._connectOkString;
    }

    public Properties getNDProps() {
        return this._ndProps;
    }

    public String getPath() {
        return this.CURRENT_DIRECTORY + File.separator;
    }

    public int getBasicInfoSizeForQuery() {
        return this._basicQueryInfo;
    }

    public int getAdvancedInfoSizeForQuery() {
        return this._advancedQueryInfo;
    }

    public boolean getForceIPAddress() {
        return this._forceIPAddress;
    }

    public byte[] getForcedIPAddress() {
        return this._forcedIPAddress;
    }

    public String getForcedIPAddressString() {
        return Message.ip2string(this._forcedIPAddress);
    }

    public int getForcedPort() {
        return this._forcedPort;
    }

    public boolean getCheckAgain() {
        Boolean b = new Boolean(this._props.getProperty("CHECK_AGAIN"));
        return b;
    }

    public int getFreeloaderFiles() {
        return this._freeLoaderFiles;
    }

    public int getFreeloaderAllowed() {
        return this._freeLoaderAllowed;
    }

    public long getAverageUptime() {
        return this._averageUptime;
    }

    public long getTotalUptime() {
        return this._totalUptime;
    }

    public int getSessions() {
        return this._sessions;
    }

    public boolean getInstalled() {
        return this._installed;
    }

    public int getAppWidth() {
        return Integer.parseInt(this._props.getProperty("APP_WIDTH"));
    }

    public int getAppHeight() {
        return Integer.parseInt(this._props.getProperty("APP_HEIGHT"));
    }

    public boolean getRunOnce() {
        Boolean b = Boolean.valueOf(this._props.getProperty("RUN_ONCE"));
        return b;
    }

    public int getWindowX() {
        return Integer.parseInt(this._props.getProperty("WINDOW_X"));
    }

    public int getWindowY() {
        return Integer.parseInt(this._props.getProperty("WINDOW_Y"));
    }

    public boolean getShowTrayDialog() {
        Boolean b = Boolean.valueOf(this._props.getProperty("SHOW_TRAY_DIALOG"));
        return b;
    }

    public boolean getMinimizeToTray() {
        Boolean b = new Boolean(this._props.getProperty("MINIMIZE_TO_TRAY"));
        return b;
    }

    public boolean getAcceptedIncoming() {
        return this._acceptedIncoming;
    }

    public boolean getShowCloseDialog() {
        Boolean b = Boolean.valueOf(this._props.getProperty("SHOW_CLOSE_DIALOG"));
        return b;
    }

    public String getClassPath() {
        return this._props.getProperty("CLASSPATH");
    }

    public String getMainClass() {
        return this._props.getProperty("MAIN_CLASS");
    }

    public String getLanguage() {
        return this._props.getProperty("LANGUAGE");
    }

    public String getCountry() {
        return this._props.getProperty("COUNTRY");
    }

    public int getMinimumSearchQuality() {
        String str = this._props.getProperty("MINIMUM_SEARCH_QAULITY");
        return Integer.parseInt(str);
    }

    public int getMinimumSearchSpeed() {
        String str = this._props.getProperty("MINIMUM_SEARCH_SPEED");
        return Integer.parseInt(str);
    }

    public boolean get17SearchMessageShown() {
        Boolean b = Boolean.valueOf(this._props.getProperty("SEARCH_FILTER_MESSAGE_SHOWN"));
        return b;
    }

    public void updateUptime(int currentTime) {
        this._totalUptime += (long)currentTime;
        this._averageUptime = this._totalUptime / (long)this._sessions;
        this.setTotalUptime(this._totalUptime);
        this.setAverageUptime(this._averageUptime);
    }

    private void setSessions(int sessions) {
        if (this._sessions < 1) {
            this._sessions = 10;
        }
        this._sessions = sessions;
        String s = Integer.toString(this._sessions);
        ((Hashtable)this._props).put("SESSIONS", s);
    }

    private void setAverageUptime(long averageUptime) {
        this._averageUptime = averageUptime;
        String s = Long.toString(this._averageUptime);
        ((Hashtable)this._props).put("AVERAGE_UPTIME", s);
    }

    private void setTotalUptime(long totalUptime) {
        this._totalUptime = totalUptime;
        String s = Long.toString(this._totalUptime);
        ((Hashtable)this._props).put("TOTAL_UPTIME", s);
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
        String s = Integer.toString(this._maxLength);
        ((Hashtable)this._props).put("MAX_LENGTH", s);
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        String s = Integer.toString(this._timeout);
        ((Hashtable)this._props).put("TIMEOUT", s);
    }

    public void setKeepAlive(int keepAlive) throws IllegalArgumentException {
        try {
            this.setKeepAlive(keepAlive, false);
        }
        catch (BadConnectionSettingException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setKeepAlive(int keepAlive, boolean checkLimit) throws BadConnectionSettingException {
        int max;
        int incoming = this.getMaxIncomingConnections();
        if (checkLimit && keepAlive > (max = this.maxConnections())) {
            throw new BadConnectionSettingException(2, max, this.maxConnections());
        }
        if (keepAlive < 0) {
            throw new BadConnectionSettingException(1, 0, this.getMaxIncomingConnections());
        }
        this._keepAlive = keepAlive;
        String s = Integer.toString(this._keepAlive);
        ((Hashtable)this._props).put("KEEP_ALIVE", s);
    }

    private int maxConnections() {
        int speed = this.getConnectionSpeed();
        if (speed <= 56) {
            return 3;
        }
        if (speed <= 350) {
            return 6;
        }
        if (speed <= 1000) {
            return 10;
        }
        return Integer.MAX_VALUE;
    }

    public void setSearchLimit(byte limit) {
        if (limit < 0 || limit > 10000) {
            throw new IllegalArgumentException();
        }
        this._searchLimit = limit;
        String s = Byte.toString(this._searchLimit);
        ((Hashtable)this._props).put("SEARCH_LIMIT", s);
    }

    public void setClientID(String clientID) {
        this._clientID = clientID;
        ((Hashtable)this._props).put("CLIENT_ID", this._clientID);
    }

    public void setMaxIncomingConnections(int maxConn) throws IllegalArgumentException {
        try {
            this.setMaxIncomingConnections(maxConn, false);
        }
        catch (BadConnectionSettingException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setMaxIncomingConnections(int maxConn, boolean checkLimit) throws BadConnectionSettingException {
        int max;
        if (checkLimit && maxConn > (max = this.maxConnections())) {
            throw new BadConnectionSettingException(2, this.getKeepAlive(), max);
        }
        if (maxConn < 0) {
            throw new BadConnectionSettingException(1, this.getKeepAlive(), 0);
        }
        this._maxIncomingConn = maxConn;
        String s = Integer.toString(maxConn);
        ((Hashtable)this._props).put("MAX_INCOMING_CONNECTIONS", s);
    }

    public void setMaxTTL(byte maxttl) throws IllegalArgumentException {
        if (maxttl < 0 || maxttl > 50) {
            throw new IllegalArgumentException();
        }
        this._maxttl = maxttl;
        String s = Byte.toString(this._maxttl);
        ((Hashtable)this._props).put("MAX_TTL", s);
    }

    public void setBasicInfoForQuery(int basicInfo) {
        this._basicQueryInfo = basicInfo;
        String s = Integer.toString(basicInfo);
        ((Hashtable)this._props).put("BASIC_QUERY_INFO", s);
    }

    public void setUploadsPerPerson(int uploads) {
        this._uploadsPerPerson = uploads;
        String s = Integer.toString(uploads);
        ((Hashtable)this._props).put("UPLOADS_PER_PERSON", s);
    }

    public void setAdvancedInfoForQuery(int advancedInfo) {
        this._advancedQueryInfo = advancedInfo;
        String s = Integer.toString(advancedInfo);
        ((Hashtable)this._props).put("ADVANCED_QUERY_INFO", s);
    }

    public void setSaveDirectory(File saveDir) throws IOException {
        if (saveDir == null) {
            throw new NullPointerException();
        }
        String parentDir = saveDir.getParent();
        File incDir = new File(parentDir, "Incomplete");
        if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
            throw new IOException();
        }
        if (!incDir.isDirectory() && !incDir.mkdirs()) {
            throw new IOException();
        }
        this._saveDirectory = saveDir;
        this._incompleteDirectory = incDir;
        ((Hashtable)this._props).put("DIRECTORY_FOR_SAVING_FILES", saveDir.getAbsolutePath());
    }

    /*
     * Unable to fully structure code
     */
    public void setDirectories(String dirs) {
        dirsModified = false;
        this._directories = dirs;
        dirArray = this.getDirectoriesAsArray();
        i = 0;
        while (i < dirArray.length) {
            block11: {
                block12: {
                    if (dirArray[i] == null) break block11;
                    f = new File(dirArray[i]);
                    if (!f.isDirectory()) break block12;
                    count = 0;
                    z = 0;
                    str = "";
                    try {
                        str = f.getCanonicalPath();
                        if (true) ** GOTO lbl30
                    }
                    catch (IOException ioe) {
                        break;
                    }
                    do {
                        if (dirArray[z] != null) {
                            file = new File(dirArray[z]);
                            name = "";
                            try {
                                name = file.getCanonicalPath();
                            }
                            catch (IOException ioe) {
                                break block11;
                            }
                            if (str.equals(name) && ++count > 1) {
                                dirArray[z] = null;
                                dirsModified = true;
                            }
                        }
                        ++z;
lbl30:
                        // 2 sources

                    } while (z < dirArray.length);
                    break block11;
                }
                dirArray[i] = null;
                dirsModified = true;
            }
            ++i;
        }
        if (dirsModified) {
            i = 0;
            sb = new StringBuffer();
            while (i < dirArray.length) {
                if (dirArray[i] != null) {
                    sb.append(dirArray[i]);
                    sb.append(';');
                }
                ++i;
            }
            this._directories = sb.toString();
        }
        this._props.put("DIRECTORIES_TO_SEARCH_FOR_FILES", this._directories);
    }

    public void addDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException();
        }
        String[] dirs = this.getDirectoriesAsArray();
        String newPath = "";
        newPath = dir.getCanonicalPath();
        int i = 0;
        while (i < dirs.length) {
            File file = new File(dirs[i]);
            String name = "";
            name = file.getCanonicalPath();
            if (name.equals(newPath)) {
                throw new IOException();
            }
            ++i;
        }
        if (!this._directories.endsWith(STRING_DELIMETER)) {
            this._directories = this._directories + STRING_DELIMETER;
        }
        this._directories = this._directories + newPath;
        this._directories = this._directories + STRING_DELIMETER;
        ((Hashtable)this._props).put("DIRECTORIES_TO_SEARCH_FOR_FILES", this._directories);
    }

    public void setExtensions(String ext) {
        this._extensions = ext;
        ((Hashtable)this._props).put("EXTENSIONS_TO_SEARCH_FOR", ext);
    }

    public void setTTL(byte ttl) {
        if (ttl < 1 || ttl > 14) {
            throw new IllegalArgumentException();
        }
        this._ttl = ttl;
        String s = Byte.toString(this._ttl);
        ((Hashtable)this._props).put("TTL", s);
    }

    public void setSoftMaxTTL(byte softmaxttl) {
        if (softmaxttl < 0 || softmaxttl > 14) {
            throw new IllegalArgumentException();
        }
        this._softmaxttl = softmaxttl;
        String s = Byte.toString(softmaxttl);
        ((Hashtable)this._props).put("SOFT_MAX_TTL", s);
    }

    public void setPort(int port) {
        if (port > 65536 || port < 0) {
            throw new IllegalArgumentException();
        }
        this._port = port;
        String s = Integer.toString(this._port);
        ((Hashtable)this._props).put("PORT", s);
    }

    public void setConnectionSpeed(int speed) {
        if (speed < 0 || speed > 20000) {
            throw new IllegalArgumentException();
        }
        this._connectionSpeed = speed;
        String s = Integer.toString(this._connectionSpeed);
        ((Hashtable)this._props).put("CONNECTION_SPEED", s);
    }

    public void setUploadSpeed(int speed) {
        if (speed < 0 || speed > 100) {
            throw new IllegalArgumentException();
        }
        this._uploadSpeed = speed;
        String s = Integer.toString(this._uploadSpeed);
        ((Hashtable)this._props).put("UPLOAD_SPEED", s);
    }

    public void setConnectString(String connect) throws IllegalArgumentException {
        int i = connect.indexOf(" ");
        if (connect.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (i == -1 || i == connect.length() - 1) {
            throw new IllegalArgumentException();
        }
        String firstWord = connect.substring(0, i);
        String remainder = connect.substring(i + 1);
        String uppered = firstWord.toUpperCase();
        if (uppered.equals("GIV") || uppered.equals("GET") || uppered.equals("PUT") || uppered.equals("POST") || uppered.equals("HEAD") || uppered.equals("DELETE")) {
            throw new IllegalArgumentException();
        }
        this._connectString = connect;
        this._connectStringFirstWord = firstWord;
        this._connectStringRemainder = remainder;
        ((Hashtable)this._props).put("CONNECT_STRING", connect);
    }

    public void setConnectOkString(String ok) throws IllegalArgumentException {
        if (ok.length() < 1) {
            throw new IllegalArgumentException();
        }
        this._connectOkString = ok;
        ((Hashtable)this._props).put("CONNECT_OK_STRING", ok);
    }

    public void setParallelSearchMax(int max) {
        if (max < 1) {
            throw new IllegalArgumentException();
        }
        this._parallelSearchMax = max;
        String s = String.valueOf(max);
        ((Hashtable)this._props).put("PARALLEL_SEARCH", s);
    }

    public void setMaxSimDownload(int max) {
        this._maxSimDownload = max;
        String s = String.valueOf(max);
        ((Hashtable)this._props).put("MAX_SIM_DOWNLOAD", s);
    }

    public void setPromptExeDownload(boolean prompt) {
        this._promptExeDownload = prompt;
        String s = String.valueOf(prompt);
        ((Hashtable)this._props).put("PROMPT_EXE_DOWNLOAD", s);
    }

    public void setChatEnabled(boolean chatEnabled) {
        this._chatEnabled = chatEnabled;
        String s = String.valueOf(chatEnabled);
        ((Hashtable)this._props).put("CHAT_ENABLED", s);
    }

    public void setMaxUploads(int max) {
        this._maxUploads = max;
        String s = String.valueOf(max);
        ((Hashtable)this._props).put("MAX_UPLOADS", s);
    }

    public void setClearCompletedUpload(boolean b) {
        this._clearCompletedUpload = b;
        String s = String.valueOf(b);
        ((Hashtable)this._props).put("CLEAR_UPLOAD", s);
    }

    public void setClearCompletedDownload(boolean b) {
        this._clearCompletedDownload = b;
        String s = String.valueOf(b);
        ((Hashtable)this._props).put("CLEAR_DOWNLOAD", s);
    }

    public void setForceIPAddress(boolean force) {
        String c = force ? "true" : "false";
        this._forceIPAddress = force;
        ((Hashtable)this._props).put("FORCE_IP_ADDRESS", c);
    }

    public void setAllowBrowser(boolean allow) {
        String c = allow ? "true" : "false";
        this._allowBroswer = allow;
        ((Hashtable)this._props).put("ALLOW_BROWSER", c);
    }

    public void setForcedIPAddressString(String address) throws IllegalArgumentException {
        try {
            InetAddress ia = InetAddress.getByName(address);
            this._forcedIPAddress = ia.getAddress();
            ((Hashtable)this._props).put("FORCED_IP_ADDRESS_STRING", address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setForcedPort(int port) {
        if (port > 65536 || port < 1) {
            throw new IllegalArgumentException();
        }
        this._forcedPort = port;
        String s = Integer.toString(this._forcedPort);
        ((Hashtable)this._props).put("FORCED_PORT", s);
    }

    public void setInstalled(boolean installed) {
        this._installed = installed;
        String s = String.valueOf(installed);
        ((Hashtable)this._props).put("INSTALLED", s);
    }

    public void setBannedIps(String[] bannedIps) {
        if (bannedIps == null) {
            throw new IllegalArgumentException();
        }
        this._bannedIps = bannedIps;
        ((Hashtable)this._props).put("BLACK_LISTED_IP_ADDRESSES", SettingsManager.encode(bannedIps));
    }

    public void setBannedWords(String[] bannedWords) {
        if (bannedWords == null) {
            throw new IllegalArgumentException();
        }
        this._bannedWords = bannedWords;
        ((Hashtable)this._props).put("BANNED_WORDS", SettingsManager.encode(bannedWords));
    }

    public void setFilterAdult(boolean filterAdult) {
        this._filterAdult = filterAdult;
        Boolean b = new Boolean(filterAdult);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_ADULT", s);
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this._filterDuplicates = filterDuplicates;
        Boolean b = new Boolean(filterDuplicates);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_DUPLICATES", s);
    }

    public void setFilterHtml(boolean filterHtml) {
        this._filterHtml = filterHtml;
        Boolean b = new Boolean(filterHtml);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_HTML", s);
    }

    public void setFilterVbs(boolean filterVbs) {
        this._filterVbs = filterVbs;
        Boolean b = new Boolean(filterVbs);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_VBS", s);
    }

    public void setFilterGreedyQueries(boolean yes) {
        this._filterGreedyQueries = yes;
        Boolean b = new Boolean(yes);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_GREEDY_QUERIES", s);
    }

    public void setFilterBearShareQueries(boolean yes) {
        this._filterBearShare = yes;
        Boolean b = new Boolean(yes);
        String s = b.toString();
        ((Hashtable)this._props).put("FILTER_HIGHBIT_QUERIES", s);
    }

    public void setUseQuickConnect(boolean useQuickConnect) {
        this._useQuickConnect = useQuickConnect;
        Boolean b = new Boolean(useQuickConnect);
        String s = b.toString();
        ((Hashtable)this._props).put("USE_QUICK_CONNECT", s);
    }

    public void setQuickConnectHosts(String[] hosts) {
        if (hosts == null) {
            throw new IllegalArgumentException();
        }
        this._quickConnectHosts = hosts;
        ((Hashtable)this._props).put("QUICK_CONNECT_HOSTS", SettingsManager.encode(hosts));
    }

    public void setSearchAnimationTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        this._searchAnimationTime = seconds;
        String s = Integer.toString(seconds);
        ((Hashtable)this._props).put("SEARCH_ANIMATION_TIME", s);
    }

    public void setFreeloaderAllowed(int allowed) throws IllegalArgumentException {
        if (allowed > 100 || allowed < 0) {
            throw new IllegalArgumentException();
        }
        this._freeLoaderAllowed = allowed;
        String s = Integer.toString(allowed);
        ((Hashtable)this._props).put("FREELOADER_ALLOWED", s);
    }

    public void setFreeloaderFiles(int files) throws IllegalArgumentException {
        if (files < 0) {
            throw new IllegalArgumentException();
        }
        this._freeLoaderFiles = files;
        String s = Integer.toString(files);
        ((Hashtable)this._props).put("FREELOADER_FILES", s);
    }

    public void setCheckAgain(boolean check) {
        Boolean b = new Boolean(check);
        ((Hashtable)this._props).put("CHECK_AGAIN", b.toString());
    }

    public void setAppWidth(int width) {
        String s = Integer.toString(width);
        ((Hashtable)this._props).put("APP_WIDTH", s);
    }

    public void setAppHeight(int height) {
        ((Hashtable)this._props).put("APP_HEIGHT", Integer.toString(height));
    }

    public void setRunOnce(boolean runOnce) {
        Boolean b = new Boolean(runOnce);
        ((Hashtable)this._props).put("RUN_ONCE", b.toString());
    }

    public void setWindowX(int x) {
        ((Hashtable)this._props).put("WINDOW_X", Integer.toString(x));
    }

    public void setWindowY(int y) {
        ((Hashtable)this._props).put("WINDOW_Y", Integer.toString(y));
    }

    public void setShowTrayDialog(boolean showDialog) {
        Boolean b = new Boolean(showDialog);
        ((Hashtable)this._props).put("SHOW_TRAY_DIALOG", b.toString());
    }

    public void setMinimizeToTray(boolean minimize) {
        Boolean b = new Boolean(minimize);
        ((Hashtable)this._props).put("MINIMIZE_TO_TRAY", b.toString());
    }

    public void setAcceptedIncoming(boolean incoming) {
        this._acceptedIncoming = incoming;
    }

    public void setShowCloseDialog(boolean showDialog) {
        Boolean b = new Boolean(showDialog);
        ((Hashtable)this._props).put("SHOW_CLOSE_DIALOG", b.toString());
    }

    public void setClassPath(String classpath) {
        ((Hashtable)this._props).put("CLASSPATH", classpath);
    }

    public void setMainClass(String mainClass) {
        ((Hashtable)this._props).put("MAIN_CLASS", mainClass);
    }

    public void setLanguage(String language) {
        ((Hashtable)this._props).put("LANGUAGE", language);
    }

    public void setCountry(String country) {
        ((Hashtable)this._props).put("COUNTRY", country);
    }

    public void setMinimumSearchQuality(int quality) {
        ((Hashtable)this._props).put("MINIMUM_SEARCH_QAULITY", Integer.toString(quality));
    }

    public void setMinimumSearchSpeed(int speed) {
        ((Hashtable)this._props).put("MINIMUM_SEARCH_SPEED", Integer.toString(speed));
    }

    public void set17SearchMessageShown(boolean shown) {
        Boolean b = new Boolean(shown);
        ((Hashtable)this._props).put("SEARCH_FILTER_MESSAGE_SHOWN", b.toString());
    }

    /*
     * Loose catch block
     */
    public void writeProperties() {
        block11: {
            FileOutputStream ostream = null;
            ostream = new FileOutputStream(new File("limewire.props"));
            this._props.save(ostream, "");
            ostream.close();
            Object var4_2 = null;
            try {
                if (ostream != null) {
                    ostream.close();
                }
                break block11;
            }
            catch (IOException io) {}
            break block11;
            {
                catch (Exception e) {
                    Object var4_3 = null;
                    try {
                        if (ostream != null) {
                            ostream.close();
                        }
                        break block11;
                    }
                    catch (IOException io) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (ostream != null) {
                        ostream.close();
                    }
                }
                catch (IOException io) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String encode(String[] array) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < array.length - 1) {
            buf.append(array[i]);
            buf.append(STRING_DELIMETER);
            ++i;
        }
        if (array.length != 0) {
            buf.append(array[array.length - 1]);
        }
        return buf.toString();
    }

    private static String[] decode(String s) {
        StringTokenizer lexer = new StringTokenizer(s, STRING_DELIMETER);
        Vector buf = new Vector();
        while (lexer.hasMoreTokens()) {
            buf.add((Object)lexer.nextToken());
        }
        Object[] ret = new String[buf.size()];
        buf.copyInto(ret);
        return ret;
    }
}

