/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.BearShareFilter;
import com.limegroup.gnutella.filters.BlackListFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.sun.java.util.collections.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        SettingsManager settings = SettingsManager.instance();
        String[] badWords = settings.getBannedWords();
        boolean filterAdult = settings.getFilterAdult();
        boolean filterVbs = settings.getFilterVbs();
        boolean filterHtml = settings.getFilterHtml();
        if (badWords.length != 0 || filterAdult || filterVbs || filterHtml) {
            KeywordFilter kf = new KeywordFilter();
            int i = 0;
            while (i < badWords.length) {
                kf.disallow(badWords[i]);
                ++i;
            }
            if (filterAdult) {
                kf.disallowAdult();
            }
            if (filterVbs) {
                kf.disallowVbs();
            }
            if (filterHtml) {
                kf.disallowHtml();
            }
            return kf;
        }
        return new AllowFilter();
    }

    public static SpamFilter newRouteFilter() {
        SettingsManager settings = SettingsManager.instance();
        Vector buf = new Vector();
        String[] badIPs = settings.getBannedIps();
        if (badIPs.length != 0) {
            BlackListFilter bf;
            BlackListFilter blackListFilter = bf = BlackListFilter.instance();
            synchronized (blackListFilter) {
                bf.clear();
                int i = 0;
                while (i < badIPs.length) {
                    bf.add(badIPs[i]);
                    ++i;
                }
            }
            buf.add((Object)bf);
        }
        if (settings.getFilterDuplicates()) {
            buf.add((Object)new DuplicateFilter());
        }
        if (settings.getFilterGreedyQueries()) {
            buf.add((Object)new GreedyQueryFilter());
        }
        if (settings.getFilterBearShareQueries()) {
            buf.add((Object)new BearShareFilter());
        }
        if (buf.size() == 0) {
            return new AllowFilter();
        }
        if (buf.size() == 1) {
            return (SpamFilter)buf.get(0);
        }
        Object[] delegates = new SpamFilter[buf.size()];
        buf.copyInto(delegates);
        return new CompositeFilter((SpamFilter[])delegates);
    }

    public abstract boolean allow(Message var1);
}

