/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SettingsManager;
import java.io.IOException;

public class StandardMessageRouter
extends MessageRouter {
    private ActivityCallback _callback;

    public StandardMessageRouter(ActivityCallback callback) {
        this._callback = callback;
    }

    public void handleQueryRequest(QueryRequest queryRequest, ManagedConnection receivingConnection) {
        if (!receivingConnection.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        super.handleQueryRequest(queryRequest, receivingConnection);
    }

    protected void respondToPingRequest(PingRequest pingRequest, Acceptor acceptor) {
        byte hops = pingRequest.getHops();
        byte ttl = pingRequest.getTTL();
        if (!this._manager.hasAvailableIncoming() && hops + ttl > 2) {
            return;
        }
        int num_files = FileManager.instance().getNumFiles();
        int kilobytes = FileManager.instance().getSize() / 1024;
        PingReply pingReply = new PingReply(pingRequest.getGUID(), (byte)(pingRequest.getHops() + 1), acceptor.getPort(), acceptor.getAddress(), num_files, kilobytes);
        try {
            this.sendPingReply(pingReply);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void handlePingReply(PingReply pingReply, ManagedConnection receivingConnection) {
        receivingConnection.updateHorizonStats(pingReply);
        super.handlePingReply(pingReply, receivingConnection);
    }

    protected void handlePingReplyForMe(PingReply pingReply, ManagedConnection receivingConnection) {
        SettingsManager settings = SettingsManager.instance();
        if (pingReply.getHops() <= 1 && receivingConnection.getNumMessagesReceived() <= 2 && !receivingConnection.isOutgoing() && receivingConnection.isKillable() && pingReply.getFiles() < (long)settings.getFreeloaderFiles() && (int)(Math.random() * 100.0) > settings.getFreeloaderAllowed()) {
            this._manager.remove(receivingConnection);
        }
    }

    protected void respondToQueryRequest(QueryRequest queryRequest, Acceptor acceptor, byte[] clientGUID) {
        FileManager fm = FileManager.instance();
        Response[] responses = fm.query(queryRequest);
        if (responses == null || responses.length < 1) {
            return;
        }
        byte[] guid = queryRequest.getGUID();
        byte ttl = (byte)(queryRequest.getHops() + 1);
        int port = acceptor.getPort();
        byte[] ip = acceptor.getAddress();
        long speed = this._uploadManager.measuredUploadSpeed();
        boolean measuredSpeed = true;
        if (speed == -1L) {
            speed = SettingsManager.instance().getConnectionSpeed();
            measuredSpeed = false;
        }
        int numResponses = responses.length;
        int index = 0;
        byte numHops = queryRequest.getHops();
        while (numResponses > 0) {
            Response[] res;
            int arraySize = numResponses < 255 ? numResponses : 255;
            if (index == 0 && arraySize < 255) {
                res = responses;
            } else {
                res = new Response[arraySize];
                int i = 0;
                while (i < arraySize) {
                    res[i] = responses[index];
                    ++index;
                    ++i;
                }
            }
            numResponses -= arraySize;
            boolean busy = this._uploadManager.isBusy();
            boolean uploaded = this._uploadManager.hadSuccesfulUpload();
            boolean incoming = this._acceptor.acceptedIncoming();
            boolean chat = SettingsManager.instance().getChatEnabled();
            QueryReply queryReply = new QueryReply(guid, ttl, port, ip, speed, res, clientGUID, !incoming, busy, uploaded, measuredSpeed, chat);
            try {
                this.sendQueryReply(queryReply);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (numHops > 2) break;
        }
    }

    protected void handleQueryReplyForMe(QueryReply queryReply, ManagedConnection receivingConnection) {
        if (!receivingConnection.isPersonalSpam(queryReply)) {
            this._callback.handleQueryReply(queryReply);
        }
    }

    protected void handlePushRequestForMe(PushRequest pushRequest, ManagedConnection receivingConnection) {
        FileDesc desc;
        byte[] ip = pushRequest.getIP();
        StringBuffer buf = new StringBuffer();
        buf.append(ByteOrder.ubyte2int(ip[0]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[1]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[2]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[3]) + "");
        String h = buf.toString();
        int port = pushRequest.getPort();
        int index = (int)pushRequest.getIndex();
        String req_guid_hexstring = new GUID(pushRequest.getClientGUID()).toString();
        try {
            desc = FileManager.instance().get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        String file = desc._name;
        if (!this._acceptor.isBannedIP(h)) {
            this._uploadManager.acceptPushUpload(file, h, port, index, req_guid_hexstring);
        }
    }
}

