/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.Buffer;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;

public class UploadManager {
    private ActivityCallback _callback;
    private MessageRouter _router;
    private Acceptor _acceptor;
    private static final int PUSH_INVALIDATE_TIME = 300;
    private List _failedPushes = new LinkedList();
    private List _attemptingPushes = new LinkedList();
    private static Map _uploadsInProgress = new HashMap();
    private volatile int _activeUploads = 0;
    private volatile boolean _hadSuccesfulUpload = false;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;

    public void initialize(ActivityCallback callback, MessageRouter router, Acceptor acceptor) {
        this._callback = callback;
        this._router = router;
        this._acceptor = acceptor;
    }

    public synchronized void acceptUpload(Socket socket) {
        GETLine line;
        try {
            line = this.parseGET(socket);
        }
        catch (IOException e) {
            return;
        }
        HTTPUploader uploader = new HTTPUploader(line._file, socket, line._index, this);
        String host = socket.getInetAddress().getHostAddress();
        this.insertAndTest(uploader, host);
        UploadRunner runner = new UploadRunner(uploader, host, line._index);
        Thread upThread = new Thread(runner);
        upThread.setDaemon(true);
        upThread.start();
    }

    public synchronized void acceptPushUpload(String file, String host, int port, int index, String guid) {
        this.clearFailedPushes();
        HTTPUploader uploader = new HTTPUploader(file, host, port, index, guid, this);
        if (!this.testAttemptedPush(host, index) || !this.testFailedPush(host, index)) {
            return;
        }
        this.insertAndTest(uploader, host);
        this.insertAttemptedPush(host, index);
        UploadRunner runner = new UploadRunner(uploader, host, index);
        Thread upThread = new Thread(runner);
        upThread.setDaemon(true);
        upThread.start();
    }

    public boolean isBusy() {
        return !this.testTotalUploadLimit();
    }

    public int uploadsInProgress() {
        return this._activeUploads;
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    private void insertAndTest(Uploader uploader, String host) {
        this.insertIntoMap(host);
        if (!this.testPerHostLimit(host) || !this.testTotalUploadLimit()) {
            uploader.setState(2);
        }
        this._callback.addUpload(uploader);
    }

    private void insertIntoMap(String host) {
        int numUploads = 1;
        if (_uploadsInProgress.containsKey((Object)host)) {
            Integer myInteger = (Integer)_uploadsInProgress.get((Object)host);
            numUploads += myInteger.intValue();
        }
        _uploadsInProgress.put((Object)host, (Object)new Integer(numUploads));
    }

    private void removeFromMap(String host) {
        if (_uploadsInProgress.containsKey((Object)host)) {
            Integer myInteger = (Integer)_uploadsInProgress.get((Object)host);
            int numUploads = myInteger;
            if (numUploads == 1) {
                _uploadsInProgress.remove((Object)host);
            } else {
                _uploadsInProgress.put((Object)host, (Object)new Integer(--numUploads));
            }
        }
    }

    private boolean testPerHostLimit(String host) {
        int max;
        Integer value;
        int current;
        return !_uploadsInProgress.containsKey((Object)host) || (current = (value = (Integer)_uploadsInProgress.get((Object)host)).intValue()) <= (max = SettingsManager.instance().getUploadsPerPerson());
    }

    private boolean testTotalUploadLimit() {
        int max = SettingsManager.instance().getMaxUploads();
        int current = this.uploadsInProgress();
        return current < max;
    }

    private void insertFailedPush(String host, int index) {
        this._failedPushes.add((Object)new PushedFile(host, index));
    }

    private boolean testFailedPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._failedPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            return false;
        }
        return true;
    }

    private void insertAttemptedPush(String host, int index) {
        this._attemptingPushes.add((Object)new PushedFile(host, index));
    }

    private boolean testAttemptedPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._attemptingPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            return false;
        }
        return true;
    }

    private void removeAttemptedPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._attemptingPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            iter.remove();
        }
    }

    private void clearFailedPushes() {
        Date time = new Date();
        time.setTime(time.getTime() - 300000L);
        Iterator iter = this._failedPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pf = (PushedFile)iter.next();
            if (!pf.before(time)) continue;
            iter.remove();
        }
    }

    public int calculateBandwidth() {
        float totalBandwith = this.getTotalBandwith();
        float burstSize = totalBandwith / (float)this.uploadsInProgress();
        return (int)burstSize;
    }

    private float getTotalBandwith() {
        SettingsManager manager = SettingsManager.instance();
        float connectionSpeed = (float)manager.getConnectionSpeed() / 8.0f;
        float speed = manager.getUploadSpeed();
        float totalBandwith = connectionSpeed * (speed / 100.0f);
        return totalBandwith;
    }

    public String getThisHost() {
        byte[] address = this._acceptor.getAddress();
        String host = Message.ip2string(address);
        return host;
    }

    public int getThisPort() {
        return this._acceptor.getPort();
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long milliseconds, long bytes) {
        if (bytes < 200000L) {
            return;
        }
        int bandwidth = 8 * (int)((float)bytes / (float)milliseconds);
        this.speeds.add(new Integer(bandwidth));
        if (this.speeds.size() >= 5) {
            int max = 0;
            int i = 0;
            while (i < this.speeds.size()) {
                max = Math.max(max, (Integer)this.speeds.get(i));
                ++i;
            }
            this.highestSpeed = max;
        }
    }

    private GETLine parseGET(Socket socket) throws IOException {
        try {
            socket.setSoTimeout(SettingsManager.instance().getTimeout());
            InputStream istream = socket.getInputStream();
            ByteReader br = new ByteReader(istream);
            String str = br.readLine();
            if (str == null) {
                throw new IOException();
            }
            int g = str.indexOf("/get/");
            int d = str.indexOf("/", g + 5);
            String str_index = str.substring(g + 5, d);
            int index = Integer.parseInt(str_index);
            int f = str.indexOf(" HTTP/", d);
            String file = str.substring(d + 1, f);
            return new GETLine(index, file);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    private class PushedFile {
        private String _host;
        private int _index;
        private Date _time;

        public PushedFile(String host, int index) {
            this._host = host;
            this._index = index;
            this._time = new Date();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PushedFile)) {
                return false;
            }
            PushedFile pf = (PushedFile)o;
            return this._index == pf._index && this._host.equals(pf._host);
        }

        public boolean before(Date time) {
            return this._time.before(time);
        }
    }

    private class UploadRunner
    implements Runnable {
        private Uploader _up;
        private String _host;
        private int _index;

        public UploadRunner(Uploader up, String host, int index) {
            this._up = up;
            this._host = host;
            this._index = index;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long startTime = -1L;
            try {
                try {
                    UploadManager uploadManager;
                    this._up.connect();
                    try {
                        UploadManager uploadManager2 = UploadManager.this;
                        synchronized (uploadManager2) {
                            UploadManager.this._activeUploads++;
                        }
                        startTime = System.currentTimeMillis();
                        this._up.start();
                        if (this._up.getState() == 4) {
                            UploadManager.this._hadSuccesfulUpload = true;
                        }
                        Object var6_4 = null;
                        uploadManager = UploadManager.this;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        UploadManager uploadManager2 = UploadManager.this;
                        synchronized (uploadManager2) {
                            UploadManager.this._activeUploads--;
                            throw throwable;
                        }
                    }
                    synchronized (uploadManager) {
                        UploadManager.this._activeUploads--;
                    }
                    Object var11_9 = null;
                }
                catch (IOException e) {
                    UploadManager uploadManager = UploadManager.this;
                    synchronized (uploadManager) {
                        UploadManager.this.insertFailedPush(this._host, this._index);
                    }
                    Object var11_10 = null;
                    long finishTime = System.currentTimeMillis();
                    UploadManager uploadManager3 = UploadManager.this;
                    synchronized (uploadManager3) {
                        if (startTime > 0L) {
                            UploadManager.this.reportUploadSpeed(finishTime - startTime, this._up.amountUploaded());
                        }
                        UploadManager.this.removeFromMap(this._host);
                        UploadManager.this.removeAttemptedPush(this._host, this._index);
                        UploadManager.this._callback.removeUpload(this._up);
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                long finishTime = System.currentTimeMillis();
                UploadManager uploadManager = UploadManager.this;
                synchronized (uploadManager) {
                    if (startTime > 0L) {
                        UploadManager.this.reportUploadSpeed(finishTime - startTime, this._up.amountUploaded());
                    }
                    UploadManager.this.removeFromMap(this._host);
                    UploadManager.this.removeAttemptedPush(this._host, this._index);
                    UploadManager.this._callback.removeUpload(this._up);
                    throw throwable;
                }
            }
            long finishTime = System.currentTimeMillis();
            UploadManager uploadManager = UploadManager.this;
            synchronized (uploadManager) {
                if (startTime > 0L) {
                    UploadManager.this.reportUploadSpeed(finishTime - startTime, this._up.amountUploaded());
                }
                UploadManager.this.removeFromMap(this._host);
                UploadManager.this.removeAttemptedPush(this._host, this._index);
                UploadManager.this._callback.removeUpload(this._up);
                return;
            }
        }
    }

    private class GETLine {
        public int _index;
        public String _file;

        public GETLine(int index, String file) {
            this._index = index;
            this._file = file;
        }
    }
}

