/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.util.StringComparator;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.net.Socket;

public class ChatManager {
    private static ChatManager _chatManager = new ChatManager();
    private List _chatsInProgress = Collections.synchronizedList((List)new LinkedList());
    private List _blockedHosts = Collections.synchronizedList((List)new LinkedList());
    private ActivityCallback _activityCallback;

    public static ChatManager instance() {
        return _chatManager;
    }

    public void setActivityCallback(ActivityCallback callback) {
        this._activityCallback = callback;
    }

    public void accept(Socket socket) {
        boolean allowChats = SettingsManager.instance().getChatEnabled();
        if (!allowChats) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        String host = socket.getInetAddress().getHostAddress();
        SettingsManager sm = SettingsManager.instance();
        Object[] bannedIPs = sm.getBannedIps();
        List bannedList = Arrays.asList((Object[])bannedIPs);
        if (bannedList.contains((Object)host)) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            InstantMessenger im = new InstantMessenger(socket, this, this._activityCallback);
            this._chatsInProgress.add((Object)im);
            this._activityCallback.acceptChat(im);
            im.start();
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
    }

    public Chatter request(String host, int port) {
        InstantMessenger im = null;
        try {
            im = new InstantMessenger(host, port, this, this._activityCallback);
            this._chatsInProgress.add((Object)im);
            im.start();
        }
        catch (IOException e) {
            // empty catch block
        }
        return im;
    }

    public void removeChat(InstantMessenger chat) {
        this._chatsInProgress.remove((Object)chat);
    }

    public void blockHost(String host) {
        SettingsManager sm = SettingsManager.instance();
        Object[] bannedIPs = sm.getBannedIps();
        Arrays.sort((Object[])bannedIPs);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (Arrays.binarySearch((Object[])bannedIPs, (Object)host, (Comparator)new StringComparator()) < 0) {
                String[] more_banned = new String[bannedIPs.length + 1];
                System.arraycopy(bannedIPs, 0, more_banned, 0, bannedIPs.length);
                more_banned[bannedIPs.length] = host;
                sm.setBannedIps(more_banned);
            }
        }
    }

    public void unblockHost(String host) {
        SettingsManager sm = SettingsManager.instance();
        Object[] bannedIPs = sm.getBannedIps();
        List bannedList = Arrays.asList((Object[])bannedIPs);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (bannedList.remove((Object)host)) {
                sm.setBannedIps((String[])bannedList.toArray());
            }
        }
    }

    private ChatManager() {
    }
}

