/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.FileCantBeMovedException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.FileTooLargeException;
import com.limegroup.gnutella.downloader.InvalidPathException;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.ProblemReadingHeaderException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SocketOpener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPDownloader {
    private int _index;
    private String _filename;
    private byte[] _guid;
    private int _amountRead;
    private int _fileSize;
    private int _initialReadingPoint;
    private ByteReader _byteReader;
    private FileOutputStream _fos;
    private Socket _socket;
    private File _incompleteFile;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;

    public HTTPDownloader(Socket socket, RemoteFileDesc rfd, File incompleteFile) throws IOException {
        this.initializeFile(rfd, incompleteFile);
        this._socket = socket;
        this.connect();
    }

    public HTTPDownloader(RemoteFileDesc rfd, int timeout, File incompleteFile) throws IOException {
        this.initializeFile(rfd, incompleteFile);
        try {
            this._socket = new SocketOpener(rfd.getHost(), rfd.getPort()).connect(timeout);
        }
        catch (IOException e) {
            throw new CantConnectException();
        }
        this.connect();
    }

    private void initializeFile(RemoteFileDesc rfd, File incompleteFile) {
        this._incompleteFile = incompleteFile;
        this._filename = rfd.getFileName();
        this._index = rfd.getIndex();
        this._guid = rfd.getClientGUID();
        this._fileSize = rfd.getSize();
        this._port = rfd.getPort();
        this._host = rfd.getHost();
        this._chatEnabled = rfd.chatEnabled();
        this._amountRead = 0;
        this._initialReadingPoint = 0;
        if (this._incompleteFile.exists()) {
            this._amountRead = this._initialReadingPoint = (int)incompleteFile.length();
        }
    }

    private void connect() throws IOException {
        InputStream istream = null;
        try {
            istream = this._socket.getInputStream();
        }
        catch (Exception e) {
            throw new IOException();
        }
        this._byteReader = new ByteReader(istream);
        OutputStream os = this._socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter out = new BufferedWriter(osw);
        String startRange = String.valueOf(this._initialReadingPoint);
        out.write("GET /get/" + this._index + "/" + this._filename + " HTTP/1.0\r\n");
        out.write("User-Agent: " + CommonUtils.getVendor() + "\r\n");
        out.write("Range: bytes=" + startRange + "-\r\n");
        SettingsManager sm = SettingsManager.instance();
        if (sm.getChatEnabled()) {
            String host;
            int port;
            if (sm.getForceIPAddress()) {
                port = sm.getForcedPort();
                host = sm.getForcedIPAddressString();
            } else {
                port = sm.getPort();
                host = this._socket.getLocalAddress().getHostAddress();
            }
            out.write("Chat: " + host + ":" + port + "\r\n");
        }
        out.write("\r\n");
        out.flush();
    }

    public void start() throws IOException {
        this.readHeader();
        this.doDownload();
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._fos != null) {
                this._fos.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getInitialRead() {
        return this._initialReadingPoint;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    private void readHeader() throws IOException {
        int code;
        String str = " ";
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        str = this._byteReader.readLine();
        if (str == null || str.equals("")) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException();
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            code = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException();
        }
        if (code < 200 || code > 300) {
            if (code == 404) {
                throw new FileNotFoundException();
            }
            if (code == 410) {
                throw new NotSharingException();
            }
            if (code == 503) {
                throw new TryAgainLaterException();
            }
            throw new IOException();
        }
        do {
            int numBeforeSlash;
            int numBeforeDash;
            int numAfterSlash;
            String beforeSlash;
            String beforeDash;
            String afterSlash;
            if (str.toUpperCase().indexOf("CONTENT-LENGTH:") != -1) {
                int tempSize;
                String sub;
                try {
                    sub = str.substring(15);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ProblemReadingHeaderException();
                }
                sub = sub.trim();
                try {
                    tempSize = Integer.parseInt(sub);
                }
                catch (NumberFormatException e) {
                    throw new ProblemReadingHeaderException();
                }
                this._fileSize = tempSize;
            }
            if (str.toUpperCase().indexOf("CONTENT-RANGE:") == -1) continue;
            try {
                str = str.substring(21);
                int dash = str.indexOf(45);
                int slash = str.indexOf(47);
                afterSlash = str.substring(slash + 1);
                afterSlash = afterSlash.trim();
                beforeDash = str.substring(0, dash);
                beforeDash = beforeDash.trim();
                beforeSlash = str.substring(dash + 1, slash);
                beforeSlash = beforeSlash.trim();
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProblemReadingHeaderException();
            }
            try {
                numAfterSlash = Integer.parseInt(afterSlash);
                numBeforeDash = Integer.parseInt(beforeDash);
                numBeforeSlash = Integer.parseInt(beforeSlash);
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException();
            }
            if (numBeforeSlash == numAfterSlash) {
                --numBeforeSlash;
            }
            this._initialReadingPoint = --numBeforeDash;
            this._fileSize = numAfterSlash;
        } while ((str = this._byteReader.readLine()) != null && !str.equals(""));
    }

    private void doDownload() throws IOException {
        SettingsManager settings = SettingsManager.instance();
        File download_dir = settings.getSaveDirectory();
        File complete_file = new File(download_dir, this._filename);
        String shared_path = download_dir.getCanonicalPath();
        File parent_of_shared = new File(complete_file.getParent());
        String path_to_parent = parent_of_shared.getCanonicalPath();
        if (!path_to_parent.equals(shared_path)) {
            throw new InvalidPathException();
        }
        String path_to_incomplete = this._incompleteFile.getCanonicalPath();
        boolean append = false;
        if (this._initialReadingPoint > 0) {
            append = true;
        }
        this._fos = new FileOutputStream(path_to_incomplete, append);
        int c = -1;
        byte[] buf = new byte[1024];
        while (this._amountRead != this._fileSize) {
            if (this._amountRead > this._fileSize) {
                throw new FileTooLargeException();
            }
            c = this._byteReader.read(buf);
            if (c == -1) break;
            this._fos.write(buf, 0, c);
            this._amountRead += c;
        }
        this._byteReader.close();
        this._fos.close();
        if (this._amountRead == this._fileSize) {
            complete_file.delete();
            if (!this._incompleteFile.renameTo(complete_file) && !CommonUtils.copy(this._incompleteFile, complete_file)) {
                throw new FileCantBeMovedException();
            }
        } else {
            throw new FileIncompleteException();
        }
        FileManager.instance().addFileIfShared(complete_file);
    }
}

