/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.FileCantBeMovedException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.PushRequestedFile;
import com.limegroup.gnutella.downloader.RFDPushPair;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Date;

public class ManagedDownloader
implements Downloader,
Serializable {
    private DownloadManager manager;
    private IncompleteFileManager incompleteFileManager;
    private RemoteFileDesc[] allFiles;
    private static final int TRIES = 300;
    private static final int RESUME_TRIES = 0;
    private static final int PUSH_TRIES = 2;
    private static final int PARALLEL_PUSH = 6;
    private static final int CONNECT_TIME = 8000;
    private final int PUSH_INVALIDATE_TIME = 300;
    private List files;
    private List pushFiles;
    private Thread dloaderThread;
    private HTTPDownloader dloader;
    private boolean stopped;
    private List pushQueue;
    private List requested;
    private int state;
    private long stateTime;
    private String lastAddress;
    private int tries;

    private long calculateWaitTime() {
        return 60000L;
    }

    public ManagedDownloader(DownloadManager manager, RemoteFileDesc[] files) {
        this.allFiles = files;
        this.incompleteFileManager = new IncompleteFileManager();
        this.initialize(manager);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.allFiles);
        stream.writeObject(this.incompleteFileManager);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])stream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
    }

    public void initialize(DownloadManager manager) {
        this.manager = manager;
        Arrays.sort((Object[])this.allFiles, (Comparator)new RemoteFileDesc.RemoteFileDescComparator());
        this.files = new LinkedList();
        this.pushFiles = new LinkedList();
        int i = this.allFiles.length - 1;
        while (i >= 0) {
            RemoteFileDesc rfd = this.allFiles[i];
            if (ManagedDownloader.isPrivate(rfd)) {
                this.pushFiles.add((Object)new RFDPushPair(rfd));
            } else {
                this.files.add((Object)rfd);
            }
            --i;
        }
        this.dloader = null;
        this.stopped = false;
        this.pushQueue = new LinkedList();
        this.requested = new LinkedList();
        this.setState(0);
        this.lastAddress = null;
        this.tries = 0;
        this.dloaderThread = new Thread(new ManagedDownloadRunner());
        this.dloaderThread.setDaemon(true);
        this.dloaderThread.start();
    }

    public boolean conflicts(RemoteFileDesc other) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            File otherFile = this.incompleteFileManager.getFile(other);
            Iterator iter = this.files.iterator();
            while (iter.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                File thisFile = this.incompleteFileManager.getFile(rfd);
                if (!thisFile.equals(otherFile)) continue;
                boolean bl = true;
                return bl;
            }
            Iterator iter2 = this.pushFiles.iterator();
            while (iter2.hasNext()) {
                RFDPushPair pair = (RFDPushPair)iter2.next();
                File thisFile = this.incompleteFileManager.getFile(pair.rfd);
                if (!thisFile.equals(otherFile)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) throws IOException {
        RemoteFileDesc rfd = null;
        PushRequestedFile prf = new PushRequestedFile(clientGUID, file, index);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.purgeOldPushRequests();
            if (!this.requested.contains((Object)prf)) {
                boolean bl = false;
                return bl;
            }
            Iterator iter = this.pushFiles.iterator();
            while (iter.hasNext()) {
                rfd = ((RFDPushPair)iter.next()).rfd;
                if (rfd.getIndex() == index && rfd.getFileName().equals(file) && new GUID(rfd.getClientGUID()).equals(new GUID(clientGUID))) break;
            }
            Assert.that(rfd != null, "No match for supposedly requested file");
        }
        HTTPDownloader downloader = new HTTPDownloader(socket, rfd, this.incompleteFileManager.getFile(rfd));
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            if (this.stopped) {
                downloader.stop();
                boolean bl = false;
                return bl;
            }
            this.pushQueue.add((Object)downloader);
            this.notify();
        }
        return true;
    }

    public synchronized void stop() {
        this.stopped = true;
        if (this.dloader != null) {
            this.dloader.stop();
        }
        if (this.dloaderThread != null) {
            this.dloaderThread.interrupt();
        }
    }

    public synchronized boolean resume() throws AlreadyDownloadingException {
        if (this.state != 3 && this.state != 6) {
            return false;
        }
        String conflict = this.manager.conflicts(this.allFiles, this);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        if (this.stopped) {
            this.initialize(this.manager);
        } else if (this.dloaderThread != null) {
            this.dloaderThread.interrupt();
        }
        return true;
    }

    public synchronized void launch() {
        if (this.dloader == null) {
            return;
        }
        Thread worker = new Thread(){

            public void run() {
                String name = ManagedDownloader.this.dloader.getFileName();
                File file = null;
                if (ManagedDownloader.this.dloader.getAmountRead() < ManagedDownloader.this.dloader.getFileSize()) {
                    File incomplete = ManagedDownloader.this.incompleteFileManager.getFile(name, ManagedDownloader.this.dloader.getFileSize());
                    if (!CommonUtils.copy(incomplete, file = new File(incomplete.getParent(), "Preview-" + incomplete.getName()))) {
                        return;
                    }
                } else {
                    File saveDir = null;
                    try {
                        saveDir = SettingsManager.instance().getSaveDirectory();
                    }
                    catch (FileNotFoundException fnfe) {
                        return;
                    }
                    file = new File(saveDir, name);
                }
                try {
                    Launcher.launchFile(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        worker.setDaemon(true);
        worker.setName("Launcher thread");
        worker.start();
    }

    private static boolean isPrivate(RemoteFileDesc rfd) {
        String host = rfd.getHost();
        int port = rfd.getPort();
        return new Endpoint(host, port).isPrivateAddress();
    }

    private void purgeOldPushRequests() {
        Date time = new Date();
        time.setTime(time.getTime() - 300000L);
        Iterator iter = this.requested.iterator();
        while (iter.hasNext()) {
            PushRequestedFile prf = (PushRequestedFile)iter.next();
            if (!prf.before(time)) continue;
            iter.remove();
        }
    }

    private void setState(int newState, String lastAddress) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            if (lastAddress != null) {
                this.lastAddress = lastAddress;
            }
            this.stateTime = new Date().getTime();
        }
    }

    private void setState(int newState) {
        this.setState(newState, this.lastAddress);
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        long now = new Date().getTime();
        switch (this.state) {
            case 1: {
                return this.timeDiff(now, 8000L);
            }
            case 3: {
                return this.timeDiff(now, this.calculateWaitTime());
            }
        }
        return Integer.MAX_VALUE;
    }

    private int timeDiff(long nowTime, long stateLength) {
        long elapsed = nowTime - this.stateTime;
        long remaining = stateLength - elapsed;
        return (int)Math.max(remaining, 0L) / 1000;
    }

    public synchronized boolean chatEnabled() {
        if (this.dloader == null) {
            return false;
        }
        return this.dloader.chatEnabled();
    }

    public synchronized String getFileName() {
        if (this.dloader != null) {
            return this.dloader.getFileName();
        }
        if (!this.files.isEmpty()) {
            return ((RemoteFileDesc)this.files.get(0)).getFileName();
        }
        if (!this.pushFiles.isEmpty()) {
            return ((RFDPushPair)this.pushFiles.get((int)0)).rfd.getFileName();
        }
        return null;
    }

    public synchronized int getContentLength() {
        if (this.dloader != null) {
            return this.dloader.getFileSize();
        }
        if (!this.files.isEmpty()) {
            return ((RemoteFileDesc)this.files.get(0)).getSize();
        }
        if (!this.pushFiles.isEmpty()) {
            return ((RFDPushPair)this.pushFiles.get((int)0)).rfd.getSize();
        }
        return 0;
    }

    public synchronized int getAmountRead() {
        if (this.dloader != null) {
            return this.dloader.getAmountRead();
        }
        return 0;
    }

    public synchronized String getHost() {
        return this.lastAddress;
    }

    public synchronized int getPort() {
        if (this.dloader != null) {
            return this.dloader.getPort();
        }
        return 0;
    }

    public synchronized int getPushesWaiting() {
        return this.pushFiles.size();
    }

    public synchronized int getRetriesWaiting() {
        return this.files.size();
    }

    static /* synthetic */ int access$402(ManagedDownloader x0, int x1) {
        x0.tries = x1;
        return x0.tries;
    }

    static /* synthetic */ boolean access$302(ManagedDownloader x0, boolean x1) {
        x0.stopped = x1;
        return x0.stopped;
    }

    private class ManagedDownloadRunner
    implements Runnable {
        private ManagedDownloadRunner() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block23: {
                block21: {
                    try {
                        i = 0;
                        while (i < 300 && !ManagedDownloader.access$300(ManagedDownloader.this)) {
                            block22: {
                                var2_2 = ManagedDownloader.this;
                                synchronized (var2_2) {
                                    ManagedDownloader.access$402(ManagedDownloader.this, i);
                                }
                                try {
                                    success = this.tryAllDownloads();
                                    if (success == 1) {
                                        ManagedDownloader.access$500(ManagedDownloader.this).remove(ManagedDownloader.this, true);
                                        var5_5 = null;
                                        var6_8 = ManagedDownloader.this;
                                        break block21;
                                    }
                                    if (success == -1) {
                                    }
                                    break block22;
                                }
                                catch (InterruptedException e) {
                                    if (!ManagedDownloader.access$300(ManagedDownloader.this)) break block22;
                                }
                                break;
                            }
                            ++i;
                        }
                        if (ManagedDownloader.access$300(ManagedDownloader.this)) {
                            ManagedDownloader.access$600(ManagedDownloader.this, 5);
                            ManagedDownloader.access$500(ManagedDownloader.this).remove(ManagedDownloader.this, false);
                            break block23;
                        } else {
                            ManagedDownloader.access$600(ManagedDownloader.this, 6);
                            ManagedDownloader.access$500(ManagedDownloader.this).remove(ManagedDownloader.this, false);
                        }
                        break block23;
                    }
                    catch (Throwable var4_14) {
                        var5_7 = null;
                        var6_10 = ManagedDownloader.this;
                        synchronized (var6_10) {
                            ManagedDownloader.access$302(ManagedDownloader.this, true);
                            iter = ManagedDownloader.access$700(ManagedDownloader.this).iterator();
                            ** break block24
                        }
                    }
                }
                synchronized (var6_8) {
                    ManagedDownloader.access$302(ManagedDownloader.this, true);
                    iter = ManagedDownloader.access$700(ManagedDownloader.this).iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            if (ManagedDownloader.access$100(ManagedDownloader.this) == null) return;
                            ManagedDownloader.access$100(ManagedDownloader.this).stop();
                            return;
                        }
                        ((HTTPDownloader)iter.next()).stop();
                    }
                }
            }
            var5_6 = null;
            var6_9 = ManagedDownloader.this;
            synchronized (var6_9) {
                ManagedDownloader.access$302(ManagedDownloader.this, true);
                iter = ManagedDownloader.access$700(ManagedDownloader.this).iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        if (ManagedDownloader.access$100(ManagedDownloader.this) == null) return;
                        ManagedDownloader.access$100(ManagedDownloader.this).stop();
                        return;
                    }
                    ((HTTPDownloader)iter.next()).stop();
                }
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    if (!iter.hasNext()) {
                        if (ManagedDownloader.access$100(ManagedDownloader.this) == null) throw var4_14;
                        ManagedDownloader.access$100(ManagedDownloader.this).stop();
                        throw var4_14;
                    }
                    ((HTTPDownloader)iter.next()).stop();
                }
            }
        }

        private int tryAllDownloads() throws InterruptedException {
            if (ManagedDownloader.this.files.size() == 0 && ManagedDownloader.this.pushFiles.size() == 0) {
                return -1;
            }
            boolean success = this.tryNormalDownloads();
            if (success) {
                return 1;
            }
            if (ManagedDownloader.this.files.size() == 0 && ManagedDownloader.this.pushFiles.size() == 0) {
                return -1;
            }
            this.sendPushes();
            success = this.waitForPushDownloads();
            if (success) {
                return 1;
            }
            ManagedDownloader managedDownloader = ManagedDownloader.this;
            synchronized (managedDownloader) {
                Iterator iter = ManagedDownloader.this.pushFiles.iterator();
                while (iter.hasNext()) {
                    RFDPushPair pair = (RFDPushPair)iter.next();
                    ++pair.pushAttempts;
                    if (pair.pushAttempts < 2) continue;
                    iter.remove();
                }
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean tryNormalDownloads() throws InterruptedException {
            boolean bl;
            try {
                block29: {
                    void e2;
                    ManagedDownloader managedDownloader;
                    ManagedDownloader.this.setState(0);
                    ManagedDownloader.this.manager.waitForSlot(ManagedDownloader.this);
                    LinkedList filesLeft = new LinkedList((Collection)ManagedDownloader.this.files);
                    while (true) {
                        Object var11_12;
                        if (filesLeft.isEmpty()) break block29;
                        RemoteFileDesc rfd = this.removeBest((List)filesLeft);
                        try {
                            try {
                                this.downloadWithResume(rfd);
                                boolean bl2 = true;
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                break;
                            }
                            catch (CantConnectException e2) {
                                ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                                synchronized (managedDownloader2) {
                                    ManagedDownloader.this.files.remove((Object)rfd);
                                    ManagedDownloader.this.pushFiles.add((Object)new RFDPushPair(rfd));
                                }
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                synchronized (managedDownloader) {
                                    if (ManagedDownloader.this.stopped) {
                                        throw new InterruptedException();
                                    }
                                }
                            }
                            catch (TryAgainLaterException e3) {
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                synchronized (managedDownloader) {
                                    if (ManagedDownloader.this.stopped) {
                                        throw new InterruptedException();
                                    }
                                }
                            }
                            catch (FileIncompleteException e4) {
                                filesLeft.add((Object)rfd);
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                synchronized (managedDownloader) {
                                    if (ManagedDownloader.this.stopped) {
                                        throw new InterruptedException();
                                    }
                                }
                            }
                            catch (FileCantBeMovedException e5) {
                                ManagedDownloader.this.setState(7);
                                boolean bl3 = true;
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                synchronized (managedDownloader) {
                                    if (ManagedDownloader.this.stopped) {
                                        throw new InterruptedException();
                                    }
                                }
                                Object var15_15 = null;
                                ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                                return bl3;
                            }
                            catch (IOException e6) {
                                ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                                synchronized (managedDownloader3) {
                                    ManagedDownloader.this.files.remove((Object)rfd);
                                }
                                var11_12 = null;
                                managedDownloader = ManagedDownloader.this;
                                synchronized (managedDownloader) {
                                    if (ManagedDownloader.this.stopped) {
                                        throw new InterruptedException();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var11_12 = null;
                            managedDownloader = ManagedDownloader.this;
                            synchronized (managedDownloader) {
                                if (!ManagedDownloader.this.stopped) throw throwable;
                                throw new InterruptedException();
                            }
                        }
                    }
                    synchronized (managedDownloader) {
                        if (ManagedDownloader.this.stopped) {
                            throw new InterruptedException();
                        }
                    }
                    Object var15_14 = null;
                    ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                    return (boolean)e2;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                throw throwable;
            }
            Object var15_16 = null;
            ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
            return bl;
        }

        public RemoteFileDesc removeBest(List filesLeft) {
            RemoteFileDesc ret = null;
            long lowestTime = Integer.MAX_VALUE;
            Iterator iter = filesLeft.iterator();
            while (iter.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                File incompleteFile = ManagedDownloader.this.incompleteFileManager.getFile(rfd);
                long amountLeft = (long)rfd.getSize() - incompleteFile.length();
                long speed = rfd.getSpeed() / 8;
                long estimatedTime = 999999999L;
                if (speed != 0L) {
                    estimatedTime = amountLeft / speed;
                }
                if (estimatedTime >= lowestTime) continue;
                lowestTime = estimatedTime;
                ret = rfd;
            }
            Assert.that(ret != null, "Precondition to removeBest violated.");
            filesLeft.remove(ret);
            return ret;
        }

        private void downloadWithResume(RemoteFileDesc rfd) throws IOException, InterruptedException {
            ManagedDownloader.this.setState(1, rfd.getHost());
            HTTPDownloader dloader2 = new HTTPDownloader(rfd, 8000, ManagedDownloader.this.incompleteFileManager.getFile(rfd));
            ManagedDownloader managedDownloader = ManagedDownloader.this;
            synchronized (managedDownloader) {
                if (ManagedDownloader.this.stopped) {
                    dloader2.stop();
                    throw new InterruptedException();
                }
                ManagedDownloader.this.dloader = dloader2;
                ManagedDownloader.this.setState(2);
            }
            ManagedDownloader.this.dloader.start();
            ManagedDownloader.this.setState(4);
        }

        private void sendPushes() {
            ManagedDownloader managedDownloader = ManagedDownloader.this;
            synchronized (managedDownloader) {
                ManagedDownloader.this.purgeOldPushRequests();
            }
            Iterator iter = ManagedDownloader.this.pushFiles.iterator();
            int i = 0;
            while (i < 6 && iter.hasNext()) {
                RFDPushPair pair = (RFDPushPair)iter.next();
                RemoteFileDesc rfd = pair.rfd;
                PushRequestedFile prf = new PushRequestedFile(rfd.getClientGUID(), rfd.getFileName(), rfd.getIndex());
                ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                synchronized (managedDownloader2) {
                    ManagedDownloader.this.requested.add((Object)prf);
                }
                ManagedDownloader.this.manager.sendPush(rfd);
                ++i;
            }
        }

        private boolean waitForPushDownloads() throws InterruptedException {
            Date start = new Date();
            long totalWait = ManagedDownloader.this.calculateWaitTime();
            while (true) {
                Object var14_10;
                ManagedDownloader managedDownloader = ManagedDownloader.this;
                synchronized (managedDownloader) {
                    ManagedDownloader.this.setState(3);
                    while (ManagedDownloader.this.pushQueue.isEmpty()) {
                        Date now = new Date();
                        long elapsed = now.getTime() - start.getTime();
                        long waitTime = totalWait - elapsed;
                        if (waitTime <= 0L) {
                            boolean bl = false;
                            return bl;
                        }
                        ManagedDownloader.this.wait(waitTime);
                    }
                    ManagedDownloader.this.dloader = (HTTPDownloader)ManagedDownloader.this.pushQueue.remove(0);
                }
                try {
                    try {
                        ManagedDownloader.this.setState(0);
                        ManagedDownloader.this.manager.waitForSlot(ManagedDownloader.this);
                        ManagedDownloader.this.setState(2, ManagedDownloader.this.dloader.getInetAddress().getHostAddress());
                        ManagedDownloader.this.dloader.start();
                        ManagedDownloader.this.setState(4);
                        boolean now = true;
                        var14_10 = null;
                        ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                        return now;
                    }
                    catch (IOException e) {
                        ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                        synchronized (managedDownloader2) {
                            if (ManagedDownloader.this.stopped) {
                                throw new InterruptedException();
                            }
                        }
                        var14_10 = null;
                        ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                    }
                }
                catch (Throwable throwable) {
                    var14_10 = null;
                    ManagedDownloader.this.manager.yieldSlot(ManagedDownloader.this);
                    throw throwable;
                }
            }
        }
    }
}

