/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.SpamFilter;

public class BearShareFilter
extends SpamFilter {
    final int MAX_HIGHBITS = 20;

    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest)) {
            return true;
        }
        if (m.getHops() + m.getTTL() <= 2) {
            return true;
        }
        QueryRequest qReq = (QueryRequest)m;
        int rawQueryLength = qReq.getQueryLength();
        if (rawQueryLength < 20) {
            return true;
        }
        int highbits = 0;
        int i = 0;
        while (i < rawQueryLength) {
            byte currByte = qReq.getQueryByteAt(i);
            if ((currByte & 0x80) != 0) {
                ++highbits;
            }
            ++i;
        }
        return highbits < 20;
    }
}

