/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.sun.java.util.collections.Vector;

public class BlackListFilter
extends SpamFilter {
    private Vector badHosts = new Vector();
    private static BlackListFilter instance;

    protected BlackListFilter() {
        String[] allHosts = SettingsManager.instance().getBannedIps();
        int i = 0;
        while (i < allHosts.length) {
            this.badHosts.add((Object)allHosts[i]);
            ++i;
        }
    }

    public static BlackListFilter instance() {
        if (instance == null) {
            instance = new BlackListFilter();
        }
        return instance;
    }

    public void add(String badGuy) {
        if (this.badHosts.contains((Object)badGuy)) {
            return;
        }
        this.badHosts.add((Object)badGuy);
    }

    public void delete(String goodGuy) {
        String newAllHosts = "";
        if (!this.badHosts.contains((Object)goodGuy)) {
            return;
        }
        this.badHosts.removeElement((Object)goodGuy);
    }

    public void clear() {
        this.badHosts.clear();
    }

    public boolean check(String host) {
        return this.badHosts.contains((Object)host);
    }

    public boolean allow(Message m) {
        String ip;
        if (m instanceof PingReply) {
            PingReply pr = (PingReply)m;
            ip = pr.getIP();
        } else if (m instanceof QueryReply) {
            QueryReply qr = (QueryReply)m;
            ip = qr.getIP();
        } else {
            return true;
        }
        return !this.badHosts.contains((Object)ip);
    }
}

