/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.SpamFilter;

public class GreedyQueryFilter
extends SpamFilter {
    private static final int GREEDY_QUERY_MAX = 3;

    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest)) {
            return true;
        }
        String query = ((QueryRequest)m).getQuery();
        int n = query.length();
        if (n == 1) {
            return false;
        }
        if ((n == 5 || n == 6) && query.charAt(1) == '.' && Character.isLetter(query.charAt(0))) {
            return false;
        }
        if (this.isVeryGeneralSearch(query)) {
            byte hops = m.getHops();
            byte ttl = m.getTTL();
            if (hops >= 3) {
                return false;
            }
            if (hops + ttl > 3) {
                m.setTTL((byte)(3 - hops));
            }
        }
        return true;
    }

    private boolean isVeryGeneralSearch(String queryString) {
        int length = queryString.length();
        if (length == 3 && (queryString.charAt(1) == '.' || queryString.equalsIgnoreCase("mp3") || queryString.equalsIgnoreCase("mpg"))) {
            return true;
        }
        if (length == 5) {
            String fileFormat = queryString.substring(2, 5);
            if (queryString.charAt(1) == '.' && (fileFormat.equalsIgnoreCase("mp3") || fileFormat.equalsIgnoreCase("mpg"))) {
                return true;
            }
        }
        return false;
    }
}

