/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class CloseDialog {
    private final int MARGIN = 6;
    private final int CLOSE_DIALOG_WIDTH = 300;
    private final int CLOSE_DIALOG_HEIGHT = 150;
    private JDialog _dialog;
    private Frame _frame = GUIMediator.instance().getMainFrame();
    private SettingsManager _settings = SettingsManager.instance();
    private JCheckBox _checkBox;
    private JRadioButton _yesRadioButton;
    private JRadioButton _noRadioButton;

    public CloseDialog() {
        this._dialog = new JDialog(this._frame, "Exit", true);
        Container container = this._dialog.getContentPane();
        BoxLayout dialogLayout = new BoxLayout(container, 1);
        container.setLayout(dialogLayout);
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        Dimension dim = new Dimension(300, 150);
        mainPanel.setPreferredSize(dim);
        Border border = BorderFactory.createEmptyBorder(12, 6, 6, 6);
        mainPanel.setBorder(border);
        String msg = "Do you want to exit LimeWire?  This will abort any downloads and uploads.";
        int labelWidth = 288;
        MultiLineLabel label = new MultiLineLabel(msg, labelWidth);
        JPanel labelPanel = new JPanel();
        labelPanel.add(label);
        Dimension labelDim = new Dimension(labelWidth, 40);
        labelPanel.setPreferredSize(labelDim);
        labelPanel.setMaximumSize(labelDim);
        CheckBoxPanel checkBoxPanel = new CheckBoxPanel();
        String[] buttonLabelKeys = new String[]{"CLOSE_DIALOG_EXIT_BUTTON_LABEL", "CLOSE_DIALOG_CANCEL_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"CLOSE_DIALOG_EXIT_BUTTON_TIP", "CLOSE_DIALOG_CANCEL_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{new ExitListener(), new CancelListener()};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, toolTipKeys, buttonListeners, 0, 12);
        mainPanel.add(labelPanel);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(checkBoxPanel);
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(buttons);
        this._dialog.getContentPane().add(mainPanel);
        this._dialog.pack();
    }

    public void showDialog() {
        this._dialog.setLocationRelativeTo(this._frame);
        ((Component)this._dialog).setVisible(true);
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Component)CloseDialog.this._dialog).setVisible(false);
        }
    }

    private class ExitListener
    implements ActionListener {
        private ExitListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CloseDialog.this._settings.setShowCloseDialog(!CloseDialog.this._checkBox.isSelected());
            Initializer.instance().shutdown();
        }
    }

    private class CheckBoxPanel
    extends JPanel {
        private CheckBoxPanel() {
            BoxLayout layout = new BoxLayout(this, 0);
            this.setLayout(layout);
            JPanel checkBoxPanel = new JPanel();
            BoxLayout checkBoxLayout = new BoxLayout(checkBoxPanel, 1);
            checkBoxPanel.setLayout(checkBoxLayout);
            String checkBoxLabel = "Always exit without prompting me.";
            CloseDialog.this._checkBox = new JCheckBox(checkBoxLabel);
            checkBoxPanel.add(CloseDialog.this._checkBox);
            this.add(Box.createHorizontalGlue());
            this.add(checkBoxPanel);
            this.add(Box.createHorizontalGlue());
        }
    }
}

