/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GroupModel;
import com.limegroup.gnutella.gui.GroupNode;
import com.limegroup.gnutella.gui.JTreeTable;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.StatusLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CommunityView
extends PaddedPanel {
    private SettingsManager _settings;
    private JTreeTable _treeTable;
    private ImageIcon _groupIcon;
    private GUIMediator _mediator = GUIMediator.instance();
    private StatusLine _statusLine;

    public CommunityView() {
        this._settings = SettingsManager.instance();
        this._groupIcon = this._mediator.getImageResource("groups_medium.gif");
        this.lazyCommunityView();
    }

    public void lazyCommunityView() {
        this.createCommunityTree();
    }

    private void createCommunityTree() {
        Object[] openNodes = new Object[3];
        Object[] children = new Object[]{new GroupNode("Adult", "Adult content area", null), new GroupNode("Comedy", "Comedy content area", null), new GroupNode("Documents", "Text content area", null), new GroupNode("Programs", "Software content area", null), new GroupNode("Audio", "Audio content area", null), new GroupNode("Video", "Video content area", null), new GroupNode("Images", "Image content area", null)};
        GroupNode content = new GroupNode("Content", "Build Gnutella groups based on content", children);
        children = new Object[]{new GroupNode("North America", "North American connections", null), new GroupNode("South America", "South American connections", null), new GroupNode("Europe", "European connections", null), new GroupNode("Asia", "Asian connections", null), new GroupNode("Africa", "African connections", null), new GroupNode("Australia", "Australian connections", null)};
        GroupNode geo = new GroupNode("Region", "Build the Gnutella network based on region", children);
        openNodes[2] = geo;
        children = new Object[]{content, geo};
        GroupNode groups = new GroupNode("Groups", "Available groups", children);
        openNodes[1] = groups;
        children = new Object[]{groups};
        GroupNode root = new GroupNode("", "", children);
        openNodes[0] = root;
        this._treeTable = new JTreeTable(new GroupModel(root));
        this._treeTable.setLeafIcon(this._groupIcon);
        this._treeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this._treeTable.getColumnModel().getColumn(1).setPreferredWidth(260);
        this._treeTable.setAngledLines();
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CommunityView.this.doubleClickAction();
                }
            }
        };
        this._treeTable.addMouseListener(mouseListener);
        this._treeTable.expandPath(openNodes);
        openNodes[2] = content;
        this._treeTable.expandPath(openNodes);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JScrollPane scrollPane = new JScrollPane(this._treeTable);
        panel.setBackground(Color.white);
        scrollPane.getViewport().setBackground(Color.white);
        panel.add(scrollPane);
        Dimension d = new Dimension(10000, 10000);
        panel.setPreferredSize(d);
        this.add(panel);
        String[] buttonLabelKeys = new String[]{"COMMUNITY_CONNECT_BUTTON_LABEL", "COMMUNITY_LOGOUT_BUTTON_LABEL"};
        String[] buttonToolTipKeys = new String[]{"COMMUNITY_CONNECT_BUTTON_TIP", "COMMUNITY_LOGOUT_BUTTON_TIP"};
        ActionListener ConnectListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommunityView.this.connectToGroup();
            }
        };
        ActionListener LogoutListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommunityView.this.connectToGroup("Logout");
            }
        };
        ActionListener[] buttonListeners = new ActionListener[]{ConnectListener, LogoutListener};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonToolTipKeys, buttonListeners, 0, 14);
        this.add(buttons);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        this.add(p);
    }

    public void connectToGroup(String group) {
        if (group == null) {
            GUIMediator.instance().showError("ERROR_INVALID_GROUP");
            return;
        }
        if (group.equals("Logout")) {
            this.setStatus("Logging out ...");
        } else {
            this.setStatus("Requesting group members ...");
        }
        new DoGroupConnection(group);
    }

    public void connectToGroup() {
        this.doubleClickAction();
    }

    public void doubleClickAction() {
        int row = this._treeTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        GroupNode node = (GroupNode)this._treeTable.nodeForRow(row);
        if (node == null) {
            return;
        }
        GroupModel model = (GroupModel)this._treeTable.getTreeTableModel();
        if (!model.isLeaf(node)) {
            return;
        }
        String group = node.getGroup();
        this.connectToGroup(group);
    }

    private void setStatus(String status) {
        if (this._statusLine == null) {
            this._statusLine = this._mediator.getStatusLine();
        }
        this._statusLine.setStatus(status, true);
    }

    private void unlockStatus() {
        if (this._statusLine == null) {
            this._statusLine = this._mediator.getStatusLine();
        }
        this._statusLine.setStatus(null, false);
    }

    private void resetConnectionText() {
        ConnectionView connectionView = this._mediator.getConnectionView();
        SettingsManager settings = SettingsManager.instance();
        connectionView.setKeepAliveText(String.valueOf(settings.getKeepAlive()));
    }

    private class DoGroupConnection
    extends Thread {
        private String _group;

        public DoGroupConnection(String group) {
            this._group = group;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            int oldKeepAlive = Math.max(CommunityView.this._settings.getKeepAlive(), 1);
            CommunityView.this._mediator.getConnectionView().clearHostCatcher();
            CommunityView.this._mediator.getRouter().connectToGroup(this._group);
            if ("Logout".equals(this._group)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                CommunityView.this.resetConnectionText();
                try {
                    Thread.sleep(3500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                CommunityView.this.unlockStatus();
                return;
            }
            CommunityView.this.setStatus("Waiting for group members ...");
            int count = 0;
            int numHost = 0;
            int numConn = 0;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            CommunityView.this.resetConnectionText();
            while ((numHost = CommunityView.this._mediator.getRouter().getRealNumHosts()) < 1 && count < 100) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++count;
            }
            if (numHost > 0) {
                CommunityView.this.setStatus("Connecting to group members ...");
                count = 0;
                int confirmConnection = 0;
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {}
                while (((numConn = CommunityView.this._mediator.getRouter().getNumConnections()) < 1 || confirmConnection < 2) && count < 50) {
                    confirmConnection = numConn > 0 ? ++confirmConnection : 0;
                    if (confirmConnection < 2) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    ++count;
                }
            }
            if (numConn > 0) {
                CommunityView.this.setStatus("Connected");
            } else {
                CommunityView.this.setStatus("Failed to connect");
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            CommunityView.this.unlockStatus();
        }
    }
}

