/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.QuickConnectPanels;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.util.ArrayListUtil;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public class ConnectionView
extends JPanel {
    private static final int COLUMNS = 6;
    private static final int HOST_COL = 0;
    private static final int TYPE_COL = 1;
    private static final int MESSAGES_COL = 2;
    private static final int BANDWIDTH_COL = 3;
    private static final int DROP_COL = 4;
    private static final int HORIZON_COL = 5;
    private int rowNum;
    private JButton addButton;
    private JButton removeButton;
    private JTextField hostname;
    private JTextField port;
    private JTextField minConnections;
    private AbstractTableModel dataModel;
    private JTable tableView;
    private JScrollPane scrollpane;
    private JPanel tablepane;
    private JTabbedPane tabbedPane;
    private ConnectionList list;
    private boolean disableRemoteRemove = false;
    private SettingsManager settings;
    private boolean disableKeepAliveValidate = false;
    private KeepAliveDocumentListener keepAliveDocumentListener;
    private JButton options;
    private HostCatcherPanel hostCatcherPanel;
    private GUIMediator mediator = GUIMediator.instance();

    public ConnectionView() {
        this.setLayout(new BorderLayout());
        TitledPaddedPanel connectionPanel = new TitledPaddedPanel("Connected Hosts");
        this.settings = SettingsManager.instance();
        this.rowNum = 0;
        final String[] names = new String[]{"Host", "Status", "Messages (I/O)", "Bandwidth (I/O)", "Dropped (I/O)", "Hosts"};
        this.list = new ConnectionList();
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return names.length;
            }

            public int getRowCount() {
                return ConnectionView.this.list.size();
            }

            public Object getValueAt(int row, int col) {
                if (row < ConnectionView.this.list.size()) {
                    return ((ConnectionView)ConnectionView.this).list.get((int)row).displayed[col];
                }
                return "";
            }

            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public void setValueAt(Object aValue, int row, int column) {
                if (row >= ConnectionView.this.list.size()) {
                    return;
                }
                ((ConnectionView)ConnectionView.this).list.get((int)row).displayed[column] = aValue;
                this.fireTableCellUpdated(row, column);
            }
        };
        this.tableView = new JTable(this.dataModel);
        this.tableView.setShowGrid(false);
        this.scrollpane = new JScrollPane(this.tableView);
        this.scrollpane.setPreferredSize(new Dimension(440, 120));
        this.tablepane = new JPanel();
        this.tablepane.setLayout(new BorderLayout());
        this.tablepane.setBackground(Color.white);
        this.scrollpane.getViewport().setBackground(Color.white);
        this.tablepane.add((Component)this.scrollpane, "Center");
        this.tableView.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableView.getColumnModel().getColumn(1).setPreferredWidth(45);
        this.tableView.getColumnModel().getColumn(5).setPreferredWidth(15);
        connectionPanel.add(this.tablepane);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove the selected connections");
        this.addButton = new JButton("Add");
        this.addButton.setToolTipText("Create a new outgoing connection");
        this.hostname = new JTextField(20);
        this.port = new WholeNumberField(6346, 4);
        p.add(this.removeButton);
        p.add(this.addButton);
        p.add(this.hostname);
        p.add(this.port);
        connectionPanel.add(p);
        JPanel keepPanel = new JPanel();
        keepPanel.setLayout(new FlowLayout());
        JLabel minLabel = new JLabel("Keep approximately ");
        this.minConnections = new WholeNumberField(0, 2);
        JLabel minInLabel = new JLabel(" connections up.");
        keepPanel.add(minLabel);
        keepPanel.add(this.minConnections);
        keepPanel.add(minInLabel);
        keepPanel.add(Box.createHorizontalStrut(10));
        connectionPanel.add(keepPanel);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] sel = ConnectionView.this.tableView.getSelectedRows();
                ArrayList slist = ArrayListUtil.buildArray(sel);
                Collections.sort((List)slist, (Comparator)ArrayListUtil.integerComparator());
                int n = sel.length;
                int i = n - 1;
                while (i >= 0) {
                    int row = (Integer)slist.get(i);
                    if (row >= 0 && row < ConnectionView.this.list.size()) {
                        ManagedConnection c = ((ConnectionView)ConnectionView.this).list.get((int)row).connection;
                        ConnectionView.this.disableRemoteRemove = true;
                        ConnectionView.this.mediator.getRouter().removeConnection(c);
                        ConnectionView.this.disableRemoteRemove = false;
                        ConnectionView.this.list.removeRow(row);
                    }
                    --i;
                }
                ConnectionView.this.validate();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String hostnamestr = ConnectionView.this.hostname.getText();
                String portstr = ConnectionView.this.port.getText();
                int portnum = -1;
                try {
                    portnum = Integer.parseInt(portstr);
                }
                catch (Exception ee) {
                    portnum = 6346;
                }
                if (!hostnamestr.equals("")) {
                    ConnectionView.this.tryConnection(hostnamestr, portnum);
                }
            }
        });
        this.hostname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String hostnamestr = ConnectionView.this.hostname.getText();
                String portstr = ConnectionView.this.port.getText();
                int portnum = -1;
                try {
                    portnum = Integer.parseInt(portstr);
                }
                catch (Exception ee) {
                    portnum = 6346;
                }
                if (!hostnamestr.equals("")) {
                    ConnectionView.this.tryConnection(hostnamestr, portnum);
                }
            }
        });
        this.keepAliveDocumentListener = new KeepAliveDocumentListener();
        this.minConnections.getDocument().addDocumentListener(this.keepAliveDocumentListener);
        this.setKeepAliveText(Integer.toString(this.settings.getKeepAlive()));
        JPanel connSouthPanel = new JPanel();
        connSouthPanel.setLayout(new BorderLayout());
        JPanel connSouthPanelCenter = new JPanel();
        connSouthPanelCenter.setLayout(new GridLayout(1, 2));
        QuickConnectPanels.QCCheckPanel quickConnectCheckPanel = new QuickConnectPanels.QCCheckPanel();
        QuickConnectPanels.QCEditor quickConnectEditor = new QuickConnectPanels.QCEditor();
        int width = quickConnectEditor.getPreferredSize().width;
        quickConnectEditor.setPreferredSize(new Dimension(width, 20));
        this.hostCatcherPanel = new HostCatcherPanel();
        connSouthPanelCenter.add(quickConnectEditor);
        connSouthPanelCenter.add(this.hostCatcherPanel);
        connSouthPanel.add((Component)connSouthPanelCenter, "Center");
        connSouthPanel.add((Component)quickConnectCheckPanel, "South");
        this.add((Component)connectionPanel, "Center");
        this.add((Component)connSouthPanel, "South");
    }

    void initHosts() {
        this.hostCatcherPanel.initHosts();
    }

    public void processKeepAliveChange(JTextField source) {
        String val = source.getText();
        if (val == null || val.equals("") || this.disableKeepAliveValidate) {
            return;
        }
        int n = Integer.parseInt(val);
        if (source == this.minConnections) {
            try {
                this.settings.setKeepAlive(n, true);
                this.mediator.getRouter().setKeepAlive(n);
            }
            catch (BadConnectionSettingException e) {
                int reason = e.getReason();
                if (reason == 2) {
                    this.showMessage("ERROR_KEEP_ALIVE");
                }
                this.processKeepAliveSuggestion(source, e);
            }
        } else {
            Assert.that(false, "Unknown connection property");
        }
    }

    private void processKeepAliveSuggestion(JTextField source, BadConnectionSettingException e) {
        final int outgoing = e.getSuggestedOutgoing();
        int incoming = e.getSuggestedIncoming();
        this.settings.setKeepAlive(outgoing, false);
        this.settings.setMaxIncomingConnections(incoming, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionView.this.disableKeepAliveValidate = true;
                ConnectionView.this.minConnections.setText(String.valueOf(outgoing));
                ConnectionView.this.disableKeepAliveValidate = false;
            }
        });
        this.mediator.getRouter().setKeepAlive(outgoing);
    }

    public void setKeepAliveText(String val) {
        this.disableKeepAliveValidate = true;
        this.minConnections.setText(val);
        this.disableKeepAliveValidate = false;
    }

    public void validate() {
        this.dataModel.fireTableRowsUpdated(0, 10000);
        this.tablepane.validate();
        this.scrollpane.validate();
    }

    private void tryConnection(String hostname, int portnum) {
        this.mediator.getRouter().connectToHostAsynchronously(hostname, portnum);
    }

    public void clearConnections() {
        this.list.clear();
        this.setKeepAliveText("0");
    }

    public void addConnection(Connection c) {
        if (!(c instanceof ManagedConnection)) {
            return;
        }
        this.list.addRow((ManagedConnection)c);
        this.dataModel.fireTableRowsInserted(0, 0);
        this.validate();
        this.hostCatcherPanel.removeHost(c.getOrigHost(), c.getOrigPort());
    }

    public void renameConnection(Connection c) {
        this.list.renameConnection(c);
        this.validate();
    }

    public void updateConnection(Connection c) {
        this.list.updateConnection(c);
        this.validate();
    }

    public void removeConnection(Connection c) {
        if (this.disableRemoteRemove) {
            return;
        }
        this.list.removeConnection(c);
        this.validate();
    }

    public void addKnownHost(Endpoint e) {
        this.hostCatcherPanel.addKnownHost(e);
    }

    public void clearHostCatcher() {
        this.hostCatcherPanel.clearAll();
    }

    public void updateConnectionStats() {
        this.list.updateConnectionStats();
        this.validate();
    }

    private void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().showError(message);
            }
        });
    }

    private class HostCatcherPanel
    extends TitledPaddedPanel {
        private JList listBox;
        private JScrollPane scrollPane;
        private DefaultListModel model = new DefaultListModel();
        private JButton connectButton;
        private JButton removeButton;
        private JButton getMoreButton;
        private JButton clearButton;

        public HostCatcherPanel() {
            super("Discovered Hosts");
            this.setInnerLayout(new BorderLayout());
            this.listBox = new JList(this.model);
            this.listBox.setFont(new Font("Dialog", 0, 12));
            this.listBox.setPrototypeCellValue("123.123.123.123:9999");
            this.listBox.setFixedCellHeight(17);
            BoxPanel controlPanel = new BoxPanel(1);
            this.connectButton = new JButton("Connect");
            this.connectButton.setToolTipText("Connect to the selected hosts");
            this.removeButton = new JButton("Remove");
            this.removeButton.setToolTipText("Remove the selected hosts");
            this.getMoreButton = new JButton("Get More");
            this.getMoreButton.setToolTipText("Get more hosts to connect to");
            this.clearButton = new JButton("Clear");
            this.clearButton.setToolTipText("Clear the list of discovered hosts");
            controlPanel.add(this.connectButton);
            controlPanel.add(this.removeButton);
            controlPanel.add(this.getMoreButton);
            controlPanel.add(this.clearButton);
            this.scrollPane = new JScrollPane(this.listBox);
            this.scrollPane.setPreferredSize(new Dimension(160, 100));
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)controlPanel, "East");
            ActionListener connectListener = new ActionListener(this){
                private final /* synthetic */ HostCatcherPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    HostCatcherPanel.access$1500(this.this$1);
                }
            };
            this.connectButton.addActionListener(connectListener);
            ActionListener removeListener = new ActionListener(this){
                private final /* synthetic */ HostCatcherPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    HostCatcherPanel.access$1600(this.this$1);
                }
            };
            this.removeButton.addActionListener(removeListener);
            ActionListener getMoreListener = new ActionListener(this){
                private final /* synthetic */ HostCatcherPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    HostCatcherPanel.access$1700(this.this$1);
                }
            };
            this.getMoreButton.addActionListener(getMoreListener);
            ActionListener clearListener = new ActionListener(this){
                private final /* synthetic */ HostCatcherPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    HostCatcherPanel.access$1300(this.this$1);
                }
            };
            this.clearButton.addActionListener(clearListener);
        }

        private void connect() {
            int n = this.listBox.getSelectedIndices().length;
            int i = 0;
            while (i < n) {
                int idx = this.listBox.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                Endpoint e = this.getHostPort(idx);
                if (e == null) {
                    return;
                }
                ConnectionView.this.tryConnection(e.getHostname(), e.getPort());
                ++i;
            }
            this.remove();
        }

        private void remove() {
            int n = this.listBox.getSelectedIndices().length;
            int i = 0;
            while (i < n) {
                int idx = this.listBox.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                Endpoint e = this.getHostPort(idx);
                if (e == null) {
                    return;
                }
                this.model.remove(idx);
                this.scrollPane.validate();
                ConnectionView.this.mediator.getRouter().removeHost(e.getHostname(), e.getPort());
                ++i;
            }
        }

        private Endpoint getHostPort(int i) {
            String val = (String)this.listBox.getModel().getElementAt(i);
            if (val == null || val.equals("")) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(val, ":");
            String host = st.nextToken();
            int port = Integer.parseInt(st.nextToken());
            return new Endpoint(host, port);
        }

        private void getMore() {
            ConnectionView.this.mediator.getRouter().updateHorizon();
            this.scrollPane.validate();
        }

        private void clearAll() {
            this.model.removeAllElements();
            this.scrollPane.validate();
            ConnectionView.this.mediator.getRouter().clearHostCatcher();
        }

        private void addKnownHost(Endpoint e) {
            String hostport = this.getHP(e);
            if (!this.model.contains(hostport)) {
                this.model.addElement(hostport);
            }
        }

        private String getHP(Endpoint e) {
            return e.getHostname() + ":" + String.valueOf(e.getPort());
        }

        private void removeHost(String host, int port) {
            String hostport = host + ":" + String.valueOf(port);
            this.model.removeElement(hostport);
        }

        private void initHosts() {
            Iterator iterator = ConnectionView.this.mediator.getRouter().getHosts();
            while (iterator.hasNext()) {
                Endpoint e = (Endpoint)iterator.next();
                this.model.addElement(this.getHP(e));
            }
        }

        static /* synthetic */ void access$1500(HostCatcherPanel x0) {
            x0.connect();
        }

        static /* synthetic */ void access$1600(HostCatcherPanel x0) {
            x0.remove();
        }

        static /* synthetic */ void access$1700(HostCatcherPanel x0) {
            x0.getMore();
        }
    }

    private class ConnectionList {
        private ArrayList list = new ArrayList();
        private NumberFormat formatter = NumberFormat.getInstance();
        private final String CONNECTING_STRING = "Connecting...";

        public ConnectionList() {
            this.formatter.setMinimumFractionDigits(3);
            this.formatter.setMaximumFractionDigits(3);
        }

        public void clear() {
            this.list.clear();
            ConnectionView.this.tableView.clearSelection();
            ConnectionView.this.dataModel.fireTableRowsDeleted(0, this.size());
        }

        public int size() {
            return this.list.size();
        }

        public void removeRow(int row) {
            this.list.remove(row);
            ConnectionView.this.dataModel.fireTableRowsDeleted(row, row);
        }

        public int findRow(Connection c) {
            int row = -1;
            int size = this.list.size();
            int i = 0;
            while (i < size) {
                Row line = (Row)this.list.get(i);
                if (line.connection == c) {
                    row = i;
                    break;
                }
                ++i;
            }
            return row;
        }

        public void addRow(ManagedConnection c) {
            String hostport;
            Assert.that(this.findRow(c) < 0);
            if (c.isOutgoing()) {
                String hostname = c.getOrigHost();
                if (hostname.equals(SettingsManager.DEDICATED_LIMEWIRE_ROUTER)) {
                    hostname = "router.limewire.com";
                }
                hostport = hostname + ":" + String.valueOf(c.getOrigPort());
            } else {
                hostport = c.getOrigHost();
            }
            Object[] line = new Object[]{hostport, "Connecting...", "", "", "", ""};
            this.list.add(0, (Object)new Row(line, c));
        }

        public void updateConnection(Connection c) {
            int row = this.findRow(c);
            if (row == -1) {
                return;
            }
            Object[] line = ((Row)this.list.get((int)row)).displayed;
            line[1] = c.isOutgoing() ? "Outgoing" : "Incoming";
        }

        public void renameConnection(Connection c) {
            String ipport = c.isOutgoing() ? c.getInetAddress().getHostAddress() + ":" + c.getOrigPort() : c.getInetAddress().getHostAddress();
            int row = this.findRow(c);
            if (row == -1) {
                return;
            }
            Object[] line = ((Row)this.list.get((int)row)).displayed;
            if (!((String)line[0]).startsWith("router.limewire.com")) {
                line[0] = ipport;
            }
        }

        public void removeConnection(Connection c) {
            int row = this.findRow(c);
            if (row == -1) {
                return;
            }
            this.removeRow(row);
        }

        public Row get(int row) {
            if (row >= this.list.size() || row < 0) {
                return null;
            }
            return (Row)this.list.get(row);
        }

        public void updateConnectionStats() {
            int i = 0;
            while (i < this.list.size()) {
                Row row = (Row)this.list.get(i);
                Object[] line = row.displayed;
                ManagedConnection c = row.connection;
                if (!line[1].equals("Connecting...")) {
                    line[2] = c.getNumMessagesReceived() + " / " + c.getNumMessagesSent();
                    float msecs = 2000.0f;
                    float in = (float)c.getBytesReceived() / msecs;
                    float out = (float)c.getBytesSent() / msecs;
                    line[3] = this.formatter.format(in) + " / " + this.formatter.format(out) + " KB/s";
                    line[4] = (int)c.getPercentReceivedDropped() + "% / " + (int)c.getPercentSentDropped() + "%";
                    line[5] = String.valueOf(c.getNumHosts());
                }
                ++i;
            }
        }
    }

    private static class Row {
        Object[] displayed;
        ManagedConnection connection;

        Row(Object[] displayed, ManagedConnection connection) {
            this.displayed = displayed;
            this.connection = connection;
        }
    }

    private class KeepAliveDocumentListener
    implements DocumentListener {
        private KeepAliveDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ConnectionView.this.processKeepAliveChange(this.source(e));
        }

        public void removeUpdate(DocumentEvent e) {
            ConnectionView.this.processKeepAliveChange(this.source(e));
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private JTextField source(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc == ConnectionView.this.minConnections.getDocument()) {
                return ConnectionView.this.minConnections;
            }
            Assert.that(false, "Unknown connection property");
            return null;
        }
    }
}

