/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgressBarHolder;
import com.limegroup.gnutella.gui.ProgressBarRenderer;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class DownloadView
extends PaddedPanel {
    private JTable _table;
    private DownloadTableModel _dataModel;
    private DownloadList _dlist;
    private SettingsManager _settings = SettingsManager.instance();
    private int _totalDownloads = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ProgressBarHolder;

    DownloadView() {
        super("Downloads");
        this.setLayout(new BoxLayout(this, 1));
        this._dlist = new DownloadList();
        this._dataModel = new DownloadTableModel();
        this._table = new JTable(this._dataModel);
        int height = this._table.getRowHeight();
        this._table.setRowHeight(height + 1);
        this._table.setShowGrid(false);
        JTableHeader th = this._table.getTableHeader();
        th.addMouseListener(new ColumnSorter());
        JScrollPane scrollPane = new JScrollPane(this._table);
        JPanel tablePane = new JPanel();
        this._table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(15);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(120);
        this._table.getColumnModel().getColumn(3).setPreferredWidth(35);
        this._table.getColumnModel().getColumn(4).setPreferredWidth(15);
        ProgressBarRenderer pRend = new ProgressBarRenderer(this._table);
        this._table.setDefaultRenderer(class$com$limegroup$gnutella$gui$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$ProgressBarHolder = DownloadView.class$("com.limegroup.gnutella.gui.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$ProgressBarHolder, pRend);
        tablePane.setLayout(new BoxLayout(tablePane, 1));
        tablePane.setBackground(Color.white);
        scrollPane.getViewport().setBackground(Color.white);
        tablePane.add(scrollPane);
        this.add(tablePane);
        String[] buttonLabelKeys = new String[]{"DOWNLOAD_KILL_BUTTON_LABEL", "DOWNLOAD_RESUME_BUTTON_LABEL", "DOWNLOAD_CLEAR_BUTTON_LABEL", "DOWNLOAD_LAUNCH_BUTTON_LABEL"};
        String[] buttonTipKeys = new String[]{"DOWNLOAD_KILL_BUTTON_TIP", "DOWNLOAD_RESUME_BUTTON_TIP", "DOWNLOAD_CLEAR_BUTTON_TIP", "DOWNLOAD_LAUNCH_BUTTON_TIP"};
        ActionListener launchListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadView.this.launchFiles();
            }
        };
        ActionListener killListener = this.killListener();
        ActionListener resumeListener = this.resumeListener();
        ActionListener clearListener = this.clearListener();
        ActionListener chatListener = this.chatListener();
        ActionListener[] buttonListeners = new ActionListener[]{killListener, resumeListener, clearListener, launchListener};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonTipKeys, buttonListeners, 0, 14);
        this.add(buttons);
        JMenuItem killItem = new JMenuItem("Kill Download");
        JMenuItem resumeItem = new JMenuItem("Force Resume");
        JMenuItem launchItem = new JMenuItem("Launch File");
        JMenuItem chatItem = new JMenuItem("Chat with Host");
        killItem.addActionListener(killListener);
        resumeItem.addActionListener(resumeListener);
        launchItem.addActionListener(launchListener);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(killItem);
        popupMenu.add(resumeItem);
        popupMenu.add(launchItem);
        JMenuItem killItem2 = new JMenuItem("Kill Download");
        JMenuItem resumeItem2 = new JMenuItem("Force Resume");
        JMenuItem launchItem2 = new JMenuItem("Launch File");
        JMenuItem chatItem2 = new JMenuItem("Chat with Host");
        chatItem2.addActionListener(chatListener);
        killItem2.addActionListener(killListener);
        resumeItem2.addActionListener(resumeListener);
        launchItem2.addActionListener(launchListener);
        final JPopupMenu popupMenuChat = new JPopupMenu();
        popupMenuChat.add(killItem2);
        popupMenuChat.add(resumeItem2);
        popupMenuChat.add(launchItem2);
        popupMenuChat.add(chatItem2);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int[] sel = DownloadView.this._table.getSelectedRows();
                    int i = 0;
                    while (i < sel.length) {
                        DownloadData dd = DownloadView.this._dlist.get(sel[i]);
                        Downloader downloader = dd.getManager();
                        if (downloader.chatEnabled()) {
                            popupMenuChat.show(DownloadView.this._table, e.getX(), e.getY());
                        } else {
                            popupMenu.show(DownloadView.this._table, e.getX(), e.getY());
                        }
                        ++i;
                    }
                } else if (e.getClickCount() == 2) {
                    DownloadView.this.launchFiles();
                }
            }
        };
        this._table.addMouseListener(mouseListener);
    }

    int getTotalDownloads() {
        return this._totalDownloads;
    }

    int getCurrentDownloads() {
        return this._dlist.getCurrentDownloads();
    }

    void addDownload(Downloader mgr) {
        if (!this._dlist.findDownload(mgr)) {
            ++this._totalDownloads;
            this._dlist.add(mgr);
        }
    }

    void removeDownload(Downloader mgr) {
        if (this._settings.getClearCompletedDownload() && mgr.getState() == 4) {
            this._dlist.remove(mgr);
        }
    }

    void updateConnectionStats() {
        this._dlist.updateConnectionStats();
        int size = this._dlist.size();
        this._dataModel.fireTableRowsUpdated(0, size);
    }

    private ActionListener killListener() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] sel = DownloadView.this._table.getSelectedRows();
                int counter = sel.length;
                --counter;
                while (counter >= 0) {
                    DownloadView.this._dlist.remove(sel[counter]);
                    --counter;
                }
            }
        };
        return al;
    }

    private ActionListener resumeListener() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] sel = DownloadView.this._table.getSelectedRows();
                int i = 0;
                while (i < sel.length) {
                    DownloadData dd = DownloadView.this._dlist.get(sel[i]);
                    Downloader downloader = dd.getManager();
                    try {
                        downloader.resume();
                    }
                    catch (AlreadyDownloadingException e2) {
                        GUIMediator.instance().showError("ERROR_ALREADY_DOWNLOADING", "\"" + e2.getFilename() + "\".");
                    }
                    ++i;
                }
            }
        };
        return al;
    }

    private ActionListener clearListener() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadView.this._dlist.clearCompleted();
            }
        };
        return al;
    }

    private ActionListener chatListener() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RouterService backend = GUIMediator.instance().getRouter();
                int[] sel = DownloadView.this._table.getSelectedRows();
                int i = 0;
                while (i < sel.length) {
                    DownloadData dd = DownloadView.this._dlist.get(sel[i]);
                    Downloader downloader = dd.getManager();
                    String host = downloader.getHost();
                    int port = downloader.getPort();
                    backend.createChat(host, port);
                    ++i;
                }
            }
        };
        return al;
    }

    private void launchFiles() {
        int[] rows = this._table.getSelectedRows();
        int i = 0;
        int length = rows.length;
        String path = "";
        while (i < length) {
            DownloadData dd = this._dlist.get(rows[i]);
            Downloader downloader = dd.getManager();
            downloader.launch();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SizeHolder {
        String _string;
        int _size;

        private SizeHolder(int size) {
            this._string = GUIUtils.toKilobytes(size);
            this._size = size;
        }

        public String toString() {
            return this._string;
        }

        private int getSize() {
            return this._size;
        }
    }

    private class DownloadData {
        private Downloader _mgr;
        private String _fileName;
        private Integer _length;
        private String _status;
        private ProgressBarHolder _progress;
        private String _speed;
        private int _amountRead;
        private boolean _completed;
        private String _lengthString;
        private SizeHolder _size;

        DownloadData(Downloader mgr) {
            this._mgr = mgr;
            this._fileName = this._mgr.getFileName();
            if (this._fileName == null) {
                this._fileName = "";
            }
            this._status = "";
            this._progress = new ProgressBarHolder();
            this._speed = "0 KB/s";
            this._amountRead = 0;
            this._completed = false;
            this._size = new SizeHolder(this._mgr.getContentLength());
        }

        Object getValueAt(int index) {
            Object result = null;
            switch (index) {
                case 0: {
                    result = this._fileName;
                    break;
                }
                case 1: {
                    result = this._size;
                    break;
                }
                case 2: {
                    result = this._status;
                    break;
                }
                case 3: {
                    result = this._progress;
                    break;
                }
                case 4: {
                    result = this._speed;
                }
            }
            return result;
        }

        int getLength() {
            return this._size.getSize();
        }

        void shutdown() {
            if (this._mgr != null) {
                this._mgr.stop();
            }
        }

        boolean checkMgr(Downloader mgr) {
            boolean toReturn = false;
            if (this._mgr.equals(mgr)) {
                toReturn = true;
            }
            return toReturn;
        }

        Downloader getManager() {
            return this._mgr;
        }

        void setManager(Downloader mgr) {
            this._mgr = mgr;
        }

        String getIPName() {
            return this._mgr.getHost();
        }

        boolean isCompleted() {
            return this._completed;
        }

        void update() {
            String newFileName_ = this._mgr.getFileName();
            if (newFileName_ != null) {
                this._fileName = newFileName_;
            }
            this._lengthString = this._size.toString();
            int oldAmountRead = this._amountRead;
            this._amountRead = this._mgr.getAmountRead();
            this._speed = "";
            switch (this._mgr.getState()) {
                case 0: {
                    this._status = "Queued";
                    break;
                }
                case 1: {
                    String address = this._mgr.getHost();
                    Assert.that(address != null, "Null address in connecting state");
                    int stateTime = this._mgr.getRemainingStateTime();
                    this._status = "Connecting to " + address + " (" + stateTime + "s)";
                    break;
                }
                case 3: {
                    int stateTime = this._mgr.getRemainingStateTime();
                    int retriesWaiting = this._mgr.getRetriesWaiting();
                    int pushesWaiting = this._mgr.getPushesWaiting();
                    StringBuffer reason = new StringBuffer();
                    if (retriesWaiting != 0) {
                        reason.append(retriesWaiting);
                        reason.append(" busy");
                    }
                    if (pushesWaiting != 0) {
                        if (reason.length() != 0) {
                            reason.append(", ");
                        }
                        reason.append(pushesWaiting);
                        if (pushesWaiting == 1) {
                            reason.append(" reply");
                        } else {
                            reason.append(" replies");
                        }
                    }
                    this._status = "Waiting " + stateTime + "s for " + reason;
                    break;
                }
                case 4: {
                    if (this._completed) break;
                    this._completed = true;
                    this._status = "Complete";
                    this._progress.setValue(100);
                    break;
                }
                case 5: {
                    this._status = "Aborted";
                    break;
                }
                case 6: {
                    this._status = "Couldn't download";
                    break;
                }
                case 2: {
                    String address = this._mgr.getHost();
                    Assert.that(address != null, "Null address in downloading state");
                    this._status = "Downloading from " + address;
                    double d = (double)this._amountRead / (double)this._size.getSize();
                    int z = (int)(d * 100.0);
                    this._progress.setValue(z);
                    int round = (this._amountRead - oldAmountRead) * 10;
                    double rate = (double)(round /= 2048) / 10.0;
                    if (!(rate >= 0.0)) break;
                    this._speed = String.valueOf(rate) + " KB/s";
                    break;
                }
                case 7: {
                    this._status = "Couldn't move to library";
                    this._progress.setValue(100);
                    break;
                }
                default: {
                    Assert.that(false, "Unknown status " + this._mgr.getState() + " of downloader");
                }
            }
        }
    }

    private class DownloadList {
        private ArrayList _list = new ArrayList();
        private boolean _ascending = false;

        DownloadList() {
        }

        int size() {
            int i = this._list.size();
            return i;
        }

        void sort(int col) {
            DownloadComp comp;
            if (this._ascending) {
                comp = new DownloadComp(col, 0);
                this._ascending = false;
            } else {
                comp = new DownloadComp(col, 1);
                this._ascending = true;
            }
            Collections.sort((List)this._list, (Comparator)comp);
            DownloadView.this._dataModel.fireTableDataChanged();
        }

        void add(Downloader mgr) {
            DownloadView.this._table.clearSelection();
            DownloadData dd = new DownloadData(mgr);
            this._list.add(0, (Object)dd);
            DownloadView.this._dataModel.fireTableRowsInserted(0, 0);
        }

        void remove(Downloader mgr) {
            int end = this._list.size();
            int i = 0;
            while (i < end) {
                DownloadData dd = (DownloadData)this._list.get(i);
                boolean found = dd.checkMgr(mgr);
                if (found) {
                    dd.shutdown();
                    this._list.remove(i);
                    DownloadView.this._dataModel.fireTableRowsDeleted(i, i);
                    break;
                }
                ++i;
            }
        }

        DownloadData get(int i) {
            DownloadData dd = (DownloadData)this._list.get(i);
            return dd;
        }

        void shutdown(int i) {
            DownloadData dd = (DownloadData)this._list.get(i);
            dd.shutdown();
        }

        void remove(int i) {
            DownloadData dd = (DownloadData)this._list.get(i);
            dd.shutdown();
            this._list.remove(i);
            DownloadView.this._dataModel.fireTableRowsDeleted(i, i);
        }

        Object getValueAt(int row, int col) {
            int size = this._list.size();
            Object toReturn = null;
            if (row >= 0 && row < this._list.size()) {
                DownloadData dd = (DownloadData)this._list.get(row);
                toReturn = dd.getValueAt(col);
            }
            return toReturn;
        }

        boolean findDownload(Downloader mgr) {
            boolean found = false;
            int end = this._list.size();
            int i = 0;
            while (i < end) {
                DownloadData dd = (DownloadData)this._list.get(i);
                found = dd.checkMgr(mgr);
                if (found) {
                    return found;
                }
                ++i;
            }
            return found;
        }

        int countActiveDownloads() {
            int size = this._list.size();
            DownloadData dd = null;
            int count = 0;
            int i = 0;
            while (i < size) {
                dd = (DownloadData)this._list.get(i);
                int state = dd.getManager().getState();
                if (state == 1 || state == 2 || state == 3) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        int getCurrentDownloads() {
            int size = this._list.size();
            DownloadData dd = null;
            int count = 0;
            int i = 0;
            while (i < size) {
                dd = (DownloadData)this._list.get(i);
                int state = dd.getManager().getState();
                if (state == 2) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        void updateConnectionStats() {
            int size = this._list.size();
            int i = 0;
            while (i < size) {
                DownloadData dd = (DownloadData)this._list.get(i);
                dd.update();
                ++i;
            }
        }

        void clearCompleted() {
            int size = this._list.size();
            int i = --size;
            while (i >= 0) {
                DownloadData dd = (DownloadData)this._list.get(i);
                if (dd.getManager().getState() == 4 || dd.getManager().getState() == 5 || dd.getManager().getState() == 6 || dd.getManager().getState() == 7) {
                    this.remove(i);
                }
                --i;
            }
        }
    }

    private class DownloadComp
    implements Comparator {
        private int col_;
        private int mode_;
        private final int ASCENDING = 0;

        public DownloadComp(int col, int mode) {
            this.col_ = col;
            this.mode_ = mode;
        }

        public int compare(Object a, Object b) {
            DownloadData dda = (DownloadData)a;
            DownloadData ddb = (DownloadData)b;
            int toReturn = 0;
            switch (this.col_) {
                case 0: 
                case 2: 
                case 4: {
                    String value1 = ((String)dda.getValueAt(this.col_)).toLowerCase();
                    String value2 = ((String)ddb.getValueAt(this.col_)).toLowerCase();
                    if (this.mode_ == 0) {
                        toReturn = value2.compareTo(value1);
                        break;
                    }
                    toReturn = value1.compareTo(value2);
                    break;
                }
                case 1: {
                    SizeHolder holder1 = (SizeHolder)dda.getValueAt(this.col_);
                    SizeHolder holder2 = (SizeHolder)ddb.getValueAt(this.col_);
                    int sizea = holder1.getSize();
                    int sizeb = holder2.getSize();
                    if (this.mode_ == 0) {
                        toReturn = -(sizea - sizeb);
                        break;
                    }
                    toReturn = sizea - sizeb;
                    break;
                }
                case 3: {
                    ProgressBarHolder ph1 = (ProgressBarHolder)dda.getValueAt(this.col_);
                    ProgressBarHolder ph2 = (ProgressBarHolder)ddb.getValueAt(this.col_);
                    int int1 = ph1.getValue();
                    int int2 = ph2.getValue();
                    toReturn = this.mode_ == 0 ? -(int1 - int2) : int1 - int2;
                }
            }
            return toReturn;
        }
    }

    private class ColumnSorter
    extends MouseAdapter {
        private ColumnSorter() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = DownloadView.this._table.getColumnModel();
            int col = columnModel.getColumnIndexAtX(e.getX());
            int c = DownloadView.this._table.convertColumnIndexToModel(col);
            if (e.getClickCount() == 1 && c != -1) {
                DownloadView.this._dlist.sort(c);
            }
        }
    }

    private class DownloadTableModel
    extends AbstractTableModel {
        private final String[] columnNames_ = new String[]{"Name", "Size", "Status", "Progress", "Speed"};

        private DownloadTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public int getRowCount() {
            return DownloadView.this._dlist.size();
        }

        public String getColumnName(int col) {
            return this.columnNames_[col];
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public Object getValueAt(int row, int col) {
            Object toReturn = null;
            if (row >= 0 && row < DownloadView.this._dlist.size()) {
                toReturn = DownloadView.this._dlist.getValueAt(row, col);
            }
            return toReturn;
        }
    }
}

