/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.CloseDialog;
import com.limegroup.gnutella.gui.CommunityView;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.DownloadView;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MenuBar;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SearchView;
import com.limegroup.gnutella.gui.StatisticsView;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.SystemTrayDialog;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.library.LibraryView;
import com.limegroup.gnutella.gui.notify.NotifyCallback;
import com.limegroup.gnutella.gui.notify.WindowsNotifyPopupMenu;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public final class GUIMediator
implements NotifyCallback {
    private static final GUIMediator INSTANCE = new GUIMediator();
    private final String WINDOWS_LIBRARY_NAME = "LimeWire16d.dll";
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    private final int SEARCH_INDEX = 0;
    private final int MONITOR_INDEX = 1;
    private final int CONNECTIONS_INDEX = 2;
    private final int COMMUNITY_INDEX = 3;
    private final int LIBRARY_INDEX = 4;
    private MainFrame _mainFrame;
    private SearchView _searchView;
    private DownloadView _downloadView;
    private MonitorView _monitorView;
    private UploadView _uploadView;
    private ConnectionView _connectionView;
    private CommunityView _communityView;
    private LibraryView _libraryView;
    private StatisticsView _statsView;
    private OptionsMediator _optionsMediator;
    private MenuBar _menuBar;
    private StatusLine _statusLine;
    private SettingsManager _settings;
    private RouterService _routerService;
    private int _handler = 0;
    private final MessageService MESSAGE_SERVICE = new MessageService();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private ResourceManager RESOURCE_MANAGER = ResourceManager.instance();
    static /* synthetic */ Class class$com$limegroup$gnutella$util$Launcher;

    public static synchronized GUIMediator instance() {
        return INSTANCE;
    }

    private GUIMediator() {
        this.copyWindowsLibrary();
    }

    public final void initialize() {
        this._mainFrame = new MainFrame();
        this.MESSAGE_SERVICE.setParent(this._mainFrame.getFrame());
        this._searchView = new SearchView();
        this._downloadView = new DownloadView();
        this._monitorView = new MonitorView();
        this._uploadView = new UploadView();
        this._connectionView = new ConnectionView();
        this._communityView = new CommunityView();
        this._libraryView = new LibraryView();
        this._optionsMediator = OptionsMediator.instance();
        this._statsView = new StatisticsView();
        this._statusLine = new StatusLine();
        this._menuBar = new MenuBar();
        this._mainFrame.addSearchTab(this._searchView, this._downloadView);
        this._mainFrame.addMonitorTab(this._monitorView, this._uploadView);
        this._mainFrame.addConnectionsTab(this._connectionView);
        this._mainFrame.addCommunityTab(this._communityView);
        this._mainFrame.addLibraryTab(this._libraryView);
        this._mainFrame.addMenuBar(this._menuBar);
        this._mainFrame.addStatusLine(this._statusLine);
    }

    public final void postInit() {
        this._connectionView.initHosts();
        RefreshTimer timer = new RefreshTimer();
        timer.startTimer();
    }

    public final boolean getAppVisible() {
        return this._mainFrame.getAppVisible();
    }

    public final void setAppVisible(boolean visible) {
        this._mainFrame.setAppVisible(visible);
        if (visible && !SettingsManager.instance().get17SearchMessageShown()) {
            this.showMessage("MESSAGE_NEW_SEARCH_QUALITY_FILTERING");
            SettingsManager.instance().set17SearchMessageShown(true);
        }
    }

    public final Dimension getAppSize() {
        return this._mainFrame.getAppSize();
    }

    public final Point getAppLocation() {
        return this._mainFrame.getAppLocation();
    }

    public final Frame getMainFrame() {
        return this._mainFrame.getFrame();
    }

    public final SearchView getSearchView() {
        return this._searchView;
    }

    public final DownloadView getDownloadView() {
        return this._downloadView;
    }

    public final MonitorView getMonitorView() {
        return this._monitorView;
    }

    public final UploadView getUploadView() {
        return this._uploadView;
    }

    public final ConnectionView getConnectionView() {
        return this._connectionView;
    }

    public final LibraryView getLibraryView() {
        return this._libraryView;
    }

    public final StatusLine getStatusLine() {
        return this._statusLine;
    }

    public final RouterService getRouter() {
        return this._routerService;
    }

    public final void setRouterService(RouterService routerService) {
        this._routerService = routerService;
    }

    public final void refreshGUI() {
        this._statsView.updateStatistics();
        this._connectionView.updateConnectionStats();
        this._uploadView.updateConnectionStats();
        this._downloadView.updateConnectionStats();
        this.SETTINGS.updateUptime(2000);
        int numHosts = (int)this._routerService.getNumHosts();
        long numFiles = this._routerService.getNumFiles();
        long totSize = this._routerService.getTotalFileSize();
        int sharedFiles = this._routerService.getNumSharedFiles();
        this._statusLine.setStatistics(numHosts, numFiles, totSize, sharedFiles);
        this._routerService.updateHorizon();
    }

    public final void showConfigView() {
        this._optionsMediator.setOptionsVisible(true);
    }

    public final void showStatsView() {
        this._statsView.setLocationRelativeTo(this.getMainFrame());
        this._statsView.show();
    }

    public final void handleTabSelection(int SELECTED_TAB) {
        switch (SELECTED_TAB) {
            case 0: {
                this._menuBar.handleStandardSelection();
                break;
            }
            case 1: {
                this._menuBar.handleStandardSelection();
                break;
            }
            case 2: {
                this._menuBar.handleStandardSelection();
                break;
            }
            case 3: {
                this._menuBar.handleCommunitySelection();
                break;
            }
            case 4: {
                this._menuBar.handleLibrarySelection();
            }
        }
    }

    public final void setWindow(int index) {
        this._mainFrame.setSelectedIndex(index);
    }

    public final void clearConnections() {
        this._connectionView.clearConnections();
    }

    public final void triggerSearch(String query) {
        this._searchView.triggerSearch(query);
        this._mainFrame.setSelectedIndex(0);
    }

    public final void setConnected() {
        this._statusLine.setConnected();
    }

    public final void setDisconnected() {
        this._statusLine.setDisconnected();
    }

    public final int getTotalUploads() {
        return this._uploadView.getTotalUploads();
    }

    public final int getCurrentUploads() {
        return this._uploadView.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this._downloadView.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this._downloadView.getCurrentDownloads();
    }

    public final void addSharedLibraryFolder() {
        this._libraryView.addSharedLibraryFolder();
    }

    public final void addNewLibraryFolder() {
        this._libraryView.addNewLibraryFolder();
    }

    public final void deleteLibraryFolder() {
        this._libraryView.deleteLibraryFolder();
    }

    public final void renameLibraryFolder() {
        this._libraryView.renameLibraryFolder();
    }

    public final void launchLibraryFile() {
        this._libraryView.launch();
    }

    public final void deleteLibraryFile() {
        this._libraryView.deleteLibraryFile();
    }

    public final void refreshLibrary() {
        this._libraryView.refresh();
    }

    public final void clearLibrary() {
        this._libraryView.clearLibrary();
    }

    public final void connectToGroup() {
        this._communityView.connectToGroup();
    }

    public final void logoutGroup() {
        this._communityView.connectToGroup("Logout");
    }

    public final void setKeepAliveText(String keepAlive) {
        this._connectionView.setKeepAliveText(keepAlive);
    }

    public final void shutdown() {
        if (CommonUtils.supportsTray()) {
            if (this.SETTINGS.getShowTrayDialog()) {
                SystemTrayDialog std = new SystemTrayDialog();
                std.showDialog();
            } else if (this.SETTINGS.getMinimizeToTray()) {
                this.goToTray();
            } else {
                Initializer.instance().shutdown();
            }
        } else if (this.SETTINGS.getShowCloseDialog()) {
            CloseDialog closeDialog = new CloseDialog();
            closeDialog.showDialog();
        } else {
            Initializer.instance().shutdown();
        }
    }

    public final void goToTray() {
        this._mainFrame.setAppVisible(false);
        if (!this.SETTINGS.getAcceptedIncoming()) {
            Thread reduceConnections = new Thread(){

                public void run() {
                    GUIMediator.this._routerService.reduceConnections();
                }
            };
            reduceConnections.setDaemon(true);
            reduceConnections.start();
        }
    }

    public final void restoreApplication() {
        this._routerService.setKeepAlive(this.SETTINGS.getKeepAlive());
        this._mainFrame.setAppVisible(true);
    }

    public final void exitApplication() {
        Initializer.instance().shutdown();
    }

    public final void showMenu(final int x, final int y) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowsNotifyPopupMenu popupMenu = new WindowsNotifyPopupMenu(GUIMediator.this);
                popupMenu.showPopup(x, y);
            }
        });
    }

    public final void showAboutWindow() {
        this._menuBar.showAboutWindow();
    }

    public final ImageIcon getImageResource(String imageName) {
        return this.RESOURCE_MANAGER.getImageResource(imageName);
    }

    public final String getStringResource(String resourceKey) {
        return this.RESOURCE_MANAGER.getStringResource(resourceKey);
    }

    public final void showError(String messageKey) {
        String msg = this.getStringResource(messageKey);
        this.MESSAGE_SERVICE.showError(msg);
    }

    public final void showError(String messageKey, String message) {
        String msg = this.getStringResource(messageKey) + " " + message;
        this.MESSAGE_SERVICE.showError(msg);
    }

    public final void showError(String messageStartKey, String message, String messageEndKey) {
        String msg = this.getStringResource(messageStartKey) + " " + message + " " + this.getStringResource(messageEndKey);
        this.MESSAGE_SERVICE.showError(msg);
    }

    public final void showMessage(String messageKey) {
        String msg = this.getStringResource(messageKey);
        this.MESSAGE_SERVICE.showMessage(msg);
    }

    public final void showMessage(String messageKey, String message) {
        String msg = this.getStringResource(messageKey) + " " + message;
        this.MESSAGE_SERVICE.showMessage(msg);
    }

    public final void showMessage(String messageStartKey, String message, String messageEndKey) {
        String msg = this.getStringResource(messageStartKey) + " " + message + " " + this.getStringResource(messageEndKey);
        this.MESSAGE_SERVICE.showMessage(msg);
    }

    public final void showConfirmMessage(String messageKey) {
        String msg = this.getStringResource(messageKey);
        this.MESSAGE_SERVICE.showConfirmMessage(msg);
    }

    public final void showConfirmMessage(String messageKey, String message) {
        String msg = this.getStringResource(messageKey) + " " + message;
        this.MESSAGE_SERVICE.showConfirmMessage(msg);
    }

    public final void showConfirmMessage(String messageStartKey, String message, String messageEndKey) {
        String msg = this.getStringResource(messageStartKey) + " " + message + " " + this.getStringResource(messageEndKey);
        this.MESSAGE_SERVICE.showConfirmMessage(msg);
    }

    public final int showYesNoMessage(String messageKey) {
        String msg = this.getStringResource(messageKey);
        return this.MESSAGE_SERVICE.showYesNoMessage(msg);
    }

    public final int showYesNoMessage(String messageKey, String message) {
        String msg = this.getStringResource(messageKey) + " " + message;
        return this.MESSAGE_SERVICE.showYesNoMessage(msg);
    }

    public final int showYesNoMessage(String messageStartKey, String message, String messageEndKey) {
        String msg = this.getStringResource(messageStartKey) + " " + message + " " + this.getStringResource(messageEndKey);
        return this.MESSAGE_SERVICE.showYesNoMessage(msg);
    }

    public final void showInternalError(String messageKey, Throwable t) {
        String msg = this.getStringResource(messageKey);
        this.MESSAGE_SERVICE.showInternalError(msg, t);
    }

    public final void showInternalError(Throwable t) {
        String msg = this.getStringResource("ERROR_INTERNAL");
        this.MESSAGE_SERVICE.showInternalError(msg, t);
    }

    public final int openURL(String url) throws IOException {
        return Launcher.openURL(url);
    }

    public final int launchFile(File file) throws IOException {
        try {
            return Launcher.launchFile(file);
        }
        catch (SecurityException se) {
            this.showError("MESSAGE_FILE_LAUNCHING_SECURITY_MESSAGE");
            return -1;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private final void copyWindowsLibrary() {
        block22: {
            if (CommonUtils.isWindows()) {
                int c;
                File nativeLibrary = new File("LimeWire16d.dll");
                if (nativeLibrary.exists()) {
                    return;
                }
                ClassLoader cl = (class$com$limegroup$gnutella$util$Launcher == null ? (class$com$limegroup$gnutella$util$Launcher = GUIMediator.class$("com.limegroup.gnutella.util.Launcher")) : class$com$limegroup$gnutella$util$Launcher).getClassLoader();
                InputStream is = null;
                FileOutputStream fos = null;
                is = cl != null ? cl.getResourceAsStream("LimeWire16d.dll") : ClassLoader.getSystemResourceAsStream("LimeWire16d.dll");
                if (is == null) {
                    return;
                }
                fos = new FileOutputStream(nativeLibrary);
                while ((c = is.read()) != -1) {
                    void var5_5;
                    fos.write((int)var5_5);
                }
                is.close();
                fos.close();
                Object var8_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    break block22;
                }
                catch (IOException ioe2) {}
                break block22;
                {
                    catch (FileNotFoundException fnfe) {
                        this.showInternalError(fnfe);
                        nativeLibrary.delete();
                        Object var8_8 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                            break block22;
                        }
                        catch (IOException ioe2) {}
                        break block22;
                    }
                    catch (IOException ioe) {
                        this.showInternalError(ioe);
                        nativeLibrary.delete();
                        Object var8_9 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                            break block22;
                        }
                        catch (IOException ioe2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

