/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class GUIUtils {
    private static final JFileChooser _fileChooser = new JFileChooser();
    private ImageIcon _questionIcon;
    private ImageIcon _warningIcon;
    private ImageIcon _infoIcon;

    private GUIUtils() {
    }

    public static JFileChooser getFileChooser() {
        return _fileChooser;
    }

    public static String toKilobytes(int bytes) {
        double d = (double)bytes / 1024.0;
        if (d < 1.0 && d > 0.0) {
            d = 1.0;
        }
        StringBuffer sb = new StringBuffer(Integer.toString((int)d));
        if (d >= 1000.0) {
            sb.insert(sb.length() - 3, ",");
            if (d >= 1000000.0) {
                sb.insert(sb.length() - 7, ",");
            }
        }
        sb.append("KB");
        return sb.toString();
    }

    public static MultiLineLabel getSizedLabel(String msg) {
        Dimension dim = new Dimension();
        MultiLineLabel label = new MultiLineLabel(msg);
        FontMetrics fm = ((Component)label).getFontMetrics(label.getFont());
        int width = fm.stringWidth(msg);
        dim.setSize(Integer.MAX_VALUE, width / 9);
        label.setPreferredSize(dim);
        return label;
    }

    public static String speed2name(int rate) {
        if (rate <= 56) {
            return "Modem";
        }
        if (rate <= 350) {
            return "Cable";
        }
        if (rate <= 1000) {
            return "T1";
        }
        return "T3";
    }
}

