/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.VisualConnectionCallback;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.update.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.UIManager;

public class Initializer {
    private static final Initializer INSTANCE = new Initializer();
    private RouterService _routerService;

    public static synchronized Initializer instance() {
        return INSTANCE;
    }

    private Initializer() {
    }

    public void initialize() {
        try {
            ResourceManager resourceManager = ResourceManager.instance();
            if (CommonUtils.isMacOSX()) {
                String lafName = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lafName);
            } else {
                UIManager.setLookAndFeel(resourceManager.getLookAndFeel());
            }
            GUIMediator mediator = GUIMediator.instance();
            SettingsManager.instance();
            FileManager.instance();
            UpdateManager um = UpdateManager.instance();
            um.doUpdate();
            if (!SettingsManager.instance().getInstalled()) {
                SetupManager setupManager = new SetupManager();
            }
            SplashWindow splash = new SplashWindow();
            VisualConnectionCallback vcc = new VisualConnectionCallback();
            StandardMessageRouter smr = new StandardMessageRouter(vcc);
            ChatManager.instance().setActivityCallback(vcc);
            this._routerService = new RouterService(vcc, smr);
            mediator.setRouterService(this._routerService);
            mediator.initialize();
            vcc.initialize();
            this._routerService.initialize();
            mediator.postInit();
            splash.dispose();
            mediator.setAppVisible(true);
            this._routerService.postGuiInit();
            NotifyUserProxy notifyProxy = NotifyUserProxy.instance();
        }
        catch (Exception e) {
            if (GUIMediator.instance() != null) {
                GUIMediator.instance().showInternalError(e);
            }
            e.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            SettingsManager settings = SettingsManager.instance();
            GUIMediator mediator = GUIMediator.instance();
            if (mediator.getAppVisible()) {
                NotifyUserProxy.instance().removeNotify(mediator);
                Dimension dim = mediator.getAppSize();
                Point loc = mediator.getAppLocation();
                settings.setAppWidth(dim.width);
                settings.setAppHeight(dim.height);
                settings.setWindowX(loc.x);
                settings.setWindowY(loc.y);
                settings.setRunOnce(true);
            }
            if (this._routerService != null) {
                this._routerService.shutdown();
            } else {
                settings.writeProperties();
            }
            System.exit(0);
        }
        catch (Exception e) {
            if (GUIMediator.instance() != null) {
                GUIMediator.instance().showInternalError(e);
            } else {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

