/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalScrollButton;

public class LimeButtonUI
extends BasicButtonUI {
    private static final LimeButtonUI limeButtonUI = new LimeButtonUI();
    private static ImageIcon _default0 = LimeButtonUI.getImageResource("button1.gif");
    private static ImageIcon _default1 = LimeButtonUI.getImageResource("button2.gif");
    private static ImageIcon _default2 = LimeButtonUI.getImageResource("button3.gif");
    private static ImageIcon _default3 = LimeButtonUI.getImageResource("button4.gif");
    private static ImageIcon _pressed0 = LimeButtonUI.getImageResource("button1_press.gif");
    private static ImageIcon _pressed1 = LimeButtonUI.getImageResource("button2_press.gif");
    private static ImageIcon _pressed2 = LimeButtonUI.getImageResource("button3_press.gif");
    private static ImageIcon _pressed3 = LimeButtonUI.getImageResource("button4_press.gif");
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$LimeButtonUI;

    public static ComponentUI createUI(JComponent c) {
        return limeButtonUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton b = (AbstractButton)c;
        if (b instanceof JButton && !(b instanceof MetalComboBoxButton) && !(b instanceof BasicArrowButton) && !(b instanceof MetalScrollButton) && b.getIcon() == null) {
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            b.setHorizontalTextPosition(0);
            b.setFocusPainted(false);
            this.setIcons(b);
        }
    }

    private void setIcons(AbstractButton button) {
        ImageIcon pressedButtonIcon;
        ImageIcon buttonIcon;
        FontMetrics fm = ((Component)button).getFontMetrics(button.getFont());
        int stringWidth = fm.stringWidth(button.getText());
        if (stringWidth < 30) {
            buttonIcon = _default0;
            pressedButtonIcon = _pressed0;
        } else if (stringWidth < 53) {
            buttonIcon = _default1;
            pressedButtonIcon = _pressed1;
        } else if (stringWidth < 72) {
            buttonIcon = _default2;
            pressedButtonIcon = _pressed2;
        } else {
            buttonIcon = _default3;
            pressedButtonIcon = _pressed3;
        }
        button.setIcon(buttonIcon);
        button.setDisabledIcon(buttonIcon);
        button.setPressedIcon(pressedButtonIcon);
        button.setDisabledSelectedIcon(pressedButtonIcon);
        button.setPreferredSize(new Dimension(buttonIcon.getIconWidth(), buttonIcon.getIconHeight()));
    }

    private static ImageIcon getImageResource(String imageName) {
        ClassLoader cl = (class$com$limegroup$gnutella$gui$LimeButtonUI == null ? (class$com$limegroup$gnutella$gui$LimeButtonUI = LimeButtonUI.class$("com.limegroup.gnutella.gui.LimeButtonUI")) : class$com$limegroup$gnutella$gui$LimeButtonUI).getClassLoader();
        String IMAGES_PREFIX = "com/limegroup/gnutella/gui/images/";
        URL imageURL = null;
        if (cl == null) {
            imageURL = ClassLoader.getSystemResource(IMAGES_PREFIX + imageName);
            return new ImageIcon(imageURL);
        }
        imageURL = cl.getResource(IMAGES_PREFIX + imageName);
        if (imageURL == null) {
            imageURL = ClassLoader.getSystemResource(IMAGES_PREFIX + imageName);
        }
        return new ImageIcon(imageURL);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

