/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTheme;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class LimeLookAndFeel
extends MetalLookAndFeel {
    LimeLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme(new LimeTheme());
    }

    public String getDescription() {
        return "Lime Look and Feel";
    }

    public String getID() {
        return "GoLime";
    }

    public String getName() {
        return "Lime Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String limePackageName = "com.limegroup.gnutella.gui.";
        table.put("ButtonUI", limePackageName + "LimeButtonUI");
        if (!CommonUtils.isMacClassic()) {
            table.put("ClassLoader", this.getClass().getClassLoader());
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        ResourceManager manager = ResourceManager.instance();
        ImageIcon questionIcon = manager.getImageResource("question.gif");
        ImageIcon errorIcon = manager.getImageResource("warning.gif");
        ImageIcon infoIcon = manager.getImageResource("notsearching.gif");
        ImageIcon openDirIcon = manager.getImageResource("dir_open.gif");
        ImageIcon closedDirIcon = manager.getImageResource("dir_closed.gif");
        FontUIResource osFont = new FontUIResource("Dialog", 0, 11);
        table.put("Tree.expandedIcon", openDirIcon);
        table.put("Tree.collapsedIcon", closedDirIcon);
        table.put("TableHeader.background", new ColorUIResource(117, 142, 197));
        table.put("OptionPane.questionIcon", questionIcon);
        table.put("OptionPane.errorIcon", errorIcon);
        table.put("OptionPane.informationIcon", infoIcon);
        table.put("Tree.leafIcon", MetalIconFactory.getTreeFolderIcon());
        table.put("Tree.rightChildIndent", new Integer(8));
        table.put("Table.focusCellForeground", UIManager.getColor("Table.selectionForeground"));
        table.put("Table.focusCellBackground", UIManager.getColor("Table.selectionBackground"));
        table.put("RadioButton.foreground", MetalLookAndFeel.getSystemTextColor());
        table.put("CheckBox.foreground", MetalLookAndFeel.getSystemTextColor());
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            table.put("Label.font", osFont);
            table.put("Button.font", osFont);
        }
    }
}

