/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.sun.java.util.collections.Vector;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditor
extends JPanel {
    protected Vector model;
    protected DefaultListModel realModel;
    protected Vector listeners = new Vector();
    private static final int DEFAULT_COLUMNS = 10;
    protected JTextField editor;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList list;
    private boolean addTail = true;

    public ListEditor() {
        this(new Vector());
    }

    public ListEditor(Vector model) {
        JPanel controls = new JPanel();
        this.editor = new JTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(new AddListener());
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new RemoveListener());
        controls.setLayout(new BoxLayout(controls, 0));
        controls.add(this.editor);
        controls.add(this.addButton);
        controls.add(this.removeButton);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(model);
        scrollPane.setPreferredSize(new Dimension(500, 50));
        scrollPane.setMaximumSize(new Dimension(500, 50));
        this.setLayout(new BoxLayout(this, 1));
        this.add(controls);
        this.add(scrollPane);
    }

    public Vector getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector model) {
        this.model = model;
        this.realModel = new DefaultListModel();
        int i = 0;
        while (i < model.size()) {
            this.realModel.addElement(model.get(i));
            ++i;
        }
        this.list.setModel(this.realModel);
    }

    public void setAddTail(boolean addTail) {
        this.addTail = addTail;
    }

    public boolean getAddTail() {
        return this.addTail;
    }

    public synchronized void addListDataListener(ListDataListener listener) {
        this.listeners.add((Object)listener);
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.model.remove(i);
                ListEditor.this.realModel.remove(i);
                ListEditor.this.editor.setText("");
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 2, i, i);
                int j = 0;
                while (j < ListEditor.this.listeners.size()) {
                    ListDataListener listener = (ListDataListener)ListEditor.this.listeners.get(j);
                    listener.intervalRemoved(event);
                    ++j;
                }
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String text = ListEditor.this.editor.getText();
            if (text.trim().equals("")) {
                return;
            }
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.model.setElementAt((Object)text, i);
                ListEditor.this.realModel.setElementAt(text, i);
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 0, i, i);
                int j = 0;
                while (j < ListEditor.this.listeners.size()) {
                    ListDataListener listener = (ListDataListener)ListEditor.this.listeners.get(j);
                    listener.contentsChanged(event);
                    ++j;
                }
            } else {
                int last;
                if (ListEditor.this.addTail) {
                    ListEditor.this.model.addElement((Object)text);
                    ListEditor.this.realModel.addElement(text);
                    last = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, (Object)text);
                    ListEditor.this.realModel.add(0, text);
                    last = 0;
                }
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 1, last, last);
                int j = 0;
                while (j < ListEditor.this.listeners.size()) {
                    ListDataListener listener = (ListDataListener)ListEditor.this.listeners.get(j);
                    listener.intervalAdded(event);
                    ++j;
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object val = ListEditor.this.list.getSelectedValue();
            if (val == null) {
                return;
            }
            ListEditor.this.editor.setText((String)val);
        }
    }
}

