/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.CommunityView;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.DownloadView;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MenuBar;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.SearchView;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.library.LibraryView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class MainFrame {
    private final int APP_WIDTH = 700;
    private final int APP_HEIGHT = 600;
    private final String APP_TITLE = "APP_TITLE";
    private final String SEARCH_TITLE = "SEARCH_TITLE";
    private final String MONITOR_TITLE = "MONITOR_TITLE";
    private final String CONNECTIONS_TITLE = "CONNECTIONS_TITLE";
    private final String COMMUNITY_TITLE = "COMMUNITY_TITLE";
    private final String LIBRARY_TITLE = "LIBRARY_TITLE";
    private final String SEARCH_ICON = "search.gif";
    private final String MONITOR_ICON = "monitor.gif";
    private final String CONNECTIONS_ICON = "connections.gif";
    private final String COMMUNITY_ICON = "groups.gif";
    private final String LIBRARY_ICON = "library.gif";
    private final String PLUG_ICON = "plug.gif";
    private final String SEARCH_TIP = "SEARCH_TIP";
    private final String MONITOR_TIP = "MONITOR_TIP";
    private final String CONNECTIONS_TIP = "CONNECTIONS_TIP";
    private final String COMMUNITY_TIP = "COMMUNITY_TIP";
    private final String LIBRARY_TIP = "LIBRARY_TIP";
    private JFrame _frame;
    private SettingsManager _settings;
    private Container _contentPane;
    private MenuBar _menuBar;
    private GUIMediator _mediator = GUIMediator.instance();
    private JTabbedPane _tabbedPane;

    MainFrame() {
        this._frame = new JFrame(this._mediator.getStringResource("APP_TITLE"));
        ((Component)this._frame).setSize(700, 600);
        this._settings = SettingsManager.instance();
        this._tabbedPane = new JTabbedPane(1);
        this._tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane tp = (JTabbedPane)e.getSource();
                int index = tp.getSelectedIndex();
                MainFrame.this._mediator.handleTabSelection(tp.getSelectedIndex());
            }
        });
        this._contentPane = this._frame.getContentPane();
        this._contentPane.setLayout(new BoxLayout(this._contentPane, 1));
        this._contentPane.add((Component)this._tabbedPane, "Center");
        ImageIcon plugIcon = this._mediator.getImageResource("plug.gif");
        ((Frame)this._frame).setIconImage(plugIcon.getImage());
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this._mediator.shutdown();
            }
        });
        this._frame.setDefaultCloseOperation(0);
        this.setFrameDimensions();
    }

    final void addSearchTab(SearchView searchView, DownloadView downloadView) {
        JSplitPane splitPane = new JSplitPane(0, searchView, downloadView);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(330);
        this._tabbedPane.addTab(this._mediator.getStringResource("SEARCH_TITLE"), this._mediator.getImageResource("search.gif"), splitPane, this._mediator.getStringResource("SEARCH_TIP"));
    }

    final void addMonitorTab(MonitorView monitorView, UploadView uploadView) {
        JSplitPane monitorSplitPane = new JSplitPane(0, monitorView, uploadView);
        monitorSplitPane.setOneTouchExpandable(true);
        monitorSplitPane.setDividerLocation(300);
        this._tabbedPane.addTab(this._mediator.getStringResource("MONITOR_TITLE"), this._mediator.getImageResource("monitor.gif"), monitorSplitPane, this._mediator.getStringResource("MONITOR_TIP"));
    }

    final void addConnectionsTab(ConnectionView connectionView) {
        this._tabbedPane.addTab(this._mediator.getStringResource("CONNECTIONS_TITLE"), this._mediator.getImageResource("connections.gif"), connectionView, this._mediator.getStringResource("CONNECTIONS_TIP"));
    }

    final void addCommunityTab(CommunityView communityView) {
        this._tabbedPane.addTab(this._mediator.getStringResource("COMMUNITY_TITLE"), this._mediator.getImageResource("groups.gif"), communityView, this._mediator.getStringResource("COMMUNITY_TIP"));
    }

    final void addLibraryTab(LibraryView libraryView) {
        this._tabbedPane.addTab(this._mediator.getStringResource("LIBRARY_TITLE"), this._mediator.getImageResource("library.gif"), libraryView, this._mediator.getStringResource("LIBRARY_TIP"));
    }

    final void addStatusLine(Component comp) {
        this._contentPane.add(comp);
    }

    final void addMenuBar(MenuBar mb) {
        this._menuBar = mb;
        this._frame.setJMenuBar(this._menuBar);
    }

    final boolean getAppVisible() {
        return this._frame.isShowing();
    }

    final void setAppVisible(boolean visible) {
        ((Component)this._frame).setVisible(visible);
    }

    final Dimension getAppSize() {
        return this._frame.getSize();
    }

    final Point getAppLocation() {
        return this._frame.getLocation();
    }

    final void setSelectedIndex(int index) {
        this._tabbedPane.setSelectedIndex(index);
    }

    final Frame getFrame() {
        return this._frame;
    }

    private final void setFrameDimensions() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = 0;
        int appHeight = 0;
        if (this._settings.getRunOnce()) {
            appWidth = this._settings.getAppWidth();
            appHeight = this._settings.getAppHeight();
            ((Component)this._frame).setLocation(this._settings.getWindowX(), this._settings.getWindowY());
        } else {
            appWidth = Math.min(screenSize.width, 700);
            appHeight = Math.min(screenSize.height - 40, 600);
            ((Component)this._frame).setLocation((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
        }
        ((Component)this._frame).setSize(new Dimension(appWidth, appHeight));
    }
}

