/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MenuBar
extends JMenuBar {
    private GUIMediator _mediator = GUIMediator.instance();
    private JMenu _fileMenu = new JMenu("File");
    private JMenu _navigationMenu = new JMenu("Navigation");
    private JMenu _toolsMenu = new JMenu("Tools");
    private HelpMenu _helpMenu = new HelpMenu();
    private JMenuItem _addFolder;
    private JMenuItem _newFolder;
    private JMenuItem _deleteFolder;
    private JMenuItem _rename;
    private JMenuItem _exit;
    private JMenuItem _connectToGroup;
    private JMenuItem _logoutGroup;
    private JMenuItem _deleteFile;
    private JMenuItem _launchFile;
    private JMenuItem _refresh;

    public MenuBar() {
        this._fileMenu.setMnemonic(70);
        this._navigationMenu.setMnemonic(78);
        this._toolsMenu.setMnemonic(84);
        this._helpMenu.setMnemonic(72);
        this._addFolder = new JMenuItem("Add Folder to Share", 65);
        this._newFolder = new JMenuItem("New Folder", 78);
        this._deleteFolder = new JMenuItem("Delete Folder", 68);
        this._rename = new JMenuItem("Rename Folder", 82);
        this._launchFile = new JMenuItem("Launch File(s)", 76);
        this._deleteFile = new JMenuItem("Delete File(s)", 69);
        this._refresh = new JMenuItem("Refresh", 83);
        this._newFolder.getAccessibleContext().setAccessibleDescription("Add a folder that you would like to share");
        this._newFolder.getAccessibleContext().setAccessibleDescription("Add a folder to the selected library folder");
        this._deleteFolder.getAccessibleContext().setAccessibleDescription("Delete the selected library folder");
        this._rename.getAccessibleContext().setAccessibleDescription("Rename the selected library folder");
        this._launchFile.getAccessibleContext().setAccessibleDescription("Launch the selected file(s)");
        this._deleteFile.getAccessibleContext().setAccessibleDescription("Delete the selected file(s)");
        this._refresh.getAccessibleContext().setAccessibleDescription("Reload the library");
        this._addFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.addSharedLibraryFolder();
            }
        });
        this._newFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.addNewLibraryFolder();
            }
        });
        this._deleteFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.deleteLibraryFolder();
            }
        });
        this._rename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.renameLibraryFolder();
            }
        });
        this._launchFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.launchLibraryFile();
            }
        });
        this._deleteFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.deleteLibraryFile();
            }
        });
        this._refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.refreshLibrary();
            }
        });
        this._connectToGroup = new JMenuItem("Connect to Group", 67);
        this._connectToGroup.getAccessibleContext().setAccessibleDescription("Connect to the selected group");
        this._connectToGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.connectToGroup();
            }
        });
        this._logoutGroup = new JMenuItem("Logout from Current Group", 76);
        this._logoutGroup.getAccessibleContext().setAccessibleDescription("Logout from your current group");
        this._logoutGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.logoutGroup();
            }
        });
        this._exit = new JMenuItem("Exit", 88);
        this._exit.getAccessibleContext().setAccessibleDescription("Exit the program");
        this._exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.shutdown();
            }
        });
        this._fileMenu.add(this._exit);
        JMenuItem menuItem = new JMenuItem("Search", 83);
        menuItem.getAccessibleContext().setAccessibleDescription("Display the search screen");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.setWindow(0);
            }
        });
        this._navigationMenu.add(menuItem);
        menuItem = new JMenuItem("Monitor", 77);
        menuItem.getAccessibleContext().setAccessibleDescription("Display the monitor screen");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.setWindow(1);
            }
        });
        this._navigationMenu.add(menuItem);
        menuItem = new JMenuItem("Connections", 67);
        menuItem.getAccessibleContext().setAccessibleDescription("Display the connections screen");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.setWindow(2);
            }
        });
        this._navigationMenu.add(menuItem);
        menuItem = new JMenuItem("Community", 78);
        String comString = "Display the community screen";
        menuItem.getAccessibleContext().setAccessibleDescription(comString);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.setWindow(3);
            }
        });
        this._navigationMenu.add(menuItem);
        menuItem = new JMenuItem("Library", 76);
        String libString = "Display the library screen";
        menuItem.getAccessibleContext().setAccessibleDescription(libString);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.setWindow(4);
            }
        });
        this._navigationMenu.add(menuItem);
        menuItem = new JMenuItem("Statistics", 83);
        menuItem.getAccessibleContext().setAccessibleDescription("Display the statistics screen");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.showStatsView();
            }
        });
        this._toolsMenu.add(menuItem);
        menuItem = new JMenuItem("Options...", 79);
        menuItem.getAccessibleContext().setAccessibleDescription("Display the configuration screen");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBar.this._mediator.showConfigView();
            }
        });
        this._toolsMenu.add(menuItem);
        this.add(this._fileMenu);
        this.add(this._navigationMenu);
        this.add(this._toolsMenu);
        this.add(this._helpMenu);
    }

    void showAboutWindow() {
        this._helpMenu.showAboutWindow();
    }

    void handleLibrarySelection() {
        this._fileMenu.removeAll();
        this._fileMenu.add(this._addFolder);
        this._fileMenu.add(this._newFolder);
        this._fileMenu.add(this._rename);
        this._fileMenu.add(this._deleteFolder);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._launchFile);
        this._fileMenu.add(this._deleteFile);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._refresh);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._exit);
    }

    void handleCommunitySelection() {
        this._fileMenu.removeAll();
        this._fileMenu.add(this._connectToGroup);
        this._fileMenu.add(this._logoutGroup);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._exit);
    }

    void handleStandardSelection() {
        if (this._fileMenu.getItemCount() > 1) {
            this._fileMenu.removeAll();
            this._fileMenu.add(this._exit);
        }
    }

    private class HelpMenu
    extends JMenu {
        private ImageIcon _icon = null;
        private HelpListener _helpListener;
        private FAQListener _faqListener;
        private AboutListener _aboutListener;

        public HelpMenu() {
            super("Help");
            this.getAccessibleContext().setAccessibleDescription("Bring up help menu");
            this._icon = MenuBar.this._mediator.getImageResource("notsearching.gif");
            JMenuItem help = new JMenuItem("Using LimeWire", 85);
            JMenuItem faq = new JMenuItem("FAQ", 70);
            JMenuItem about = new JMenuItem("About", 65);
            this._helpListener = new HelpListener();
            this._faqListener = new FAQListener();
            this._aboutListener = new AboutListener();
            help.addActionListener(this._helpListener);
            faq.addActionListener(this._faqListener);
            about.addActionListener(this._aboutListener);
            this.add(help);
            this.add(faq);
            this.addSeparator();
            this.add(about);
        }

        public void showAboutWindow() {
            this._aboutListener.showWindow();
        }

        private class AboutListener
        implements ActionListener {
            private MultiLineLabel _text;

            public AboutListener() {
                String version = CommonUtils.getLimeWireVersion();
                String label = "LimeWire Client v. " + version + " \n" + "www.limewire.com\n\nCopyright @2000, 2001 Lime Wire LLC";
                this._text = new MultiLineLabel(label);
                this._text.setFont(new Font("Sans Serif", 0, 11));
                this._text.setForeground(Color.black);
            }

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, this._text, "About LimeWire", 1, HelpMenu.this._icon);
            }

            public void showWindow() {
                JOptionPane.showMessageDialog(null, this._text, "About LimeWire", 1, HelpMenu.this._icon);
            }
        }

        private class FAQListener
        implements ActionListener {
            private FAQListener() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    String url = "http://www.limewire.com/support/faq.htm";
                    GUIMediator.instance().openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_FAQ";
                    GUIMediator.instance().showError(msgKey);
                }
            }
        }

        private class HelpListener
        implements ActionListener {
            private HelpListener() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    String url = "http://www.limewire.com/support.htm";
                    GUIMediator.instance().openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_SUPPORT";
                    GUIMediator.instance().showError(msgKey);
                }
            }
        }
    }
}

