/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

final class MessageService {
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    private MultiLineLabel _label;
    private FontMetrics _fontMetrics;
    private Dimension _labelDimension;
    private Frame _parent;

    MessageService() {
        this(null);
    }

    MessageService(Frame parent) {
        this._parent = parent;
        this._label = new MultiLineLabel("");
        this._fontMetrics = ((Component)this._label).getFontMetrics(this._label.getFont());
        this._labelDimension = new Dimension(Integer.MAX_VALUE, 90);
    }

    final void setParent(Frame parent) {
        this._parent = parent;
    }

    final void showError(String message) {
        this._label.setText(message);
        JOptionPane.showMessageDialog(this._parent, this._label, "Error", 0);
    }

    final void showMessage(String message) {
        this._label.setText(message);
        JOptionPane.showMessageDialog(this._parent, this._label, "Message", 1);
    }

    final void showConfirmMessage(String message) {
        this._label.setText(message);
        JOptionPane.showConfirmDialog(this._parent, this._label, "Message", 1);
    }

    final int showYesNoMessage(String message) {
        this._label.setText(message);
        int option = JOptionPane.showConfirmDialog(this._parent, this._label, "Message", 0);
        if (option == 0) {
            return 101;
        }
        return 102;
    }

    final void showInternalError(String message, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("LimeWire version ");
        pw.println(CommonUtils.getLimeWireVersion());
        pw.print("Java version ");
        pw.print(CommonUtils.getJavaVersion());
        pw.print(" from ");
        pw.println(this.prop("java.vendor"));
        pw.print(CommonUtils.getOS());
        pw.print(" v. ");
        pw.print(this.prop("os.version"));
        pw.print(" on ");
        pw.println(this.prop("os.arch"));
        Runtime runtime = Runtime.getRuntime();
        pw.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        pw.println();
        t.printStackTrace(pw);
        pw.println();
        String curDir = CommonUtils.getCurrentDirectory();
        File propsFile = new File(curDir, "limewire.props");
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            fis.close();
            props.list(pw);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        pw.flush();
        this.displayError(message, sw.toString());
    }

    private final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    private final void displayError(String header, String problem) {
        final JDialog dialog = new JDialog(this._parent, "Error", true);
        JPanel component = new JPanel();
        component.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        component.setLayout(new BorderLayout());
        final JTextArea center = new JTextArea(problem);
        center.selectAll();
        center.copy();
        center.setColumns(50);
        center.setEditable(false);
        JScrollPane scroller = new JScrollPane(center);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        component.add((Component)scroller, "Center");
        MultiLineLabel north = new MultiLineLabel(header, 400);
        component.add((Component)north, "North");
        JPanel south = new JPanel();
        JButton copyButton = new JButton("Copy Selection");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                center.copy();
            }
        });
        JButton quitButton = new JButton("Ok");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        south.add(copyButton);
        south.add(quitButton);
        component.add((Component)south, "South");
        dialog.getContentPane().add(component);
        dialog.pack();
        ((Component)dialog).setVisible(true);
    }
}

