/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BufferListModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MonitorView
extends PaddedPanel {
    private int listSize;
    private JTextField showText;
    private JCheckBox monitorCheckBox;
    private JList listBox;
    private JScrollPane scrollPane;
    private boolean bypassCountChange = false;
    private BufferListModel model = new BufferListModel(32);

    public MonitorView() {
        super("Incoming Searches");
        this.listBox = new JList(this.model);
        this.listBox.setFont(new Font("Dialog", 0, 12));
        this.listBox.setPrototypeCellValue("                                      ");
        this.listBox.setFixedCellHeight(16);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.monitorCheckBox = new JCheckBox("Enable");
        controlPanel.add(this.monitorCheckBox);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(new JLabel("Show last"));
        this.showText = new WholeNumberField(32, 3);
        Dimension d = new Dimension(10, 20);
        this.showText.setPreferredSize(d);
        this.showText.setMaximumSize(d);
        this.listSize = 32;
        controlPanel.add(this.showText);
        controlPanel.add(new JLabel("searches"));
        this.scrollPane = new JScrollPane(this.listBox);
        this.scrollPane.setPreferredSize(new Dimension(340, 180));
        this.add(controlPanel);
        this.add(this.scrollPane);
        this.showText.getDocument().addDocumentListener(new CountDocumentListener());
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = MonitorView.this.listBox.locationToIndex(e.getPoint());
                    String str = (String)MonitorView.this.model.getElementAt(index);
                    MonitorView.this.triggerSearch(str);
                }
            }
        };
        this.listBox.addMouseListener(mouseListener);
    }

    private void triggerSearch(String str) {
        GUIMediator.instance().triggerSearch(str);
    }

    private void setShowCount(String count) {
        this.bypassCountChange = true;
        this.showText.setText(count);
        this.bypassCountChange = false;
    }

    private void handleCountChange() {
        if (this.bypassCountChange) {
            return;
        }
        String val = this.showText.getText();
        if (val != null && !val.equals("")) {
            int size = Integer.parseInt(val);
            if (size > 10000) {
                this.listSize = 32;
                this.delayedSetText("32");
            } else {
                this.listSize = size;
            }
            this.model.changeSize(this.listSize);
            this.scrollPane.validate();
        }
    }

    private void delayedSetText(String val) {
        DelayedSetText doWorkRunnable = new DelayedSetText(val);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    private void doSearch() {
        String val = (String)this.listBox.getSelectedValue();
        if (val == null || val.equals("")) {
            return;
        }
    }

    private void clearAll() {
        this.model.removeAllElements();
        this.scrollPane.validate();
    }

    public void handleQueryString(String query) {
        if (this.monitorCheckBox.isSelected()) {
            if (query.length() == 0) {
                return;
            }
            char c = query.charAt(query.length() - 1);
            if (Character.isISOControl(c) || !Character.isDefined(c)) {
                query = query.substring(0, query.length() - 1);
            }
            this.model.addFirst(query);
        }
    }

    private class DelayedSetText
    implements Runnable {
        String val;

        public DelayedSetText(String val) {
            this.val = val;
        }

        public void run() {
            MonitorView.this.setShowCount(this.val);
        }
    }

    private class CountDocumentListener
    implements DocumentListener {
        private CountDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            MonitorView.this.handleCountChange();
        }

        public void removeUpdate(DocumentEvent e) {
            MonitorView.this.handleCountChange();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

