/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final int DEFAULT_LABEL_WIDTH = 200;

    public MultiLineLabel(String s) {
        this.setText(s);
    }

    public MultiLineLabel(String s, int pixels) {
        this.setText(s, pixels);
    }

    public MultiLineLabel(String s, int pixels, int rows, int cols) {
        super(rows, cols);
        this.setText(s, pixels);
    }

    public void setText(String s, int pixels) {
        super.setText(this.createSizedString(s, pixels));
    }

    public void setText(String s) {
        super.setText(this.createSizedString(s, 200));
    }

    public void updateUI() {
        super.updateUI();
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    private String createSizedString(String message, int pixels) {
        String nstr = new String();
        if (message == null) {
            return null;
        }
        FontMetrics fm = ((Component)this).getFontMetrics(this.getFont());
        StringTokenizer st = new StringTokenizer(message);
        String curLine = new String();
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (fm.stringWidth(curLine + word) > pixels) {
                nstr = nstr + curLine + "\n";
                curLine = word + " ";
                continue;
            }
            curLine = curLine + word + " ";
        }
        if (curLine != null) {
            nstr = nstr + curLine;
        }
        return nstr;
    }
}

