/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.sun.java.util.collections.Hashtable;
import java.awt.Dimension;
import java.util.Dictionary;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class PreferencingPanel
extends TitledPaddedPanel {
    private SettingsManager settings = SettingsManager.instance();
    private WholeNumberField files;
    private JSlider allowed;

    public PreferencingPanel() {
        super("Connection Preferencing");
        JLabel defLabelA = new JLabel("Clients sharing fewer than ");
        this.files = new WholeNumberField(this.settings.getFreeloaderFiles(), 3);
        Dimension d = new Dimension(8, 20);
        this.files.setMinimumSize(d);
        this.files.setPreferredSize(d);
        this.files.setMaximumSize(d);
        JLabel defLabelB = new JLabel(" files are freeloaders");
        JPanel defPanel = new JPanel();
        defPanel.setLayout(new BoxLayout(defPanel, 0));
        defPanel.add(defLabelA);
        defPanel.add(this.files);
        defPanel.add(defLabelB);
        defPanel.add(Box.createHorizontalGlue());
        int MIN_VALUE = 10;
        int initialValue = Math.max(10, this.settings.getFreeloaderAllowed());
        this.allowed = new JSlider(10, 100, initialValue);
        Hashtable labels = new Hashtable();
        labels = new Hashtable();
        labels.put((Object)new Integer(10), (Object)new JLabel("Rarely"));
        labels.put((Object)new Integer(100), (Object)new JLabel("Always"));
        this.allowed.setLabelTable((Dictionary)labels);
        this.allowed.setPaintLabels(true);
        JLabel sliderLabel = new JLabel("Allow Freeloaders:  ");
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 0));
        sliderPanel.add(sliderLabel);
        sliderPanel.add(this.allowed);
        this.setLayout(new BoxLayout(this, 1));
        this.add(defPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(sliderPanel);
    }

    public void commit() {
        Assert.that(this.settings != null);
        Assert.that(this.files != null);
        Assert.that(this.allowed != null);
        try {
            this.settings.setFreeloaderFiles(this.files.getValue());
            this.settings.setFreeloaderAllowed(this.allowed.getValue());
        }
        catch (IllegalArgumentException e) {
            Assert.that(false);
        }
    }

    public void reset() {
        Assert.that(this.settings != null);
        Assert.that(this.files != null);
        Assert.that(this.allowed != null);
        this.files.setValue(this.settings.getFreeloaderFiles());
        this.allowed.setValue(this.settings.getFreeloaderAllowed());
    }
}

