/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ProgressBarHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ProgressBarRenderer
extends JProgressBar
implements TableCellRenderer {
    private Border selectedBorder_;
    private Border unselectedBorder_;

    public ProgressBarRenderer(JTable table) {
        this.setStringPainted(true);
        Font font = this.getFont();
        Font newFont = new Font(font.getName(), 1, 9);
        this.setFont(newFont);
        Color sc = table.getSelectionBackground();
        Color uc = table.getBackground();
        this.selectedBorder_ = BorderFactory.createMatteBorder(2, 5, 2, 5, sc);
        this.unselectedBorder_ = BorderFactory.createMatteBorder(2, 5, 2, 5, uc);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        int v = ((ProgressBarHolder)value).getValue();
        String s = Integer.toString(v) + "%";
        this.setValue(v);
        this.setString(s);
        if (isSel) {
            this.setBorder(this.selectedBorder_);
        } else {
            this.setBorder(this.unselectedBorder_);
        }
        return this;
    }
}

