/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.sun.java.util.collections.Vector;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class QuickConnectPanels {
    private static SettingsManager settings = SettingsManager.instance();

    private static class CheckBoxListener
    implements ItemListener {
        private JCheckBox checkBox;

        CheckBoxListener(JCheckBox checkBox) {
            this.checkBox = checkBox;
        }

        public void itemStateChanged(ItemEvent e) {
            settings.setUseQuickConnect(this.checkBox.isSelected());
        }
    }

    public static class QCCheckPanel
    extends JPanel {
        private JCheckBox checkBox = new JCheckBox("Prefer AutoConnect hosts instead of discovered hosts (recommended)", QuickConnectPanels.access$000().getUseQuickConnect());

        public QCCheckPanel() {
            this.checkBox.addItemListener(new CheckBoxListener(this.checkBox));
            this.add(this.checkBox);
        }
    }

    private static class ListEditorListener
    implements ListDataListener {
        private Vector model;

        public void contentsChanged(ListDataEvent e) {
            this.update(e);
        }

        public void intervalAdded(ListDataEvent e) {
            this.update(e);
        }

        public void intervalRemoved(ListDataEvent e) {
            this.update(e);
        }

        ListEditorListener(Vector model) {
            this.model = model;
        }

        private String[] extract(Vector v) {
            Object[] ret = new String[v.size()];
            v.copyInto(ret);
            return ret;
        }

        private void update(ListDataEvent e) {
            settings.setQuickConnectHosts(this.extract(this.model));
        }
    }

    public static class QCEditor
    extends TitledPaddedPanel {
        private ListEditor editor;
        private Vector model;

        public QCEditor() {
            super("AutoConnect Hosts");
            this.setInnerLayout(new BorderLayout());
            this.model = new Vector();
            String[] hosts = settings.getQuickConnectHosts();
            int i = 0;
            while (i < hosts.length) {
                this.model.add((Object)hosts[i]);
                ++i;
            }
            this.editor = new ListEditor(this.model);
            this.editor.setAddTail(false);
            this.editor.addListDataListener(new ListEditorListener(this.model));
            this.add(this.editor);
        }
    }
}

