/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.LimeLookAndFeel;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;

final class ResourceManager {
    private static final ResourceManager INSTANCE = new ResourceManager();
    private static final LookAndFeel LOOK_AND_FEEL = new LimeLookAndFeel();
    private final String IMAGES_PREFIX = "com/limegroup/gnutella/gui/images/";
    private ResourceBundle _resourceBundle;

    static final ResourceManager instance() {
        return INSTANCE;
    }

    private ResourceManager() {
        SettingsManager settings = SettingsManager.instance();
        Locale locale = new Locale(settings.getLanguage(), settings.getCountry());
        this._resourceBundle = ResourceBundle.getBundle("MessagesBundle", locale);
    }

    final LookAndFeel getLookAndFeel() {
        return LOOK_AND_FEEL;
    }

    final ImageIcon getImageResource(String imageName) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL imageURL = null;
        if (cl == null) {
            imageURL = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/" + imageName);
            return new ImageIcon(imageURL);
        }
        imageURL = cl.getResource("com/limegroup/gnutella/gui/images/" + imageName);
        if (imageURL == null) {
            imageURL = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/" + imageName);
        }
        return new ImageIcon(imageURL);
    }

    final String getStringResource(String resourceKey) {
        return this._resourceBundle.getString(resourceKey);
    }
}

