/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import javax.swing.SwingUtilities;

public class SearchView
extends StandardSearchView {
    private static final int BUFFER_SIZE = 2000;
    private static final int MAX_RATE = 200;
    private static final int DELAY_TIME = 5;
    private static int PlatformSpecificNumRows = 3000;
    private LinkedList buffer = new LinkedList();
    private long lastTime;
    private static final int YES = 1;
    private static final int NO = 2;
    private static final int MAYBE = 3;

    public SearchView() {
        SearchViewRunner t = new SearchViewRunner();
        t.setDaemon(true);
        t.start();
    }

    public void handleQueryReply(QueryReply qr) {
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            this.parseQHD(qr);
            this.buffer.addLast((Object)qr);
            if (this.buffer.size() > 2000) {
                this.buffer.removeFirst();
            }
            this.buffer.notify();
        }
    }

    private boolean handleQueryReplyInternal(QueryReply qr) {
        int i = 0;
        ResultPanel rp = null;
        GUID rguid = new GUID(qr.getGUID());
        List list = this.entries;
        synchronized (list) {
            while (i < this.entries.size()) {
                rp = (ResultPanel)this.entries.get(i);
                if (rp.matches(rguid)) break;
                ++i;
            }
            if (i >= this.entries.size()) {
                boolean bl = false;
                return bl;
            }
        }
        byte[] clientGUID = qr.getClientGUID();
        byte[] replyGUID = qr.getGUID();
        Iterator iter = null;
        try {
            iter = qr.getResults();
        }
        catch (BadPacketException e) {
            return false;
        }
        TableLineGrouper grouper = rp.getGrouper();
        RouterService router = GUIMediator.instance().getRouter();
        SettingsManager settings = SettingsManager.instance();
        while (iter.hasNext()) {
            Response response = (Response)iter.next();
            if (rp.numResults() >= PlatformSpecificNumRows) {
                return false;
            }
            if (!router.matchesType(replyGUID, response) || router.isMandragoreWorm(replyGUID, response)) continue;
            long size = response.getSize();
            long index = response.getIndex();
            if (size > Integer.MAX_VALUE || index > Integer.MAX_VALUE) continue;
            int speed = ByteOrder.long2int(qr.getSpeed());
            boolean isMeasured = false;
            try {
                isMeasured = qr.getIsMeasuredSpeed();
            }
            catch (BadPacketException e) {
                // empty catch block
            }
            boolean chatEnabled = false;
            try {
                chatEnabled = qr.getSupportsChat();
            }
            catch (BadPacketException e) {
                // empty catch block
            }
            int score = router.score(replyGUID, response);
            int quality = this.calculateQualityOfService(qr);
            if (quality < settings.getMinimumSearchQuality() || speed < settings.getMinimumSearchSpeed()) continue;
            final TableLine line = new TableLine(response.getName(), new Integer((int)size), new Integer(speed), new Integer(score), qr.getIP(), new Integer(qr.getPort()), clientGUID, new Integer((int)index), new QualityHolder(quality), isMeasured, chatEnabled);
            final TableLine group = grouper.match(line);
            if (group == null) {
                grouper.add(line);
            }
            final int copyOfI = i;
            final ResultPanel copyOfRP = rp;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchView.this.addQueryReply(line, group, copyOfRP, copyOfI);
                }
            });
        }
        return true;
    }

    private void parseQHD(QueryReply qr) {
        this.parseBusy(qr);
        this.parseIncoming(qr);
    }

    private int parseBusy(QueryReply qr) {
        boolean b;
        try {
            b = qr.getIsBusy();
        }
        catch (BadPacketException bad) {
            return 3;
        }
        if (b) {
            return 1;
        }
        return 2;
    }

    private int parseIncoming(QueryReply qr) {
        boolean b;
        try {
            b = qr.getNeedsPush();
        }
        catch (BadPacketException bad) {
            return 3;
        }
        if (b) {
            return 1;
        }
        return 2;
    }

    private int calculateQualityOfService(QueryReply qr) {
        boolean iFirewalled;
        int push;
        int busy;
        Endpoint ep = new Endpoint(qr.getIP(), qr.getPort());
        try {
            busy = qr.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException e) {
            busy = 0;
        }
        if (ep.isPrivateAddress()) {
            push = 1;
        } else {
            try {
                push = qr.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException e) {
                push = 0;
            }
        }
        boolean bl = iFirewalled = !GUIMediator.instance().getRouter().acceptedIncomingConnection();
        if (push == -1 && busy == -1) {
            return 3;
        }
        if (busy == 1) {
            return 0;
        }
        if (iFirewalled && push == 1) {
            return 0;
        }
        if (!iFirewalled && busy == -1) {
            return 2;
        }
        return 1;
    }

    static {
        if (CommonUtils.isMacClassic()) {
            PlatformSpecificNumRows = 1000;
        }
    }

    private class SearchViewRunner
    extends Thread {
        private SearchViewRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                boolean displayed;
                QueryReply qr = null;
                LinkedList linkedList = SearchView.this.buffer;
                synchronized (linkedList) {
                    while (SearchView.this.buffer.isEmpty()) {
                        try {
                            SearchView.this.buffer.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    qr = (QueryReply)SearchView.this.buffer.removeLast();
                }
                long now = System.currentTimeMillis();
                long elapsed = now - SearchView.this.lastTime;
                long sleepTime = (long)(5 * qr.getResultCount()) - elapsed;
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!(displayed = SearchView.this.handleQueryReplyInternal(qr))) continue;
                SearchView.this.lastTime = System.currentTimeMillis();
            }
        }
    }
}

