/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsView
extends JDialog {
    private final String STATS_TITLE = "STATS_TITLE";
    private final int STATISTICS_WIDTH = 420;
    private final int STATISTICS_HEIGHT = 170;
    private JPanel _netConnPanel;
    private JLabel _numConnLabel;
    private JLabel _numUploadLabel;
    private JLabel _numDownloadLabel;
    private JPanel _netStatPanel;
    private JPanel _statOnlyPanel;
    private JLabel _numHostsLabel;
    private JLabel _numFilesLabel;
    private JLabel _numKBLabel;
    private JButton _updateButton;
    private JPanel _netInfoPanel;
    private JLabel _numMessagesText;
    private JLabel _numSearchesText;
    private JLabel _numRoutingErrorText;
    private JLabel _numDroppedMsgsText;
    private JLabel _numDownloadText;
    private JLabel _numUploadText;
    private GUIMediator _mediator;
    private SettingsManager _settings;

    public StatisticsView() {
        super(GUIMediator.instance().getMainFrame());
        this.setTitle(GUIMediator.instance().getStringResource("STATS_TITLE"));
        this._mediator = GUIMediator.instance();
        this._settings = SettingsManager.instance();
        JPanel statsView = new JPanel();
        statsView.setLayout(new BoxLayout(statsView, 0));
        this.createConnStats();
        statsView.add(this._netConnPanel);
        this.createNetStats();
        statsView.add(this._netStatPanel);
        this.createNetInfo();
        statsView.add(this._netInfoPanel);
        this.getContentPane().add(statsView);
        ((Component)this).setSize(420, 170);
    }

    public void updateStatistics() {
        int numTot = this._mediator.getRouter().getTotalMessages();
        int numLocalSearch = this._mediator.getRouter().getNumLocalSearches();
        int totDropped = this._mediator.getRouter().getTotalDroppedMessages();
        int totRouteError = this._mediator.getRouter().getTotalRouteErrors();
        int numConn = this._mediator.getRouter().getNumConnections();
        int numHosts = (int)this._mediator.getRouter().getNumHosts();
        long numFiles = this._mediator.getRouter().getNumFiles();
        long totSize = this._mediator.getRouter().getTotalFileSize();
        int sharedFiles = this._mediator.getRouter().getNumSharedFiles();
        int totUploads = this._mediator.getTotalUploads();
        int currUploads = this._mediator.getCurrentUploads();
        int totDownloads = this._mediator.getTotalDownloads();
        int currDownloads = this._mediator.getCurrentDownloads();
        String fileString = null;
        fileString = totSize > 9999L ? totSize / 1024L + " MB" : totSize + " KB";
        this._numMessagesText.setText(String.valueOf(numTot));
        this._numSearchesText.setText(String.valueOf(numLocalSearch));
        this._numRoutingErrorText.setText(String.valueOf(totRouteError));
        this._numDroppedMsgsText.setText(String.valueOf(totDropped));
        this._numDownloadText.setText(String.valueOf(totDownloads));
        this._numUploadText.setText(String.valueOf(totUploads));
        this._numConnLabel.setText(String.valueOf(numConn) + " net");
        this._numUploadLabel.setText(String.valueOf(currUploads) + " uploads      ");
        this._numDownloadLabel.setText(String.valueOf(currDownloads) + " downloads    ");
        this._numHostsLabel.setText(String.valueOf(numHosts + 1) + " hosts");
        this._numFilesLabel.setText(String.valueOf(numFiles) + " files");
        this._numKBLabel.setText(fileString);
    }

    private void createConnStats() {
        this._netConnPanel = new JPanel();
        this._netConnPanel.setLayout(new BorderLayout());
        JPanel netConnPanelNorth = new JPanel();
        netConnPanelNorth.setLayout(new BoxLayout(netConnPanelNorth, 1));
        this._netConnPanel.setBorder(BorderFactory.createTitledBorder("Connections"));
        this._numConnLabel = new JLabel("0 net           ");
        this._numUploadLabel = new JLabel("0 uploads       ");
        this._numDownloadLabel = new JLabel("0 downloads     ");
        netConnPanelNorth.add(this._numConnLabel);
        netConnPanelNorth.add(this._numUploadLabel);
        netConnPanelNorth.add(this._numDownloadLabel);
        this._netConnPanel.add((Component)netConnPanelNorth, "North");
    }

    private void createNetStats() {
        this._netStatPanel = new JPanel();
        this._netStatPanel.setLayout(new BorderLayout());
        this._netStatPanel.setBorder(BorderFactory.createTitledBorder("Net Stats"));
        this._statOnlyPanel = new JPanel();
        this._statOnlyPanel.setLayout(new GridLayout(0, 1));
        this._numHostsLabel = new JLabel("1 hosts        ");
        this._numFilesLabel = new JLabel("0 files        ");
        this._numKBLabel = new JLabel("0 MB        ");
        this._updateButton = new JButton("Update");
        this._statOnlyPanel.add(this._numHostsLabel);
        this._statOnlyPanel.add(this._numFilesLabel);
        this._statOnlyPanel.add(this._numKBLabel);
        this._netStatPanel.add((Component)this._statOnlyPanel, "North");
        this._netStatPanel.add((Component)this._updateButton, "South");
        this._updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatisticsView.this._mediator.getRouter().updateHorizon();
            }
        });
    }

    private void createNetInfo() {
        this._netInfoPanel = new JPanel();
        this._netInfoPanel.setBorder(BorderFactory.createTitledBorder("Network Information"));
        this._netInfoPanel.setLayout(new BoxLayout(this._netInfoPanel, 0));
        String zero = "0       ";
        this._numMessagesText = new JLabel("0       ", 2);
        this._numSearchesText = new JLabel("0       ", 2);
        this._numRoutingErrorText = new JLabel("0       ", 2);
        this._numDroppedMsgsText = new JLabel("0       ", 2);
        this._numDownloadText = new JLabel("0       ", 2);
        this._numUploadText = new JLabel("0       ", 2);
        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        namePanel.add(new JLabel("Total messages"));
        namePanel.add(new JLabel("Local searches"));
        namePanel.add(new JLabel("Routing errors"));
        namePanel.add(new JLabel("Dropped messages    "));
        namePanel.add(new JLabel("Download count"));
        namePanel.add(new JLabel("Upload count"));
        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        fieldPanel.add(this._numMessagesText);
        fieldPanel.add(this._numSearchesText);
        fieldPanel.add(this._numRoutingErrorText);
        fieldPanel.add(this._numDroppedMsgsText);
        fieldPanel.add(this._numDownloadText);
        fieldPanel.add(this._numUploadText);
        this._netInfoPanel.add(namePanel);
        this._netInfoPanel.add(fieldPanel);
    }
}

