/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class StatusLine
extends JPanel {
    private JPanel switchedPanel;
    private CardLayout switcher;
    private JLabel horizonLabel;
    private JLabel sharingLabel;
    private ConnectionView connectionView;
    private GUIMediator mediator = GUIMediator.instance();
    private boolean labelAvailable = true;
    static final long[] VALUES = new long[]{1000000000000L, 1000000000L, 1000000L, 1000L};
    static final long[] BVALUES = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L};
    static final String[] SUFFIXES = new String[]{"T", "B", "M", "K"};
    static final String[] BSUFFIXES = new String[]{" TB", " GB", " MB", " KB"};

    public StatusLine() {
        this.setLayout(new BorderLayout());
        this.createConnectButtons();
        this.horizonLabel = new JLabel();
        this.horizonLabel.setHorizontalAlignment(0);
        this.horizonLabel.setToolTipText("The number of computers and files you can search, and the size of those files.");
        this.sharingLabel = new JLabel("           ");
        this.sharingLabel.setHorizontalAlignment(0);
        this.sharingLabel.setToolTipText("The number of files you are sharing.");
        this.setStatistics(0L, 0L, 0L, 0);
        this.setDisconnected();
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.horizonLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.sharingLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.horizonLabel, "West");
        centerPanel.add((Component)this.sharingLabel, "East");
        this.add((Component)this.switchedPanel, "West");
        this.add((Component)centerPanel, "Center");
    }

    private void createConnectButtons() {
        this.switchedPanel = new JPanel();
        this.switcher = new CardLayout();
        this.switchedPanel.setLayout(this.switcher);
        String prefix = "com/limegroup/gnutella/gui/images/";
        Dimension buttonSize = new Dimension(90, 21);
        JPanel connectedPanel = new JPanel();
        connectedPanel.setLayout(new FlowLayout(0));
        ImageIcon connectedIcon = this.mediator.getImageResource("connected.gif");
        JButton disconnectButton = new JButton("Disconnect");
        disconnectButton.setMargin(new Insets(0, 0, 0, 0));
        disconnectButton.setToolTipText("Disconnect from the Gnutella network");
        disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusLine.this.mediator.clearConnections();
                Thread disconnectThread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        StatusLine.access$000(1.access$100(this.this$1)).getRouter().disconnect();
                    }
                };
                disconnectThread.setDaemon(true);
                disconnectThread.start();
            }

            static /* synthetic */ StatusLine access$100(1 x0) {
                return x0.StatusLine.this;
            }
        });
        connectedPanel.add(new JLabel(connectedIcon));
        connectedPanel.add(disconnectButton);
        this.switchedPanel.add("connect", connectedPanel);
        JPanel disconnectedPanel = new JPanel();
        disconnectedPanel.setLayout(new FlowLayout(0));
        ImageIcon disconnectedIcon = this.mediator.getImageResource("disconnected.gif");
        JButton connectButton = new JButton(" Connect ");
        connectButton.setMargin(new Insets(0, 0, 0, 0));
        connectButton.setToolTipText("Connect to the Gnutella network");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusLine.this.mediator.getRouter().connect();
                SettingsManager settings = SettingsManager.instance();
                StatusLine.this.mediator.setKeepAliveText(String.valueOf(settings.getKeepAlive()));
            }
        });
        disconnectedPanel.add(new JLabel(disconnectedIcon));
        disconnectedPanel.add(connectButton);
        this.switchedPanel.add("disconnect", disconnectedPanel);
    }

    public void setConnected() {
        JPanel jPanel = this.switchedPanel;
        synchronized (jPanel) {
            this.switcher.first(this.switchedPanel);
        }
    }

    public void setDisconnected() {
        JPanel jPanel = this.switchedPanel;
        synchronized (jPanel) {
            this.switcher.last(this.switchedPanel);
        }
    }

    public void setStatistics(long hosts, long files, long kbytes, int share) {
        String txt = hosts == 0L ? "Disconnected / no files available" : StatusLine.suffix(hosts, false) + " hosts / " + StatusLine.suffix(files, false) + " files / " + StatusLine.suffix(kbytes * 1000L, true) + " available";
        JLabel jLabel = this.horizonLabel;
        synchronized (jLabel) {
            if (this.labelAvailable) {
                this.horizonLabel.setText(txt);
            }
        }
        this.sharingLabel.setText("Sharing " + String.valueOf(share) + " files");
        if (share == 0) {
            this.sharingLabel.setForeground(new Color(208, 0, 5));
        } else {
            this.sharingLabel.setForeground((Color)UIManager.get("Label.foreground"));
        }
    }

    public void setStatus(String status, boolean labelLock) {
        JLabel jLabel = this.horizonLabel;
        synchronized (jLabel) {
            if (status != null) {
                this.horizonLabel.setText(status);
            }
            this.labelAvailable = !labelLock;
        }
    }

    private static String suffix(long n, boolean isBytes) {
        String[] suffixes;
        long[] values = isBytes ? BVALUES : VALUES;
        String[] stringArray = suffixes = isBytes ? BSUFFIXES : SUFFIXES;
        if (n < values[values.length - 1]) {
            return isBytes ? n + " bytes" : n + "";
        }
        int i = values.length - 1;
        while (i >= 0) {
            if (n < values[i]) break;
            --i;
        }
        Assert.that(++i >= 0);
        Assert.that(n >= values[i]);
        if (i > 0) {
            Assert.that(n < values[i - 1]);
        }
        return n / values[i] + suffixes[i];
    }
}

