/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class SystemTrayDialog {
    private final int MARGIN = 6;
    private final int TRAY_DIALOG_WIDTH = 340;
    private final int TRAY_DIALOG_HEIGHT = 200;
    private JDialog _dialog;
    private Frame _frame = GUIMediator.instance().getMainFrame();
    private SettingsManager _settings = SettingsManager.instance();
    private JCheckBox _checkBox;
    private JRadioButton _yesRadioButton;
    private JRadioButton _noRadioButton;

    public SystemTrayDialog() {
        this._dialog = new JDialog(this._frame, "System Tray", true);
        Container container = this._dialog.getContentPane();
        BoxLayout dialogLayout = new BoxLayout(container, 1);
        container.setLayout(dialogLayout);
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        Dimension dim = new Dimension(340, 200);
        mainPanel.setPreferredSize(dim);
        Border border = BorderFactory.createEmptyBorder(12, 6, 6, 6);
        mainPanel.setBorder(border);
        String msg = "Would you like LimeWire to continue running in the system tray?";
        int labelWidth = 328;
        MultiLineLabel label = new MultiLineLabel(msg, labelWidth);
        JPanel labelPanel = new JPanel();
        labelPanel.add(label);
        Dimension labelDim = new Dimension(labelWidth, 40);
        labelPanel.setPreferredSize(labelDim);
        labelPanel.setMaximumSize(labelDim);
        RadioButtonPanel buttonPanel = new RadioButtonPanel();
        CheckBoxPanel checkBoxPanel = new CheckBoxPanel();
        String[] buttonLabelKeys = new String[]{"SYSTEM_TRAY_OK_BUTTON_LABEL", "SYSTEM_TRAY_CANCEL_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"SYSTEM_TRAY_OK_BUTTON_TIP", "SYSTEM_TRAY_CANCEL_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{new OKListener(), new CancelListener()};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, toolTipKeys, buttonListeners, 0, 14);
        mainPanel.add(labelPanel);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(6));
        mainPanel.add(checkBoxPanel);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(buttons);
        this._dialog.getContentPane().add(mainPanel);
        this._dialog.pack();
    }

    public void showDialog() {
        this._dialog.setLocationRelativeTo(this._frame);
        ((Component)this._dialog).setVisible(true);
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Component)SystemTrayDialog.this._dialog).setVisible(false);
        }
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SystemTrayDialog.this._settings.setShowTrayDialog(!SystemTrayDialog.this._checkBox.isSelected());
            SystemTrayDialog.this._settings.setMinimizeToTray(SystemTrayDialog.this._yesRadioButton.isSelected());
            if (SystemTrayDialog.this._yesRadioButton.isSelected()) {
                ((Component)SystemTrayDialog.this._dialog).setVisible(false);
                GUIMediator.instance().goToTray();
            } else {
                Initializer.instance().shutdown();
            }
        }
    }

    private class CheckBoxPanel
    extends JPanel {
        private CheckBoxPanel() {
            BoxLayout layout = new BoxLayout(this, 0);
            this.setLayout(layout);
            JPanel checkBoxPanel = new JPanel();
            BoxLayout checkBoxLayout = new BoxLayout(checkBoxPanel, 1);
            checkBoxPanel.setLayout(checkBoxLayout);
            String checkBoxLabel = "Always do this without asking again.";
            SystemTrayDialog.this._checkBox = new JCheckBox(checkBoxLabel);
            checkBoxPanel.add(SystemTrayDialog.this._checkBox);
            this.add(Box.createHorizontalGlue());
            this.add(checkBoxPanel);
            this.add(Box.createHorizontalGlue());
        }
    }

    private class RadioButtonPanel
    extends JPanel {
        private RadioButtonPanel() {
            BoxLayout layout = new BoxLayout(this, 0);
            this.setLayout(layout);
            JPanel radioButtonPanel = new JPanel();
            BoxLayout radioButtonLayout = new BoxLayout(radioButtonPanel, 1);
            radioButtonPanel.setLayout(radioButtonLayout);
            String yesLabel = "Yes, put LimeWire in the system tray.";
            String noLabel = "No, close the program and abort file transfers.";
            SystemTrayDialog.this._yesRadioButton = new JRadioButton(yesLabel);
            SystemTrayDialog.this._noRadioButton = new JRadioButton(noLabel);
            SystemTrayDialog.this._yesRadioButton.setSelected(SystemTrayDialog.this._settings.getMinimizeToTray());
            SystemTrayDialog.this._noRadioButton.setSelected(!SystemTrayDialog.this._settings.getMinimizeToTray());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(SystemTrayDialog.this._yesRadioButton);
            buttonGroup.add(SystemTrayDialog.this._noRadioButton);
            radioButtonPanel.add(SystemTrayDialog.this._yesRadioButton);
            radioButtonPanel.add(SystemTrayDialog.this._noRadioButton);
            this.add(Box.createHorizontalGlue());
            this.add(radioButtonPanel);
            this.add(Box.createHorizontalGlue());
        }
    }
}

