/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgressBarHolder;
import com.limegroup.gnutella.gui.ProgressBarRenderer;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class UploadView
extends PaddedPanel {
    public static final int FILE = 0;
    public static final int HOST = 1;
    public static final int SIZE = 2;
    public static final int STATUS = 3;
    public static final int BAR = 4;
    public static final int SPEED = 5;
    public static final int NUMBER_OF_COLUMNS = 6;
    private AbstractTableModel _dataModel;
    private JTable _tableView;
    private JScrollPane _scrollpane;
    private JPanel _tablepane;
    private UploadList _list;
    private SettingsManager _settings = SettingsManager.instance();
    private int _totUploads;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ProgressBarHolder;

    UploadView() {
        super("Uploads");
        this.setLayout(new BoxLayout(this, 1));
        this._totUploads = 0;
        this._list = new UploadList();
        this._dataModel = new UploadTableModel();
        this._tableView = new JTable(this._dataModel);
        JMenuItem chatItem = new JMenuItem("Chat with Host");
        ChatListener chatListener = new ChatListener();
        chatItem.addActionListener(chatListener);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(chatItem);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int[] sel = UploadView.this._tableView.getSelectedRows();
                    int i = 0;
                    while (i < sel.length) {
                        Upload upload = UploadView.this._list.getUploadAt(i);
                        Uploader uploader = upload.getUploader();
                        if (uploader.chatEnabled()) {
                            popupMenu.show(UploadView.this._tableView, e.getX(), e.getY());
                        }
                        ++i;
                    }
                }
            }
        };
        this._tableView.addMouseListener(mouseListener);
        int height = this._tableView.getRowHeight();
        this._tableView.setRowHeight(height + 1);
        this._tableView.setShowGrid(false);
        this._scrollpane = new JScrollPane(this._tableView);
        this._tablepane = new JPanel();
        this._tablepane.setBackground(Color.white);
        this._scrollpane.getViewport().setBackground(Color.white);
        this._tablepane.setLayout(new BoxLayout(this._tablepane, 1));
        this._tablepane.add(this._scrollpane);
        JTableHeader th = this._tableView.getTableHeader();
        this._tableView.getColumnModel().getColumn(0).setPreferredWidth(180);
        this._tableView.getColumnModel().getColumn(1).setPreferredWidth(70);
        this._tableView.getColumnModel().getColumn(2).setPreferredWidth(70);
        this._tableView.getColumnModel().getColumn(3).setPreferredWidth(180);
        th.addMouseListener(new ColumnSorter());
        this.add(this._tablepane);
        this.setProgressBarRenderer();
        KillListener killListener = new KillListener();
        ClearListener clearListener = new ClearListener();
        String[] buttonLabelKeys = new String[]{"UPLOAD_KILL_BUTTON_LABEL", "UPLOAD_CLEAR_BUTTON_LABEL"};
        String[] buttonTipKeys = new String[]{"UPLOAD_KILL_BUTTON_TIP", "UPLOAD_CLEAR_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{killListener, clearListener};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonTipKeys, buttonListeners, 0, 14);
        this.add(buttons);
    }

    public void addConnection(Uploader up) {
        ++this._totUploads;
        this._list.addRow(up);
        this._dataModel.fireTableRowsInserted(0, 0);
    }

    public int getCurrentUploads() {
        return this._list.getCurrentNumUploads();
    }

    public int getTotalUploads() {
        return this._totUploads;
    }

    private void setProgressBarRenderer() {
        ProgressBarRenderer pRend = new ProgressBarRenderer(this._tableView);
        this._tableView.setDefaultRenderer(class$com$limegroup$gnutella$gui$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$ProgressBarHolder = UploadView.class$("com.limegroup.gnutella.gui.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$ProgressBarHolder, pRend);
    }

    public void removeConnection(Uploader client) {
        int state = client.getState();
        if (this._settings.getClearCompletedUpload() && (state == 4 || state == 6 || state == 2 || state == 5 || state == 7 || state == 1)) {
            this._list.removeConnection(client);
        }
        this._dataModel.fireTableDataChanged();
    }

    public void updateConnectionStats() {
        this._list.updateConnectionStats();
    }

    public void sort(int col) {
        this._list.sort(col);
        this._dataModel.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UploadComp
    implements Comparator {
        private int col_;
        private int mode_;
        private final int ASCENDING = 0;

        public UploadComp(int col, int mode) {
            this.col_ = col;
            this.mode_ = mode;
        }

        public int compare(Object a, Object b) {
            int toReturn = 0;
            Upload ua = (Upload)a;
            Upload ub = (Upload)b;
            switch (this.col_) {
                case 0: 
                case 1: 
                case 3: {
                    String value1 = (String)ua.getAt(this.col_);
                    String value2 = (String)ub.getAt(this.col_);
                    if (this.mode_ == 0) {
                        toReturn = value2.compareTo(value1);
                        break;
                    }
                    toReturn = value1.compareTo(value2);
                    break;
                }
                case 4: {
                    ProgressBarHolder ph1 = (ProgressBarHolder)ua.getAt(this.col_);
                    ProgressBarHolder ph2 = (ProgressBarHolder)ub.getAt(this.col_);
                    int inta = ph1.getValue();
                    int intb = ph2.getValue();
                    if (this.mode_ == 0) {
                        toReturn = -(inta - intb);
                        break;
                    }
                    toReturn = inta - intb;
                    break;
                }
                case 2: {
                    SizeHolder holder1 = (SizeHolder)ua.getAt(this.col_);
                    SizeHolder holder2 = (SizeHolder)ub.getAt(this.col_);
                    int sizea = holder1.getSize();
                    int sizeb = holder2.getSize();
                    if (this.mode_ == 0) {
                        toReturn = -(sizea - sizeb);
                        break;
                    }
                    toReturn = sizea - sizeb;
                    break;
                }
            }
            return toReturn;
        }
    }

    private class ColumnSorter
    extends MouseAdapter {
        private ColumnSorter() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = UploadView.this._tableView.getColumnModel();
            int col = columnModel.getColumnIndexAtX(e.getX());
            int c = UploadView.this._tableView.convertColumnIndexToModel(col);
            if (e.getClickCount() == 1 && c != -1) {
                UploadView.this.sort(c);
            }
        }
    }

    private class Upload {
        private Uploader _uploader;
        private String _fileName;
        private String _hostName;
        private String _status;
        private ProgressBarHolder _progressBar;
        private int _currentSize;
        private int _priorSize;
        private String _rate;
        private SizeHolder _size;

        public Upload(Uploader up) {
            this._uploader = up;
            this._fileName = up.getFileName();
            this._hostName = up.getHost();
            this._progressBar = new ProgressBarHolder();
            this._currentSize = 0;
            this._status = this.getStatus();
            this._size = new SizeHolder(up.getFileSize());
            this._rate = this.rateToString(this.getRate());
        }

        public int getState() {
            return this._uploader.getState();
        }

        public Uploader getUploader() {
            return this._uploader;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getHostName() {
            return this._hostName;
        }

        public int getFileSize() {
            return this._size.getSize();
        }

        public int getCurrentSize() {
            return this._currentSize;
        }

        public ProgressBarHolder getProgressBar() {
            return this._progressBar;
        }

        public String getSpeed() {
            return this._rate;
        }

        private String rateToString(double rate) {
            return String.valueOf(rate) + "KB/s";
        }

        public Object getAt(int i) {
            switch (i) {
                case 0: {
                    return this._fileName;
                }
                case 1: {
                    return this._hostName;
                }
                case 3: {
                    return this.getStatus();
                }
                case 4: {
                    return this._progressBar;
                }
                case 2: {
                    return this._size;
                }
                case 5: {
                    double r = this.getRate();
                    this._rate = this.rateToString(this.getRate());
                    return this._rate;
                }
            }
            return new String("");
        }

        public void setAt(int i, Object obj) {
            switch (i) {
                case 0: {
                    this._fileName = (String)obj;
                    break;
                }
                case 1: {
                    this._hostName = (String)obj;
                    break;
                }
                case 3: {
                    this._status = (String)obj;
                    break;
                }
                case 4: {
                    this._progressBar = (ProgressBarHolder)obj;
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    this._rate = (String)obj;
                }
            }
        }

        public String getStatus() {
            int state = this._uploader.getState();
            switch (state) {
                case 0: {
                    this._status = "Connecting";
                    break;
                }
                case 3: {
                    this._status = "Uploading";
                    break;
                }
                case 2: {
                    this._status = "Upload Limit Reached";
                    break;
                }
                case 1: {
                    this._status = "Freeloader Uploading";
                    break;
                }
                case 6: {
                    this._status = "Couldn't Connect";
                    break;
                }
                case 5: {
                    this._status = "Transfer Interrupted";
                    break;
                }
                case 4: {
                    this._status = "Complete";
                    break;
                }
                case 7: {
                    this._status = "File Not Found";
                    break;
                }
                default: {
                    Assert.that(false, "Internal error: upload in unknown state.");
                }
            }
            return this._status;
        }

        public void update() {
            this.setCurrentSize();
            this.setProgressValue(this.getPercent());
            this.getRate();
        }

        private double getRate() {
            if (this._uploader.getState() == 3) {
                double round = (this._currentSize - this._priorSize) * 10 / 2048;
                double rate = round / 10.0;
                return rate;
            }
            return 0.0;
        }

        private int getPercent() {
            double d = (double)this._currentSize / (double)this._size.getSize();
            int percent = (int)(d * 100.0);
            return percent;
        }

        private void setCurrentSize() {
            this._priorSize = this._currentSize;
            this._currentSize = this._uploader.amountUploaded();
        }

        private void setProgressValue(int p) {
            this._progressBar.setValue(p);
        }
    }

    private class SizeHolder {
        String _string;
        int _size;

        private SizeHolder(int size) {
            this._string = GUIUtils.toKilobytes(size);
            this._size = size;
        }

        public String toString() {
            return this._string;
        }

        private int getSize() {
            return this._size;
        }
    }

    private class UploadList {
        private ArrayList _list = new ArrayList();
        private boolean _ascending = false;

        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Host";
                }
                case 2: {
                    return "Size";
                }
                case 3: {
                    return "Status";
                }
                case 4: {
                    return "Progress";
                }
                case 5: {
                    return "Speed";
                }
            }
            return new String("");
        }

        public int getNumRows() {
            return this._list.size();
        }

        public int getNumColumns() {
            return 6;
        }

        public Object getAt(int row, int column) {
            Upload up = (Upload)this._list.get(row);
            return up.getAt(column);
        }

        public void setAt(int row, int column, Object obj) {
            Upload up = (Upload)this._list.get(row);
            up.setAt(column, obj);
        }

        public void removeConnection(Uploader c) {
            int i = 0;
            while (i < this._list.size()) {
                Upload up = (Upload)this._list.get(i);
                Uploader loader = up.getUploader();
                if (loader == c) {
                    this.removeRow(i);
                    break;
                }
                ++i;
            }
        }

        public void removeRow(int row) {
            try {
                Upload up = (Upload)this._list.get(row);
                Uploader uploader = up.getUploader();
                uploader.stop();
                this._list.remove(row);
                UploadView.this._dataModel.fireTableRowsDeleted(row, row);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public void addRow(Uploader uploader) {
            if (this._list.contains((Object)uploader)) {
                return;
            }
            Upload up = new Upload(uploader);
            this._list.add(0, (Object)up);
        }

        public void updateConnectionStats() {
            int i = 0;
            while (i < this._list.size()) {
                Upload up = (Upload)this._list.get(i);
                up.update();
                UploadView.this._dataModel.fireTableRowsUpdated(i, i);
                ++i;
            }
        }

        public Upload getUploadAt(int index) {
            return (Upload)this._list.get(index);
        }

        public int getCurrentNumUploads() {
            int count = 0;
            int i = 0;
            while (i < this._list.size()) {
                Upload up = (Upload)this._list.get(i);
                if (up.getState() == 3) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public void clearCompleted() {
            int i = this._list.size() - 1;
            while (i >= 0) {
                Upload up = (Upload)this._list.get(i);
                int state = up.getState();
                if (state == 4 || state == 6 || state == 2 || state == 5 || state == 7 || state == 1) {
                    this._list.remove(i);
                }
                --i;
            }
        }

        public void sort(int row) {
            UploadComp comp;
            if (this._ascending) {
                comp = new UploadComp(row, 0);
                this._ascending = false;
            } else {
                comp = new UploadComp(row, 1);
                this._ascending = true;
            }
            Collections.sort((List)this._list, (Comparator)comp);
        }
    }

    private class UploadTableModel
    extends AbstractTableModel {
        private UploadTableModel() {
        }

        public int getColumnCount() {
            return UploadView.this._list.getNumColumns();
        }

        public int getRowCount() {
            return UploadView.this._list.getNumRows();
        }

        public Object getValueAt(int row, int col) {
            if (row >= UploadView.this._list.getNumRows() || col >= UploadView.this._list.getNumColumns()) {
                return new String("");
            }
            return UploadView.this._list.getAt(row, col);
        }

        public String getColumnName(int col) {
            return UploadView.this._list.getColumnName(col);
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (row >= UploadView.this._list.getNumRows()) {
                return;
            }
            UploadView.this._list.setAt(row, column, aValue);
            this.fireTableCellUpdated(row, column);
        }
    }

    private class ChatListener
    implements ActionListener {
        private ChatListener() {
        }

        public void actionPerformed(ActionEvent e) {
            RouterService backend = GUIMediator.instance().getRouter();
            int[] sel = UploadView.this._tableView.getSelectedRows();
            int i = sel.length - 1;
            while (i >= 0) {
                Upload upload = UploadView.this._list.getUploadAt(i);
                Uploader uploader = upload.getUploader();
                if (uploader.chatEnabled()) {
                    String host = uploader.getChatHost();
                    int port = uploader.getChatPort();
                    backend.createChat(host, port);
                }
                --i;
            }
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UploadView.this._list.clearCompleted();
            UploadView.this._dataModel.fireTableDataChanged();
        }
    }

    private class KillListener
    implements ActionListener {
        private KillListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = UploadView.this._tableView.getSelectedRows();
            int i = 0;
            while (i < sel.length) {
                UploadView.this._list.removeRow(sel[i]);
                ++i;
            }
            UploadView.this._dataModel.fireTableDataChanged();
        }
    }
}

