/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.DownloadView;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.SearchView;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.chat.ChatFactory;
import com.limegroup.gnutella.gui.library.LibraryView;
import com.sun.java.util.collections.Vector;
import java.io.File;
import javax.swing.SwingUtilities;

public class VisualConnectionCallback
implements ActivityCallback {
    private HandleQueryString _handleQueryString;
    private SearchView _searchView;
    private DownloadView _downloadView;
    private MonitorView _monitorView;
    private UploadView _uploadView;
    private ConnectionView _connectionView;
    private LibraryView _libraryView;
    private GUIMediator _mediator = GUIMediator.instance();

    VisualConnectionCallback() {
    }

    void initialize() {
        this._handleQueryString = new HandleQueryString();
        this._searchView = this._mediator.getSearchView();
        this._downloadView = this._mediator.getDownloadView();
        this._monitorView = this._mediator.getMonitorView();
        this._uploadView = this._mediator.getUploadView();
        this._connectionView = this._mediator.getConnectionView();
        this._libraryView = this._mediator.getLibraryView();
    }

    public void connectionInitializing(Connection c) {
        ConnectionInitializing doWorkRunnable = new ConnectionInitializing(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionInitialized(Connection c) {
        ConnectionInitialized doWorkRunnable = new ConnectionInitialized(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionClosed(Connection c) {
        ConnectionClosed doWorkRunnable = new ConnectionClosed(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void knownHost(Endpoint e) {
        KnownHost doWorkRunnable = new KnownHost(e);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void handleQueryReply(QueryReply qr) {
        this._searchView.handleQueryReply(qr);
    }

    public void handleQueryString(String query) {
        this._handleQueryString.addQueryString(query);
    }

    public void addSharedDirectory(final File dir, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this._libraryView.addSharedDirectory(dir, parent);
            }
        });
    }

    public void addSharedFile(final File file, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this._libraryView.addSharedFile(file, parent);
            }
        });
    }

    public void clearSharedFiles() {
        this._libraryView.clearLibrary();
    }

    public void error(int message) {
        Error doWorkRunnable = new Error(message, null);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void error(int message, Throwable problem) {
        Error doWorkRunnable = new Error(message, problem);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void error(Throwable problem) {
        Error doWorkRunnable = new Error(problem);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void addDownload(Downloader mgr) {
        AddDownload doWorkRunnable = new AddDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeDownload(Downloader mgr) {
        RemoveDownload doWorkRunnable = new RemoveDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void addUpload(Uploader mgr) {
        AddUpload doWorkRunnable = new AddUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeUpload(Uploader mgr) {
        RemoveUpload doWorkRunnable = new RemoveUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void acceptChat(Chatter chatter) {
        ChatFactory.instance().acceptChat(chatter);
    }

    public void receiveMessage(Chatter chatter) {
        ChatFactory.instance().recieveMessage(chatter);
    }

    public void chatUnavailable(Chatter chatter) {
        ChatFactory.instance().chatUnavailable(chatter);
    }

    public void chatErrorMessage(Chatter chatter, String str) {
        ChatFactory.instance().chatErrorMessage(chatter, str);
    }

    private class Error
    implements Runnable {
        private int message;
        private Throwable problem;

        public Error(int message, Throwable problem) {
            this.message = message;
            this.problem = problem;
        }

        private Error(Throwable problem) {
            this.problem = problem;
        }

        public void run() {
            String msgKey = null;
            switch (this.message) {
                case 0: {
                    msgKey = "ERROR_PORT";
                    break;
                }
                case 1: {
                    msgKey = "ERROR_INCOMING_CONNECTIONS";
                    break;
                }
                case 2: {
                    msgKey = "ERROR_INTERNAL";
                }
            }
            if (msgKey != null && this.problem == null) {
                VisualConnectionCallback.this._mediator.showError(msgKey);
            } else if (msgKey == null) {
                VisualConnectionCallback.this._mediator.showInternalError(this.problem);
            } else if (msgKey != null && this.problem != null) {
                VisualConnectionCallback.this._mediator.showInternalError(msgKey, this.problem);
            }
        }
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this._uploadView.removeConnection(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader up) {
            this.up = up;
        }

        public void run() {
            VisualConnectionCallback.this._uploadView.addConnection(this.up);
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this._downloadView.removeDownload(this.mgr);
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this._downloadView.addDownload(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String query) {
            this.list.add((Object)query);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String query = (String)this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this._monitorView.handleQueryString(query);
            }
            this.active = false;
        }
    }

    private class KnownHost
    implements Runnable {
        private Endpoint e;

        public KnownHost(Endpoint e) {
            this.e = e;
        }

        public void run() {
            VisualConnectionCallback.this._connectionView.addKnownHost(this.e);
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this._connectionView.removeConnection(this.c);
            if (VisualConnectionCallback.this._mediator.getRouter().getNumConnections() == 0) {
                VisualConnectionCallback.this._mediator.setDisconnected();
            }
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this._connectionView.renameConnection(this.c);
            VisualConnectionCallback.this._connectionView.updateConnection(this.c);
            VisualConnectionCallback.this._mediator.setConnected();
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this._connectionView.addConnection(this.c);
        }
    }
}

