/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Component;

public class ChatFactory {
    private static ChatFactory _factory = new ChatFactory();
    private Map _chats = Collections.synchronizedMap((Map)new HashMap());

    private ChatFactory() {
    }

    public static ChatFactory instance() {
        return _factory;
    }

    public void acceptChat(Chatter chatter) {
        ChatFrame cframe = new ChatFrame(chatter);
        ((Component)cframe).setVisible(true);
        this._chats.put((Object)chatter, (Object)cframe);
    }

    public void removeChat(Chatter chatter) {
        ChatFrame cframe = null;
        try {
            cframe = (ChatFrame)this._chats.remove((Object)chatter);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (cframe != null) {
            ((Component)cframe).setVisible(false);
        }
    }

    public void recieveMessage(Chatter chatter) {
        try {
            ChatFrame cframe = (ChatFrame)this._chats.get((Object)chatter);
            cframe.addResponse(chatter.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void chatUnavailable(Chatter chatter) {
        try {
            ChatFrame cframe = (ChatFrame)this._chats.get((Object)chatter);
            cframe.chatUnavailable();
        }
        catch (ClassCastException e) {
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
    }

    public void chatErrorMessage(Chatter chatter, String str) {
        try {
            ChatFrame cframe = (ChatFrame)this._chats.get((Object)chatter);
            cframe.displayErrorMessage(str);
        }
        catch (ClassCastException e) {
        }
        catch (NullPointerException ee) {
            // empty catch block
        }
    }
}

