/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.LimitedList;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class FileScan {
    private int MEM_WEIGHT = 1;
    private int NUM_WEIGHT = 1;
    private int MAX_DEPTH = 3;
    private String[] _extensions;
    private String[] _filters;
    private LimitedList _list = new LimitedList();

    public FileScan() {
        this._filters = new String[0];
        String exts = SettingsManager.instance().getExtensions();
        this._extensions = StringUtils.split(exts, ";");
    }

    public void setExtensions(String[] e) {
        this._extensions = e;
    }

    public void setFilters(String[] f) {
        this._filters = f;
    }

    public String[] getListAsArray() {
        Object[] objs = this._list.getAllElements();
        int len = objs.length;
        String[] files = new String[len];
        int i = 0;
        while (i < len) {
            if (objs[i] != null) {
                Pair p = (Pair)objs[i];
                File f = (File)p.getElement();
                try {
                    files[i] = f.getCanonicalPath();
                }
                catch (IOException ioe) {
                    files[i] = "";
                }
            }
            ++i;
        }
        return files;
    }

    public String getListAsString() {
        Object[] objs = this._list.getAllElements();
        int len = objs.length;
        String files = "";
        int i = 0;
        while (i < len) {
            if (objs[i] != null) {
                Pair p = (Pair)objs[i];
                File f = (File)p.getElement();
                try {
                    files = files + f.getCanonicalPath();
                    files = files + ";";
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            ++i;
        }
        return files;
    }

    public void scan(String pathname) {
        this.scan(pathname, this.MAX_DEPTH);
    }

    private void scan(String pathname, int depth) {
        if (depth == 0) {
            return;
        }
        --depth;
        File file = new File(pathname);
        if (!file.isDirectory()) {
            return;
        }
        File[] files = this.listFiles(file);
        int num_files = files.length;
        String path = "";
        int i = 0;
        while (i < num_files) {
            File f = files[i];
            if (f.isDirectory()) {
                try {
                    path = f.getCanonicalPath();
                    this.addDirectory(path);
                    this.scan(path, depth);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public void scan(String[] pathnames) {
        this.scan(pathnames, this.MAX_DEPTH);
    }

    public void scan(String[] pathnames, int depth) {
        if (depth == 0) {
            return;
        }
        --depth;
        int j = 0;
        while (j < pathnames.length) {
            String pathname = pathnames[j];
            File file = new File(pathname);
            if (file.isDirectory()) {
                File[] files = this.listFiles(file);
                int num_files = files.length;
                int i = 0;
                while (i < num_files) {
                    File f = files[i];
                    String subDirPath = "";
                    if (f.isDirectory()) {
                        try {
                            subDirPath = f.getCanonicalPath();
                            this.addDirectory(subDirPath);
                            this.scan(subDirPath);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private void addDirectory(String pathname) {
        File dir = new File(pathname);
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = this.listFiles(dir);
        int num_files = files.length;
        int mem = 0;
        int num = 0;
        int i = 0;
        while (i < num_files) {
            File f = files[i];
            String name = f.getName();
            if (this.hasExtension(name) && !this.hasFilter(pathname)) {
                mem = (int)((long)mem + f.length());
                ++num;
            }
            ++i;
        }
        int key = this.calculateKey(num, mem);
        this._list.add(new Pair(key, dir), key);
    }

    private int calculateKey(int num_files, int size_files) {
        int key = num_files * this.NUM_WEIGHT + size_files * this.MEM_WEIGHT;
        return key;
    }

    private boolean hasFilter(String pathname) {
        pathname = pathname.toLowerCase();
        int length = this._filters.length;
        String curFilter = "";
        int i = 0;
        while (i < length) {
            curFilter = this._filters[i].toLowerCase();
            if (pathname.indexOf(curFilter) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".") + 1;
        if (begin == -1) {
            return false;
        }
        int end = filename.length();
        String ext = filename.substring(begin, end);
        int length = this._extensions.length;
        int i = 0;
        while (i < length) {
            if (ext.equalsIgnoreCase(this._extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private File[] listFiles(File dir) {
        String[] fnames = dir.list();
        if (fnames == null) {
            return new File[0];
        }
        File[] theFiles = new File[fnames.length];
        int i = 0;
        while (i < fnames.length) {
            theFiles[i] = new File(dir, fnames[i]);
            ++i;
        }
        return theFiles;
    }

    private void print() {
        this._list.print();
    }
}

