/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;

class SaveWindow
extends SetupWindow {
    private LabeledTextField _saveField;
    private JFileChooser _fileChooser = null;

    SaveWindow(SetupManager manager) {
        super(manager, "Save Directory", "Please choose a folder where you would like your files to be downloaded.  This folder will also be shared with other gnutella users by default.");
        BoxPanel mainPanel = new BoxPanel(1);
        this._fileChooser = new JFileChooser();
        this._fileChooser.setFileSelectionMode(1);
        String[] labels = new String[]{"INIT_SAVE_BROWSE_BUTTON_LABEL", "INIT_SAVE_DEFAULT_BUTTON_LABEL"};
        String[] toolTips = new String[]{"INIT_SAVE_BROWSE_BUTTON_TIP", "INIT_SAVE_DEFAULT_BUTTON_TIP"};
        String lblKey = "INIT_SAVE_DIRECTORY_FIELD_LABEL";
        String lbl = GUIMediator.instance().getStringResource(lblKey);
        this._saveField = new LabeledTextField(lbl, 20);
        ActionListener[] listeners = new ActionListener[]{new SaveListener(), new DefaultListener()};
        ButtonRow buttons = new ButtonRow(labels, toolTips, listeners, 0, 12);
        this._saveField.setText(this.getDefault());
        mainPanel.add(this._saveField);
        mainPanel.add(buttons);
        this.addSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        try {
            String saveDirString = this._saveField.getText();
            File saveDir = new File(saveDirString);
            SettingsManager.instance().setSaveDirectory(saveDir);
            SettingsManager.instance().setDirectories(saveDirString + ";");
        }
        catch (IOException ioe) {
            String msgKey = "MESSAGE_INVALID_SAVE_DIRECTORY";
            throw new ApplySettingsException(msgKey);
        }
    }

    private String getDefault() {
        return new File("Shared").getAbsolutePath();
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = SaveWindow.this._fileChooser.showDialog(SaveWindow.this, "Select");
            if (i == 0) {
                File file = SaveWindow.this._fileChooser.getSelectedFile();
                SaveWindow.this._saveField.setText(file.getAbsolutePath());
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SaveWindow.this._saveField.setText(SaveWindow.this.getDefault());
        }
    }
}

