/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class ScanConfirmWindow
extends SetupWindow {
    private final int SHARED_DIRECTORY_LIMIT = 5;
    private JCheckBox[] _dirCheckBoxes = new JCheckBox[5];
    private JPanel _checkBoxPanel;
    private boolean _windowOpened = false;

    ScanConfirmWindow(SetupManager manager) {
        super(manager, "Confirm Scan", "We identified the directories below as ones that you might like to share.  If you would like to share one of these directories, simply check its associated checkbox.  Subdirectories of shared directories will also be shared.");
        BoxPanel mainPanel = new BoxPanel(0);
        this._checkBoxPanel = new BoxPanel(1);
        mainPanel.add(this._checkBoxPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.addSetupComponent(mainPanel);
    }

    public void handleWindowOpeningEvent() {
        this._manager.goToStandardButtons();
        if (!this._windowOpened) {
            String[] dirNames = this._manager.getScannedPaths();
            this.setDirectories(dirNames);
            this._windowOpened = true;
        }
    }

    public void applySettings() throws ApplySettingsException {
        String shared = this.getSelected();
        SettingsManager sm = SettingsManager.instance();
        String dir = sm.getDirectories() + shared;
        sm.setDirectories(dir);
    }

    private String getSelected() {
        String selected = "";
        int i = 0;
        while (i < this._dirCheckBoxes.length) {
            if (this._dirCheckBoxes[i].isSelected()) {
                selected = selected + this._dirCheckBoxes[i].getText() + ";";
            }
            ++i;
        }
        return selected;
    }

    private void setDirectories(String[] dirPaths) {
        int i = 0;
        while (i < dirPaths.length) {
            if (dirPaths[i] != null) {
                this._dirCheckBoxes[i] = new JCheckBox("", false);
                this._dirCheckBoxes[i].setText(dirPaths[i]);
                this._checkBoxPanel.add(this._dirCheckBoxes[i]);
            }
            ++i;
        }
        this._checkBoxPanel.revalidate();
    }
}

