/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.FileScan;
import com.limegroup.gnutella.gui.init.FinishWindow;
import com.limegroup.gnutella.gui.init.SaveWindow;
import com.limegroup.gnutella.gui.init.ScanConfirmWindow;
import com.limegroup.gnutella.gui.init.ScanWindow;
import com.limegroup.gnutella.gui.init.SetupButtons;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.SpeedWindow;
import com.limegroup.gnutella.gui.init.WaitWindow;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SetupManager {
    private JDialog _dialog = new JDialog();
    private SetupButtons _setupButtons;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    private String[] _scannedPaths;
    private boolean _scanned = false;

    public SetupManager() {
        this._dialog.setModal(true);
        if (!CommonUtils.isUnix()) {
            this._dialog.setResizable(false);
        }
        this._dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        });
        Container container = this._dialog.getContentPane();
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        Dimension d = new Dimension(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this._dialog).setLocation((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2);
        WelcomeWindow window0 = new WelcomeWindow(this);
        SaveWindow window1 = new SaveWindow(this);
        SpeedWindow window2 = new SpeedWindow(this);
        ScanWindow window3 = new ScanWindow(this);
        WaitWindow window4 = new WaitWindow(this);
        ScanConfirmWindow window5 = new ScanConfirmWindow(this);
        FinishWindow window6 = new FinishWindow(this);
        window0.setNext(window1);
        window1.setNext(window2);
        window2.setNext(window3);
        window3.setYesWindow(window4);
        window3.setNoWindow(window6);
        window4.setNext(window5);
        window5.setNext(window6);
        window6.setNext(window6);
        window0.setPrevious(window0);
        window1.setPrevious(window0);
        window2.setPrevious(window1);
        window3.setPrevious(window2);
        window4.setPrevious(window3);
        window5.setPrevious(window3);
        window6.setPrevious(window5);
        this._setupWindowHolder = new SetupWindowHolder();
        this._setupWindowHolder.add(window0);
        this._setupWindowHolder.add(window1);
        this._setupWindowHolder.add(window2);
        this._setupWindowHolder.add(window3);
        this._setupWindowHolder.add(window4);
        this._setupWindowHolder.add(window5);
        this._setupWindowHolder.add(window6);
        this.show(window0);
        this._setupButtons = new SetupButtons(this);
        setupPanel.add(this._setupWindowHolder);
        setupPanel.add(Box.createVerticalStrut(17));
        setupPanel.add(this._setupButtons);
        container.add(setupPanel);
        this._dialog.pack();
        ((Component)this._dialog).setVisible(true);
    }

    public void next() {
        SetupWindow newWindow = this._currentWindow.getNext();
        try {
            this._currentWindow.applySettings();
            newWindow.handleWindowOpeningEvent();
            this.show(newWindow);
        }
        catch (ApplySettingsException ase) {
            GUIMediator.instance().showError(ase.getMessage());
        }
    }

    public void previous() {
        SetupWindow newWindow = this._currentWindow.getPrevious();
        newWindow.handleWindowOpeningEvent();
        this.show(newWindow);
    }

    public void scan() {
        if (!this._scanned) {
            this._scannedPaths = this.scanDrive();
            this._scanned = true;
        }
    }

    public String[] getScannedPaths() {
        return this._scannedPaths;
    }

    public void cancelSetup() {
        this._dialog.dispose();
        System.exit(0);
    }

    public void finishSetup() {
        this._dialog.dispose();
        SettingsManager.instance().setInstalled(true);
        SettingsManager.instance().writeProperties();
    }

    public void goToFinishButtons() {
        this._setupButtons.goToFinishButtons();
    }

    public void goToCancelButtons() {
        this._setupButtons.goToCancelButtons();
    }

    public void goToStandardButtons() {
        this._setupButtons.goToStandardButtons();
    }

    private void show(SetupWindow window) {
        String name = window.getName();
        this._setupWindowHolder.show(name);
        this._currentWindow = window;
    }

    private String[] scanDrive() {
        FileScan fs = new FileScan();
        String[] filters = new String[]{"Recycle", "Incomplete", "LimeWire", "Microsoft", "bin", "system", "WINNT"};
        fs.setFilters(filters);
        String currentDir = CommonUtils.getCurrentDirectory();
        File root = this.getRoot(new File(currentDir));
        try {
            fs.scan(root.getCanonicalPath());
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return fs.getListAsArray();
    }

    private File getRoot(File f) {
        String parent = f.getParent();
        if (parent == null) {
            return f;
        }
        return this.getRoot(new File(parent));
    }
}

