/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupLabel;
import com.limegroup.gnutella.gui.init.SetupManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;

abstract class SetupWindow
extends JPanel {
    private int MARGIN = 10;
    private final int SETUP_LEFT_MARGIN = 20;
    private JPanel _innerPanel;
    private String _name;
    private SetupWindow _next;
    private SetupWindow _previous;
    protected SetupManager _manager;

    public SetupWindow(SetupManager manager, String name, String label) {
        this._name = name;
        this._manager = manager;
        this._innerPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this, 1);
        BoxLayout innerLayout = new BoxLayout(this._innerPanel, 1);
        this.setLayout(layout);
        this._innerPanel.setLayout(innerLayout);
        Border border = BorderFactory.createEmptyBorder(this.MARGIN * 2, this.MARGIN, this.MARGIN, this.MARGIN);
        Border innerBorder = BorderFactory.createEmptyBorder(0, 20, 0, 0);
        this.setBorder(border);
        this._innerPanel.setBorder(innerBorder);
        int totalMargin = this.MARGIN * 2;
        Dimension size = new Dimension(500 - totalMargin, 300 - totalMargin);
        this.setPreferredSize(size);
        SetupLabel setupLabel = new SetupLabel(label);
        this.add(setupLabel);
        this.add(this._innerPanel);
    }

    public String getName() {
        return this._name;
    }

    public SetupWindow getNext() {
        return this._next;
    }

    public SetupWindow getPrevious() {
        return this._previous;
    }

    public void setNext(SetupWindow next) {
        this._next = next;
    }

    public void setPrevious(SetupWindow previous) {
        this._previous = previous;
    }

    public void handleWindowOpeningEvent() {
    }

    public void applySettings() throws ApplySettingsException {
    }

    protected void addSetupComponent(Component setupComponent) {
        this._innerPanel.add(setupComponent);
    }
}

